/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.wicket.protocol.http.WicketFilter;
import org.apache.wicket.protocol.http.servlet.ServletWebRequest;
import org.apache.wicket.util.io.Streams;
import org.apache.wicket.util.string.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WicketServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(WicketServlet.class);
    protected WicketFilter wicketFilter;

    public final void doGet(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws ServletException, IOException {
        if (!this.wicketFilter.doGet(servletRequest, servletResponse)) {
            this.fallback(servletRequest, servletResponse);
        }
    }

    public final void doPost(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws ServletException, IOException {
        if (!this.wicketFilter.doGet(servletRequest, servletResponse)) {
            this.fallback(servletRequest, servletResponse);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fallback(HttpServletRequest request, HttpServletResponse response) throws IOException {
        ServletWebRequest req = new ServletWebRequest(request);
        String url = req.getURL();
        if (url.indexOf(63) != -1) {
            url = Strings.beforeFirst(url, '?');
        }
        if (url.length() > 0 && url.charAt(0) != '/' || url.length() == 0) {
            url = '/' + url;
        }
        InputStream stream = this.getServletContext().getResourceAsStream(url);
        String mimeType = this.getServletContext().getMimeType(url);
        if (stream == null) {
            response.sendError(404);
        } else {
            if (mimeType != null) {
                response.setContentType(mimeType);
            }
            try {
                Streams.copy(stream, (OutputStream)response.getOutputStream());
            }
            finally {
                stream.close();
            }
        }
    }

    public void init() throws ServletException {
        this.wicketFilter = this.newWicketFilter();
        this.wicketFilter.init(new FilterConfig(){

            public ServletContext getServletContext() {
                return WicketServlet.this.getServletContext();
            }

            public Enumeration<String> getInitParameterNames() {
                return WicketServlet.this.getInitParameterNames();
            }

            public String getInitParameter(String name) {
                if ("filterMappingUrlPattern".equals(name)) {
                    return "<servlet>";
                }
                return WicketServlet.this.getInitParameter(name);
            }

            public String getFilterName() {
                return WicketServlet.this.getServletName();
            }
        });
    }

    protected WicketFilter newWicketFilter() {
        return new WicketFilter();
    }

    public void destroy() {
        this.wicketFilter.destroy();
        this.wicketFilter = null;
    }

    protected long getLastModified(HttpServletRequest servletRequest) {
        return this.wicketFilter.getLastModified(servletRequest);
    }
}

