/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.http;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.protocol.http.WebRequest;
import org.apache.wicket.protocol.http.WicketURLDecoder;
import org.apache.wicket.protocol.http.WicketURLEncoder;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.util.value.ValueMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RequestUtils {
    public static void decodeParameters(String queryString, ValueMap params) {
        String[] paramTuples = queryString.split("&");
        for (int t = 0; t < paramTuples.length; ++t) {
            String[] bits = paramTuples[t].split("=");
            if (bits.length == 2) {
                params.add(WicketURLDecoder.QUERY_INSTANCE.decode(bits[0]), WicketURLDecoder.QUERY_INSTANCE.decode(bits[1]));
                continue;
            }
            params.add(WicketURLDecoder.QUERY_INSTANCE.decode(bits[0]), "");
        }
    }

    public static void decodeUrlParameters(String queryString, Map<String, String[]> parameters) {
        HashMap<String, ArrayList<String>> temp = new HashMap<String, ArrayList<String>>();
        String[] paramTuples = queryString.split("&");
        for (int t = 0; t < paramTuples.length; ++t) {
            String[] bits = paramTuples[t].split("=");
            String key = WicketURLDecoder.QUERY_INSTANCE.decode(bits[0]);
            String value = bits.length == 2 ? WicketURLDecoder.QUERY_INSTANCE.decode(bits[1]) : "";
            ArrayList<String> l = (ArrayList<String>)temp.get(key);
            if (l == null) {
                l = new ArrayList<String>();
                temp.put(key, l);
            }
            l.add(value);
        }
        for (Map.Entry entry : temp.entrySet()) {
            String[] s = new String[((List)entry.getValue()).size()];
            ((List)entry.getValue()).toArray(s);
            parameters.put((String)entry.getKey(), s);
        }
    }

    static String removeDoubleDots(String path) {
        ArrayList<String> newcomponents = new ArrayList<String>(Arrays.asList(path.split("/")));
        for (int i = 0; i < newcomponents.size(); ++i) {
            if (i >= newcomponents.size() - 1 || ((String)newcomponents.get(i)).length() <= 0 || !((String)newcomponents.get(i + 1)).equals("..")) continue;
            newcomponents.remove(i);
            newcomponents.remove(i);
            if ((i -= 2) >= -1) continue;
            i = -1;
        }
        String newpath = Strings.join("/", newcomponents.toArray(new String[0]));
        if (path.endsWith("/")) {
            return newpath + "/";
        }
        return newpath;
    }

    private RequestUtils() {
    }

    @Deprecated
    public static String decode(String path) {
        return WicketURLDecoder.QUERY_INSTANCE.decode(path);
    }

    @Deprecated
    public static String encode(String value) {
        return WicketURLEncoder.QUERY_INSTANCE.encode(value);
    }

    public static final String toAbsolutePath(String relativePagePath) {
        HttpServletRequest req = ((WebRequest)RequestCycle.get().getRequest()).getHttpServletRequest();
        return RequestUtils.toAbsolutePath(req.getRequestURL().toString(), relativePagePath);
    }

    public static final String toAbsolutePath(String requestPath, String relativePagePath) {
        StringBuffer result = requestPath.endsWith("/") ? new StringBuffer(requestPath) : new StringBuffer(requestPath.substring(0, requestPath.lastIndexOf(47) + 1));
        if (relativePagePath.startsWith("./")) {
            relativePagePath = relativePagePath.substring(2);
        }
        if (relativePagePath.startsWith("../")) {
            StringBuffer tempRelative = new StringBuffer(relativePagePath);
            while (tempRelative.indexOf("../") == 0) {
                tempRelative.delete(0, 3);
                if (RequestCycle.get() != null && (RequestCycle.get() == null || ((WebRequest)RequestCycle.get().getRequest()).isAjax())) continue;
                result.setLength(result.length() - 1);
                result.delete(result.lastIndexOf("/") + 1, result.length());
            }
            result.append(tempRelative);
        } else {
            result.append(relativePagePath);
        }
        return result.toString();
    }
}

