/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.image;

import org.apache.wicket.Component;
import org.apache.wicket.behavior.AbstractBehavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextPathGenerator
extends AbstractBehavior {
    private static final long serialVersionUID = 1L;
    private final IModel<String> contextRelativePath;

    public ContextPathGenerator(IModel<String> contextRelativePath) {
        this.contextRelativePath = contextRelativePath;
    }

    public ContextPathGenerator(String contextRelativePath) {
        this.contextRelativePath = new Model<String>(contextRelativePath);
    }

    @Override
    public void onComponentTag(Component component, ComponentTag tag) {
        String path = this.contextRelativePath.getObject();
        String rewritten = component.getRequestCycle().getProcessor().getRequestCodingStrategy().rewriteStaticRelativeUrl(path);
        tag.put("src", rewritten);
    }

    @Override
    public void detach(Component component) {
        this.contextRelativePath.detach();
        super.detach(component);
    }
}

