/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ows.util;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.geoserver.ows.util.ClassProperties;
import org.geoserver.ows.util.OwsUtils;
import org.geotools.util.logging.Logging;

public class RequestObjectLogger
implements MethodInterceptor {
    Logger logger;

    public RequestObjectLogger(String logPackage) {
        this.logger = Logging.getLogger((String)logPackage);
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        if (!this.logger.isLoggable(Level.INFO)) {
            return invocation.proceed();
        }
        StringBuffer log = new StringBuffer();
        log.append("\nRequest: " + invocation.getMethod().getName());
        if (invocation.getArguments().length > 0) {
            Object requestBean = null;
            for (int i = 0; i < invocation.getArguments().length; ++i) {
                Object argument = invocation.getArguments()[i];
                if (!this.isRequestObject(argument)) continue;
                requestBean = argument;
                break;
            }
            if (requestBean != null) {
                this.log(requestBean, 1, log);
            }
        }
        Object result = invocation.proceed();
        this.logger.info(log.toString());
        return result;
    }

    protected boolean isRequestObject(Object obj) {
        return true;
    }

    protected void log(Object object, int level, StringBuffer log) {
        ClassProperties props = OwsUtils.getClassProperties(object.getClass());
        for (String prop : props.properties()) {
            if ("class".equalsIgnoreCase(prop)) continue;
            Object value = OwsUtils.get(object, prop);
            log.append("\n");
            for (int i = 0; i < level; ++i) {
                log.append("\t");
            }
            log.append(prop).append(" = ").append(value);
        }
    }
}

