/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ows.kvp;

import org.geoserver.ows.KvpParser;
import org.springframework.util.Assert;

public class EnumKvpParser
extends KvpParser {
    public EnumKvpParser(String key, Class<?> enumClass) {
        super(key, enumClass);
        Assert.isTrue((boolean)enumClass.isEnum(), (String)(enumClass.getName() + " is not an enum class"));
    }

    @Override
    public Object parse(String value) throws Exception {
        T[] enumConstants;
        Class enumClass = this.getBinding();
        for (Object enumValue : enumConstants = enumClass.getEnumConstants()) {
            if (!enumValue.toString().equalsIgnoreCase(value)) continue;
            return enumValue;
        }
        return null;
    }
}

