/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ows.kvp;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.logging.Level;
import org.geoserver.ows.KvpParser;
import org.geoserver.platform.GeoServerExtensions;
import org.geotools.util.DateRange;
import org.geotools.util.NumberRange;
import org.geotools.util.Range;

public class ElevationKvpParser
extends KvpParser {
    private static final int MAX_ELEMENTS_ELEVATIONS_KVP;
    private static final int DEFAULT_MAX_ELEMENTS_ELEVATIONS_KVP = 100;

    public ElevationKvpParser(String key) {
        super(key, List.class);
    }

    @Override
    public Object parse(String value) throws ParseException {
        String[] listValues;
        if (value == null) {
            return Collections.emptyList();
        }
        if ((value = value.trim()).length() == 0) {
            return Collections.emptyList();
        }
        TreeSet values = new TreeSet(new Comparator(){

            public int compare(Object o1, Object o2) {
                boolean o1Double = o1 instanceof Double;
                boolean o2Double = o2 instanceof Double;
                if (o1Double) {
                    Double left = (Double)o1;
                    if (o2Double) {
                        return left.compareTo((Double)o2);
                    }
                    return left.compareTo((Double)((NumberRange)o2).getMinValue());
                }
                NumberRange left = (NumberRange)o1;
                if (o2Double) {
                    return left.getMinValue().compareTo((Double)o2);
                }
                return left.getMinValue().compareTo(((NumberRange)o2).getMinValue());
            }
        });
        block0: for (String d : listValues = value.split(",")) {
            Double end;
            Double begin;
            if (d.indexOf("/") <= 0) {
                this.addValue(values, Double.valueOf(d.trim()));
                continue;
            }
            String[] period = d.split("/");
            if (period.length == 2) {
                begin = Double.valueOf(period[0]);
                end = Double.valueOf(period[1]);
                this.addPeriod(values, (NumberRange<Double>)NumberRange.create((double)begin, (double)end));
                continue;
            }
            if (period.length == 3) {
                begin = Double.valueOf(period[0]);
                end = Double.valueOf(period[1]);
                Double increment = Double.valueOf(period[2]);
                int j = 0;
                do {
                    Double d2;
                    Double step = (double)j * increment + begin;
                    if (!(d2 <= end)) continue block0;
                    this.addValue(values, step);
                } while (++j < MAX_ELEMENTS_ELEVATIONS_KVP);
                if (!LOGGER.isLoggable(Level.INFO)) continue;
                LOGGER.info("Lmiting number of elements in this periodo to " + MAX_ELEMENTS_ELEVATIONS_KVP);
                continue;
            }
            throw new ParseException("Invalid elevation parameter: " + period, 0);
        }
        return new ArrayList(values);
    }

    private void addValue(Collection result, Double step) {
        for (Object element : result) {
            Double local;
            if (!(element instanceof Double ? (local = (Double)element).equals(step) : (local = (DateRange)element).contains(step))) continue;
            return;
        }
        result.add(step);
    }

    private void addPeriod(Collection result, NumberRange<Double> newRange) {
        Iterator it = result.iterator();
        while (it.hasNext()) {
            Object element = it.next();
            if (element instanceof Double) {
                if (!newRange.contains((Number)element)) continue;
                it.remove();
                continue;
            }
            NumberRange local = (NumberRange)element;
            if (local.contains(newRange)) {
                return;
            }
            if (!newRange.contains((Range)local)) continue;
            it.remove();
        }
        result.add(newRange);
    }

    static {
        String value = GeoServerExtensions.getProperty((String)"MAX_ELEMENTS_ELEVATIONS_KVP");
        if (value == null) {
            MAX_ELEMENTS_ELEVATIONS_KVP = 100;
        } else {
            int iVal = -1;
            try {
                iVal = Integer.parseInt(value.trim());
            }
            catch (Exception e) {
                iVal = 100;
            }
            MAX_ELEMENTS_ELEVATIONS_KVP = iVal;
        }
    }
}

