/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ows;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLDecoder;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.geoserver.ows.AbstractURLPublisher;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geotools.data.DataUtilities;
import org.springframework.web.context.support.ServletContextResource;
import org.springframework.web.context.support.ServletContextResourceLoader;

public class FilePublisher
extends AbstractURLPublisher {
    protected GeoServerResourceLoader loader;
    protected ServletContextResourceLoader scloader;

    public FilePublisher(GeoServerResourceLoader loader) {
        this.loader = loader;
    }

    protected void initServletContext(ServletContext servletContext) {
        this.scloader = new ServletContextResourceLoader(servletContext);
    }

    @Override
    protected URL getUrl(HttpServletRequest request) throws IOException {
        ServletContextResource resource;
        File file;
        String ctxPath = request.getContextPath();
        String reqPath = request.getRequestURI();
        reqPath = URLDecoder.decode(reqPath, "UTF-8");
        if ((reqPath = reqPath.substring(ctxPath.length())).length() > 1 && reqPath.startsWith("/")) {
            reqPath = reqPath.substring(1);
        }
        if ((file = this.loader.find(reqPath)) == null && this.scloader != null && (resource = (ServletContextResource)this.scloader.getResource(reqPath)) != null && resource.exists()) {
            file = resource.getFile();
        }
        if (file != null) {
            return DataUtilities.fileToURL((File)file);
        }
        return null;
    }
}

