/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.process;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.geotools.data.Parameter;
import org.geotools.factory.FactoryCreator;
import org.geotools.factory.FactoryFinder;
import org.geotools.factory.FactoryRegistry;
import org.geotools.process.Process;
import org.geotools.process.ProcessExecutor;
import org.geotools.process.ProcessFactory;
import org.geotools.process.ThreadPoolProcessExecutor;
import org.geotools.resources.LazySet;
import org.geotools.util.NullProgressListener;
import org.opengis.feature.type.Name;
import org.opengis.util.ProgressListener;

public class Processors
extends FactoryFinder {
    private static FactoryRegistry registry;
    static ProcessFactory lastFactory;

    private Processors() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FactoryRegistry getServiceRegistry() {
        Class<Processors> clazz = Processors.class;
        synchronized (Processors.class) {
            if (registry == null) {
                registry = new FactoryCreator(ProcessFactory.class);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return registry;
        }
    }

    public static void addProcessFactory(ProcessFactory factory) {
        Processors.getServiceRegistry().registerServiceProvider((Object)factory);
    }

    public static void removeProcessFactory(ProcessFactory factory) {
        if (lastFactory == factory) {
            lastFactory = null;
        }
        Processors.getServiceRegistry().deregisterServiceProvider((Object)factory);
    }

    public static Set<ProcessFactory> getProcessFactories() {
        Iterator serviceProviders = Processors.getServiceRegistry().getServiceProviders(ProcessFactory.class, null, null);
        return new LazySet(serviceProviders);
    }

    public static synchronized ProcessFactory createProcessFactory(Name name) {
        ProcessFactory last = lastFactory;
        if (last != null && last.getNames().contains(name)) {
            return last;
        }
        for (ProcessFactory factory : Processors.getProcessFactories()) {
            if (!factory.getNames().contains(name)) continue;
            lastFactory = factory;
            return factory;
        }
        return null;
    }

    public static synchronized Process createProcess(Name name) {
        ProcessFactory factory = Processors.createProcessFactory(name);
        if (factory == null) {
            return null;
        }
        return factory.create(name);
    }

    public static synchronized Map<String, Parameter<?>> getParameterInfo(Name name) {
        ProcessFactory factory = Processors.createProcessFactory(name);
        if (factory == null) {
            return null;
        }
        return factory.getParameterInfo(name);
    }

    public static synchronized Map<String, Parameter<?>> getResultInfo(Name name, Map<String, Object> parameters) {
        ProcessFactory factory = Processors.createProcessFactory(name);
        if (factory == null) {
            return null;
        }
        return factory.getResultInfo(name, parameters);
    }

    public static Callable<Map<String, Object>> createCallable(final Process process, final Map<String, Object> input) {
        return new Callable<Map<String, Object>>(){

            @Override
            public Map<String, Object> call() throws Exception {
                return process.execute(input, (ProgressListener)new CallableProgressListener());
            }
        };
    }

    public static ProcessExecutor newProcessExecutor(int nThreads) {
        return Processors.newProcessExecutor(nThreads, Executors.defaultThreadFactory());
    }

    public static ProcessExecutor newProcessExecutor(int nThreads, ThreadFactory threadFactory) {
        if (threadFactory == null) {
            threadFactory = Executors.defaultThreadFactory();
        }
        return new ThreadPoolProcessExecutor(nThreads, threadFactory);
    }

    public static synchronized void reset() {
        if (registry == null) {
            return;
        }
        registry.deregisterAll();
        registry.scanForPlugins();
        lastFactory = null;
    }

    static class CallableProgressListener
    extends NullProgressListener {
        CallableProgressListener() {
        }

        public boolean isCanceled() {
            return Thread.currentThread().isInterrupted();
        }
    }
}

