/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic.properties.time;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.gce.imagemosaic.properties.PropertiesCollectorSPI;
import org.geotools.gce.imagemosaic.properties.RegExPropertiesCollector;
import org.geotools.gce.imagemosaic.properties.time.TimeParser;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeature;

class TimestampFileNameExtractor
extends RegExPropertiesCollector {
    private static final Logger LOGGER = Logging.getLogger(TimestampFileNameExtractor.class);
    private static final TimeParser parser = new TimeParser();
    private DateFormat customFormat;

    public TimestampFileNameExtractor(PropertiesCollectorSPI spi, List<String> propertyNames, String regex, String format) {
        this(spi, propertyNames, regex, format, false);
    }

    public TimestampFileNameExtractor(PropertiesCollectorSPI spi, List<String> propertyNames, String regex, String format, boolean fullPath) {
        super(spi, propertyNames, regex, fullPath);
        if (format != null) {
            this.customFormat = new SimpleDateFormat(format);
            this.customFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        }
    }

    @Override
    public void setProperties(SimpleFeature feature) {
        ArrayList<Object> dates = new ArrayList<Object>();
        for (String match : this.getMatches()) {
            try {
                Object parsed;
                if (this.customFormat != null) {
                    parsed = this.customFormat.parse(match);
                    dates.add(parsed);
                    continue;
                }
                parsed = parser.parse(match);
                dates.addAll((Collection<Object>)parsed);
            }
            catch (ParseException e) {
                if (!LOGGER.isLoggable(Level.FINE)) continue;
                LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
            }
        }
        if (dates.size() <= 0) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("No matches found for this property extractor:");
            }
            throw new IllegalArgumentException("No matches found for this property extractor");
        }
        int index = 0;
        for (String propertyName : this.getPropertyNames()) {
            feature.setAttribute(propertyName, dates.get(index++));
            if (index < dates.size()) continue;
            return;
        }
    }
}

