/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic.properties;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.geotools.gce.imagemosaic.properties.PropertiesCollector;
import org.geotools.gce.imagemosaic.properties.PropertiesCollectorSPI;
import org.geotools.util.logging.Logging;

public abstract class RegExPropertiesCollector
extends PropertiesCollector {
    private static final Logger LOGGER = Logging.getLogger(RegExPropertiesCollector.class);
    private boolean fullPath = false;
    private Pattern pattern;

    public boolean isFullPath() {
        return this.fullPath;
    }

    public void setFullPath(boolean fullPath) {
        this.fullPath = fullPath;
    }

    @Deprecated
    public RegExPropertiesCollector(PropertiesCollectorSPI spi, List<String> propertyNames, String regex) {
        this(spi, propertyNames, regex, false);
    }

    public RegExPropertiesCollector(PropertiesCollectorSPI spi, List<String> propertyNames, String regex, boolean fullPath) {
        super(spi, propertyNames);
        this.fullPath = fullPath;
        this.pattern = Pattern.compile(regex);
    }

    @Override
    public RegExPropertiesCollector collect(File file) {
        super.collect(file);
        String absolutePath = file.getAbsolutePath();
        String name = this.fullPath ? absolutePath : FilenameUtils.getBaseName((String)absolutePath);
        Matcher matcher = this.pattern.matcher(name);
        while (matcher.find()) {
            if (!this.fullPath) {
                this.addMatch(matcher.group());
                continue;
            }
            int count = matcher.groupCount();
            String match = "";
            for (int i = 1; i <= count; ++i) {
                match = match + matcher.group(i);
            }
            this.addMatch(match);
        }
        return this;
    }

    @Override
    public void setProperties(Map<String, Object> map) {
        List<String> matches = this.getMatches();
        if (matches.size() <= 0 && LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("No matches found for this property extractor:");
        }
        int index = 0;
        for (String propertyName : this.getPropertyNames()) {
            map.put(propertyName, matches.get(index++));
            if (index < matches.size()) continue;
            return;
        }
    }
}

