/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic.catalog.postgis;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.data.transform.Definition;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.filter.text.ecql.ECQL;
import org.geotools.gce.imagemosaic.catalog.oracle.FeatureTypeMapper;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.GeometryType;
import org.opengis.feature.type.Name;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class PostgisFeatureTypeMapper
implements FeatureTypeMapper {
    private int srID = 0;
    private static final int MAX_LENGTH = 63;
    private Name originalName;
    private String mappedName;
    private CoordinateReferenceSystem coordinateReferenceSystem;
    private List<Definition> definitions;
    private SimpleFeatureType wrappedFeatureType;
    private SimpleFeatureType postgisFeatureType;
    private Map<Name, Definition> definitionsMapping;
    private SimpleFeatureSource simpleFeatureSource;

    @Override
    public Name getName() {
        return this.originalName;
    }

    @Override
    public String getMappedName() {
        return this.mappedName;
    }

    @Override
    public List<Definition> getDefinitions() {
        return this.definitions;
    }

    @Override
    public SimpleFeatureType getMappedFeatureType() {
        return this.postgisFeatureType;
    }

    @Override
    public SimpleFeatureType getWrappedFeatureType() {
        return this.wrappedFeatureType;
    }

    @Override
    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.coordinateReferenceSystem;
    }

    @Override
    public SimpleFeatureSource getSimpleFeatureSource() {
        return this.simpleFeatureSource;
    }

    int getSrID() {
        return this.srID;
    }

    void setSrID(int srID) {
        this.srID = srID;
    }

    public PostgisFeatureTypeMapper(SimpleFeatureType featureType) throws CQLException {
        this.wrappedFeatureType = featureType;
        this.originalName = featureType.getName();
        this.mappedName = this.originalName.getLocalPart();
        this.mappedName = this.remap(this.mappedName);
        List attributes = featureType.getAttributeDescriptors();
        this.definitions = new LinkedList<Definition>();
        this.definitionsMapping = new HashMap<Name, Definition>();
        for (AttributeDescriptor attribute : attributes) {
            String originalAttribute = attribute.getLocalName();
            AttributeType type = attribute.getType();
            Class binding = type.getBinding();
            String attributeName = this.remap(originalAttribute);
            Definition definition = new Definition(originalAttribute, ECQL.toExpression((String)attributeName), binding);
            this.definitions.add(definition);
            this.definitionsMapping.put(attribute.getName(), definition);
        }
        this.remapFeatureType();
    }

    private void remapFeatureType() {
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        tb.setName(this.mappedName);
        List descriptors = this.wrappedFeatureType.getAttributeDescriptors();
        for (AttributeDescriptor descriptor : descriptors) {
            Name name = descriptor.getName();
            Definition definition = this.definitionsMapping.get(name);
            AttributeType type = descriptor.getType();
            if (type instanceof GeometryType) {
                this.coordinateReferenceSystem = ((GeometryType)type).getCoordinateReferenceSystem();
                Map userData = descriptor.getUserData();
                if (userData != null && !userData.isEmpty()) {
                    Set keys = userData.keySet();
                    for (Object key : keys) {
                        String id;
                        Object value = userData.get(key);
                        tb.userData(key, value);
                        if (!(key instanceof String) || !(id = (String)key).equalsIgnoreCase("nativeSRID") || value == null) continue;
                        this.srID = (Integer)value;
                    }
                }
                tb.add(definition.getExpression().toString(), definition.getBinding(), this.coordinateReferenceSystem);
                continue;
            }
            tb.add(definition.getExpression().toString(), definition.getBinding());
        }
        this.postgisFeatureType = tb.buildFeatureType();
    }

    void setSimpleFeatureSource(SimpleFeatureSource simpleFeatureSource) {
        this.simpleFeatureSource = simpleFeatureSource;
    }

    @Override
    public String remap(String name) {
        String mappedName = name;
        mappedName = mappedName.length() >= 63 ? mappedName.substring(0, 63) : mappedName;
        return mappedName;
    }
}

