/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic.catalog.oracle;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;
import org.geotools.data.DataStore;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureWriter;
import org.geotools.data.LockingManager;
import org.geotools.data.Query;
import org.geotools.data.ServiceInfo;
import org.geotools.data.Transaction;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.data.simple.SimpleFeatureStore;
import org.geotools.data.transform.Definition;
import org.geotools.data.transform.TransformFactory;
import org.geotools.feature.NameImpl;
import org.geotools.gce.imagemosaic.catalog.oracle.FeatureTypeMapper;
import org.geotools.referencing.CRS;
import org.geotools.util.Utilities;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public abstract class DataStoreWrapper
implements DataStore {
    protected static final String HIDDEN_FOLDER = ".mosaic";
    protected static final String NAME = "NAME";
    protected static final String MAPPEDNAME = "MAPPEDNAME";
    protected static final String SCHEMA = "SCHEMA";
    protected static final String COORDINATE_REFERENCE_SYSTEM = "CRS";
    protected static final Logger LOGGER = Logging.getLogger(DataStoreWrapper.class);
    protected File auxiliaryFolder;
    protected final DataStore datastore;
    protected final Map<Name, FeatureTypeMapper> mapping = new ConcurrentHashMap<Name, FeatureTypeMapper>();
    private List<String> typeNames = new ArrayList<String>();

    public DataStoreWrapper(DataStore datastore, String auxFolderPath) {
        this(datastore, auxFolderPath, HIDDEN_FOLDER);
    }

    public DataStoreWrapper(DataStore datastore, String auxFolderPath, String subFolderName) {
        this.datastore = datastore;
        this.initMapping(auxFolderPath + File.separatorChar + subFolderName);
    }

    private void initMapping(String auxFolderPath) {
        block9: {
            try {
                URL url = new URL(auxFolderPath);
                File file = DataUtilities.urlToFile(url);
                if (!file.exists()) {
                    file.mkdir();
                } else if (file.isDirectory() || file.canRead()) {
                    this.loadMappers(file);
                } else if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.warning("The specified config folder for datastore wrapping can't be read or isn't a directory: " + auxFolderPath);
                }
                this.auxiliaryFolder = file;
            }
            catch (MalformedURLException e) {
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.warning("The specified config folder for datastore wrapping is not valid: " + auxFolderPath);
                }
            }
            catch (Exception e) {
                if (!LOGGER.isLoggable(Level.SEVERE)) break block9;
                LOGGER.severe("Unable to initialize the wrapping mapping for this folder: " + auxFolderPath);
            }
        }
    }

    private void loadMappers(File file) throws Exception {
        String[] files = file.list();
        String parentPath = file.getAbsolutePath();
        for (String element : files) {
            Properties properties = DataStoreWrapper.loadProperties(parentPath + File.separatorChar + element);
            FeatureTypeMapper mapper = this.getFeatureTypeMapper(properties);
            Name name = mapper.getName();
            this.mapping.put(name, mapper);
            this.typeNames.add(name.getLocalPart());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Properties loadProperties(String propertiesFile) {
        BufferedInputStream inStream = null;
        Properties properties = new Properties();
        try {
            File propertiesFileP = new File(propertiesFile);
            inStream = new BufferedInputStream(new FileInputStream(propertiesFileP));
            properties.load(inStream);
            if (inStream == null) return properties;
        }
        catch (FileNotFoundException e) {
            if (!LOGGER.isLoggable(Level.WARNING)) return properties;
            LOGGER.warning("Unable to store the mapping " + e.getLocalizedMessage());
            return properties;
        }
        catch (IOException e2) {
            if (!LOGGER.isLoggable(Level.WARNING)) return properties;
            LOGGER.warning("Unable to store the mapping " + e2.getLocalizedMessage());
            return properties;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (inStream != null) {
                IOUtils.closeQuietly(inStream);
            }
        }
        IOUtils.closeQuietly((InputStream)inStream);
        return properties;
    }

    @Override
    public ServiceInfo getInfo() {
        return null;
    }

    @Override
    public void createSchema(SimpleFeatureType featureType) throws IOException {
        if (featureType != null) {
            Name name = featureType.getName();
            try {
                FeatureTypeMapper mapper = this.getFeatureTypeMapper(featureType);
                SimpleFeatureType mappedFeatureType = mapper.getMappedFeatureType();
                this.datastore.createSchema(mappedFeatureType);
                this.mapping.put(name, mapper);
                this.typeNames.add(name.getLocalPart());
                this.storeMapper(mapper);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void storeProperties(Properties properties, String typeName) {
        BufferedOutputStream outStream = null;
        try {
            String propertiesPath = this.auxiliaryFolder.getAbsolutePath() + File.separatorChar + typeName + ".properties";
            outStream = new BufferedOutputStream(new FileOutputStream(new File(propertiesPath)));
            properties.store(outStream, null);
            if (outStream == null) return;
        }
        catch (FileNotFoundException e) {
            if (!LOGGER.isLoggable(Level.WARNING)) return;
            LOGGER.warning("Unable to store the mapping " + e.getLocalizedMessage());
            return;
        }
        catch (IOException e2) {
            if (!LOGGER.isLoggable(Level.WARNING)) return;
            LOGGER.warning("Unable to store the mapping " + e2.getLocalizedMessage());
            return;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (outStream != null) {
                IOUtils.closeQuietly(outStream);
            }
        }
        IOUtils.closeQuietly((OutputStream)outStream);
        return;
    }

    @Override
    public void updateSchema(Name typeName, SimpleFeatureType featureType) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Name> getNames() throws IOException {
        return new ArrayList<Name>(this.mapping.keySet());
    }

    @Override
    public SimpleFeatureType getSchema(Name name) throws IOException {
        FeatureTypeMapper mapper;
        if (this.mapping.containsKey(name) && (mapper = this.mapping.get(name)) != null) {
            return mapper.getWrappedFeatureType();
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("No schema found for that name: " + name + "\nNo mappers available");
        }
        return null;
    }

    @Override
    public SimpleFeatureType getSchema(String typeName) throws IOException {
        return this.getSchema(new NameImpl(typeName));
    }

    @Override
    public void dispose() {
        this.datastore.dispose();
    }

    @Override
    public void updateSchema(String typeName, SimpleFeatureType featureType) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeSchema(Name typeName) throws IOException {
        FeatureTypeMapper mapper = this.getMapper(typeName);
        if (mapper == null) {
            throw new IOException("No wrapper found for " + typeName);
        }
        String mappedName = mapper.getMappedName();
        this.datastore.removeSchema(mappedName);
    }

    @Override
    public void removeSchema(String typeName) throws IOException {
        this.removeSchema(new NameImpl(typeName));
    }

    @Override
    public String[] getTypeNames() throws IOException {
        return this.typeNames != null ? this.typeNames.toArray(new String[this.typeNames.size()]) : null;
    }

    @Override
    public SimpleFeatureSource getFeatureSource(String typeName) throws IOException {
        Utilities.ensureNonNull((String)"typeName", (Object)typeName);
        return this.getFeatureSource(new NameImpl(typeName));
    }

    @Override
    public SimpleFeatureSource getFeatureSource(Name typeName) throws IOException {
        FeatureTypeMapper mapper = this.getMapper(typeName);
        if (mapper == null) {
            throw new IOException("No wrapper found for " + typeName);
        }
        SimpleFeatureStore source = (SimpleFeatureStore)this.datastore.getFeatureSource(mapper.getMappedName());
        if (source == null) {
            throw new IOException("No feature source available for " + typeName);
        }
        return this.transformFeatureStore(source, mapper);
    }

    protected SimpleFeatureSource transformFeatureStore(SimpleFeatureStore source, FeatureTypeMapper mapper) throws IOException {
        return TransformFactory.transform((SimpleFeatureSource)source, (Name)mapper.getName(), mapper.getDefinitions());
    }

    @Override
    public FeatureReader<SimpleFeatureType, SimpleFeature> getFeatureReader(Query query, Transaction transaction) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriter(String typeName, Filter filter, Transaction transaction) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriter(String typeName, Transaction transaction) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriterAppend(String typeName, Transaction transaction) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public LockingManager getLockingManager() {
        return this.datastore.getLockingManager();
    }

    private FeatureTypeMapper getMapper(Name typeName) {
        FeatureTypeMapper mapper = null;
        Utilities.ensureNonNull((String)"typeName", (Object)typeName);
        if (this.mapping.containsKey(typeName)) {
            mapper = this.mapping.get(typeName);
        }
        return mapper;
    }

    protected void storeMapper(FeatureTypeMapper mapper) {
        Properties properties = new Properties();
        String typeName = mapper.getName().toString();
        properties.setProperty(NAME, typeName);
        properties.setProperty(MAPPEDNAME, mapper.getMappedName().toString());
        List<Definition> definitions = mapper.getDefinitions();
        StringBuilder builder = new StringBuilder();
        for (Definition definition : definitions) {
            builder.append(definition.getName()).append(":").append(definition.getBinding().getName()).append(",");
        }
        String schema = builder.toString();
        schema = schema.substring(0, schema.length() - 1);
        properties.setProperty(SCHEMA, schema);
        properties.setProperty(COORDINATE_REFERENCE_SYSTEM, mapper.getCoordinateReferenceSystem().toWKT());
        this.storeProperties(properties, typeName);
    }

    protected FeatureTypeMapper getFeatureTypeMapper(Properties props) throws Exception {
        SimpleFeatureType indexSchema = DataUtilities.createType(props.getProperty(NAME), props.getProperty(SCHEMA));
        CoordinateReferenceSystem crs = CRS.parseWKT((String)props.getProperty(COORDINATE_REFERENCE_SYSTEM));
        indexSchema = DataUtilities.createSubType(indexSchema, DataUtilities.attributeNames(indexSchema), crs);
        return this.getFeatureTypeMapper(indexSchema);
    }

    protected abstract FeatureTypeMapper getFeatureTypeMapper(SimpleFeatureType var1) throws Exception;
}

