/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic.catalog.index;

import java.io.File;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBException;
import org.geotools.data.DataUtilities;
import org.geotools.gce.imagemosaic.Utils;
import org.geotools.gce.imagemosaic.catalog.index.AttributeType;
import org.geotools.gce.imagemosaic.catalog.index.DomainType;
import org.geotools.gce.imagemosaic.catalog.index.DomainsType;
import org.geotools.gce.imagemosaic.catalog.index.Indexer;
import org.geotools.gce.imagemosaic.catalog.index.ParametersType;
import org.geotools.gce.imagemosaic.catalog.index.SchemaType;
import org.geotools.gce.imagemosaic.catalog.index.SchemasType;
import org.geotools.util.Utilities;
import org.geotools.util.logging.Logging;

public class IndexerUtils {
    private static final Logger LOGGER = Logging.getLogger((String)IndexerUtils.class.toString());

    public static void setPropertyCollectors(Indexer indexer, String propertyCollectors) {
        Indexer.Collectors collectors = Utils.OBJECT_FACTORY.createIndexerCollectors();
        indexer.setCollectors(collectors);
        List<Indexer.Collectors.Collector> collectorList = collectors.getCollector();
        propertyCollectors = propertyCollectors.trim();
        if (propertyCollectors != null && propertyCollectors.length() > 0) {
            String[] propColls;
            for (String pcDef : propColls = propertyCollectors.split(",")) {
                int squareLPos = pcDef.indexOf("[");
                int squareRPos = pcDef.indexOf("]");
                int squareRPosLast = pcDef.lastIndexOf("]");
                int roundLPos = pcDef.indexOf("(");
                int roundRPos = pcDef.indexOf(")");
                int roundRPosLast = pcDef.lastIndexOf(")");
                if (squareRPos != squareRPosLast) {
                    if (!LOGGER.isLoggable(Level.INFO)) continue;
                    LOGGER.info("Skipping unparseable PropertyCollector definition: " + pcDef);
                    continue;
                }
                if (squareLPos == -1 || squareRPos == -1) {
                    if (!LOGGER.isLoggable(Level.INFO)) continue;
                    LOGGER.info("Skipping unparseable PropertyCollector definition: " + pcDef);
                    continue;
                }
                if (squareLPos == 0) {
                    if (!LOGGER.isLoggable(Level.INFO)) continue;
                    LOGGER.info("Skipping unparseable PropertyCollector definition: " + pcDef);
                    continue;
                }
                if (roundRPos != roundRPosLast) {
                    if (!LOGGER.isLoggable(Level.INFO)) continue;
                    LOGGER.info("Skipping unparseable PropertyCollector definition: " + pcDef);
                    continue;
                }
                if (roundLPos == -1 || roundRPos == -1) {
                    if (!LOGGER.isLoggable(Level.INFO)) continue;
                    LOGGER.info("Skipping unparseable PropertyCollector definition: " + pcDef);
                    continue;
                }
                if (roundLPos == 0) {
                    if (!LOGGER.isLoggable(Level.INFO)) continue;
                    LOGGER.info("Skipping unparseable PropertyCollector definition: " + pcDef);
                    continue;
                }
                if (roundLPos != squareRPos + 1) {
                    if (!LOGGER.isLoggable(Level.INFO)) continue;
                    LOGGER.info("Skipping unparseable PropertyCollector definition: " + pcDef);
                    continue;
                }
                if (roundRPos != pcDef.length() - 1) {
                    if (!LOGGER.isLoggable(Level.INFO)) continue;
                    LOGGER.info("Skipping unparseable PropertyCollector definition: " + pcDef);
                    continue;
                }
                String spi = pcDef.substring(0, squareLPos);
                String config = squareLPos < squareRPos ? pcDef.substring(squareLPos + 1, squareRPos) : "";
                String value = null;
                File configFile = new File(IndexerUtils.getParameter("RootMosaicDirectory", indexer), config + ".properties");
                if (!Utils.checkFileReadable(configFile)) {
                    if (!LOGGER.isLoggable(Level.INFO)) continue;
                    LOGGER.info("Unable to access the file for this PropertyCollector: " + configFile.getAbsolutePath());
                    continue;
                }
                Properties properties = Utils.loadPropertiesFromURL(DataUtilities.fileToURL(configFile));
                if (properties.containsKey("regex")) {
                    value = properties.getProperty("regex");
                }
                String[] propertyNames = pcDef.substring(roundLPos + 1, roundRPos).split(",");
                Indexer.Collectors.Collector collector = Utils.OBJECT_FACTORY.createIndexerCollectorsCollector();
                collector.setSpi(spi);
                collector.setMapped(propertyNames[0]);
                collector.setValue(value);
                collectorList.add(collector);
            }
        }
    }

    public static Indexer.Coverages.Coverage getCoverage(Indexer indexer, String name) {
        Indexer.Coverages coverages = indexer.getCoverages();
        if (coverages != null) {
            List<Indexer.Coverages.Coverage> coverageList = coverages.getCoverage();
            for (Indexer.Coverages.Coverage coverage : coverageList) {
                String coverageName = coverage.getName();
                if (coverageName == null || !coverageName.equalsIgnoreCase(name)) continue;
                return coverage;
            }
        }
        return null;
    }

    public static String refineParameterValue(String parameterName, String parameterValue) {
        if (parameterName.equalsIgnoreCase("RootMosaicDirectory")) {
            Utilities.ensureNonNull((String)"parameterValue", (Object)parameterValue);
            String testingDirectory = parameterValue;
            parameterValue = Utils.checkDirectory(testingDirectory, false);
        }
        return parameterValue;
    }

    public static void setAttributes(DomainType domain, String values) {
        if (values.contains(";")) {
            String[] properties;
            for (String prop : properties = values.split(";")) {
                IndexerUtils.addAttribute(domain, prop);
            }
        } else {
            IndexerUtils.addAttribute(domain, values);
        }
    }

    private static void addAttribute(DomainType domain, String attributeValue) {
        AttributeType attribute = Utils.OBJECT_FACTORY.createAttributeType();
        attribute.setAttribute(attributeValue);
        List<AttributeType> listAttributes = domain.getAttributes();
        listAttributes.add(attribute);
    }

    public static void setParam(List<ParametersType.Parameter> parameters, String parameterName, String parameterValue) {
        ParametersType.Parameter param = null;
        for (ParametersType.Parameter parameter : parameters) {
            if (!parameter.getName().equalsIgnoreCase(parameterName)) continue;
            param = parameter;
            break;
        }
        if (param == null) {
            param = Utils.OBJECT_FACTORY.createParametersTypeParameter();
            parameters.add(param);
        }
        param.setName(parameterName);
        param.setValue(IndexerUtils.refineParameterValue(parameterName, parameterValue));
    }

    public static void setParam(List<ParametersType.Parameter> parameters, Properties props, String propName) {
        IndexerUtils.setParam(parameters, propName, props.getProperty(propName));
    }

    public static boolean getParameterAsBoolean(String parameterName, Indexer indexer) {
        String value = IndexerUtils.getParameter(parameterName, indexer);
        if (value != null) {
            return Boolean.parseBoolean(value);
        }
        return false;
    }

    public static String getParam(ParametersType params, String parameterName) {
        List<ParametersType.Parameter> parameters = null;
        if (params != null) {
            parameters = params.getParameter();
            for (ParametersType.Parameter param : parameters) {
                if (!param.getName().equalsIgnoreCase(parameterName)) continue;
                return param.getValue();
            }
        }
        return null;
    }

    public static String getParameter(String parameterName, Indexer indexer) {
        ParametersType params = indexer.getParameters();
        return IndexerUtils.getParam(params, parameterName);
    }

    public static String getParameter(String parameterName, File indexerFile) {
        if (indexerFile != null && indexerFile.exists()) {
            try {
                String value;
                Indexer indexerInstance = Utils.unmarshal(indexerFile);
                if (indexerInstance != null && (value = IndexerUtils.getParameter(parameterName, indexerInstance)) != null) {
                    return value;
                }
            }
            catch (JAXBException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public static void parseAdditionalDomains(String attributes, List<DomainType> domainList) {
        String[] domainsAttributes;
        for (String domainAttributes : domainsAttributes = attributes.split(",")) {
            String domainName;
            DomainType domain = Utils.OBJECT_FACTORY.createDomainType();
            String domainAttribs = domainName = domainAttributes.trim();
            if (domainAttributes.contains("(") && domainAttributes.contains(")")) {
                domainName = domainName.substring(0, domainName.indexOf("(")).trim();
                domainAttribs = domainAttribs.substring(domainAttribs.indexOf("(")).replace("(", "").replace(")", "");
            }
            domain.setName(domainName);
            IndexerUtils.setAttributes(domain, domainAttribs);
            domainList.add(domain);
        }
    }

    private static String getAttributesAsString(DomainType domain, boolean domainPrefix) {
        String currentDomainName = domain.getName();
        List<AttributeType> listAttributes = domain.getAttributes();
        if (!listAttributes.isEmpty()) {
            String attribs = null;
            if (listAttributes.size() == 1) {
                attribs = listAttributes.get(0).getAttribute().trim();
            } else {
                String attr0 = listAttributes.get(0).getAttribute().trim();
                String attr1 = listAttributes.get(1).getAttribute().trim();
                attribs = attr0 + ";" + attr1;
            }
            if (domainPrefix) {
                return currentDomainName + "(" + attribs + ")";
            }
            return attribs;
        }
        return null;
    }

    public static DomainType getDomain(DomainType domain, DomainsType refDomains) {
        String domainRef;
        String currentDomainName = domain.getName();
        if (currentDomainName == null && (domainRef = domain.getRef()) != null && refDomains != null) {
            for (DomainType refDomain : refDomains.getDomain()) {
                if (!refDomain.getName().equalsIgnoreCase(domainRef)) continue;
                currentDomainName = domainRef;
                return refDomain;
            }
        }
        return domain;
    }

    public static String getAttribute(String coverageName, String domainName, Indexer indexer) {
        if (indexer != null) {
            List<Indexer.Coverages.Coverage> coverageList;
            Indexer.Coverages coverages = indexer.getCoverages();
            DomainsType refDomains = indexer.getDomains();
            if (coverages != null && (coverageList = coverages.getCoverage()) != null && !coverageList.isEmpty()) {
                for (Indexer.Coverages.Coverage coverage : coverageList) {
                    List<DomainType> domainList;
                    DomainsType domains;
                    String currentCoverageName = coverage.getName();
                    if (currentCoverageName != null && !currentCoverageName.equalsIgnoreCase(coverageName) || (domains = coverage.getDomains()) == null || (domainList = domains.getDomain()) == null) continue;
                    if (!domainName.equalsIgnoreCase("ADDITIONAL")) {
                        for (DomainType domain : domainList) {
                            DomainType currentDomain = IndexerUtils.getDomain(domain, refDomains);
                            String currentDomainName = currentDomain.getName();
                            if (currentDomainName == null || !currentDomainName.equalsIgnoreCase(domainName)) continue;
                            return IndexerUtils.getAttributesAsString(currentDomain, false);
                        }
                        continue;
                    }
                    StringBuilder additionalDomainAttributes = new StringBuilder();
                    for (DomainType domain : domainList) {
                        DomainType currentDomain = IndexerUtils.getDomain(domain, refDomains);
                        String domName = currentDomain.getName();
                        if (domName.equalsIgnoreCase("TIME") || domName.equalsIgnoreCase("ELEVATION")) continue;
                        additionalDomainAttributes.append(IndexerUtils.getAttributesAsString(currentDomain, true));
                        additionalDomainAttributes.append(",");
                    }
                    String attribs = additionalDomainAttributes.toString();
                    if (attribs != null && attribs.length() > 0) {
                        attribs = attribs.substring(0, attribs.length() - 1);
                    }
                    if (attribs.length() > 0) {
                        return attribs;
                    }
                    return null;
                }
            }
        }
        return null;
    }

    public static SchemaType getSchema(Indexer indexer, Indexer.Coverages.Coverage coverage) {
        Utilities.ensureNonNull((String)"coverage", (Object)coverage);
        SchemaType schema = coverage.getSchema();
        if (schema != null) {
            String schemaRef = schema.getRef();
            if (schemaRef != null && (schema = IndexerUtils.getSchemaRef(indexer, schemaRef)) != null) {
                return schema;
            }
            return schema;
        }
        return null;
    }

    private static SchemaType getSchemaRef(Indexer indexer, String schemaRef) {
        Utilities.ensureNonNull((String)"schemaRef", (Object)schemaRef);
        Utilities.ensureNonNull((String)"indexer", (Object)indexer);
        SchemasType schemas = indexer.getSchemas();
        if (schemas != null) {
            List<SchemaType> schemaList = schemas.getSchema();
            for (SchemaType schema : schemaList) {
                String schemaName = schema.getName();
                if (schemaName == null || !schemaName.equalsIgnoreCase(schemaRef)) continue;
                return schema;
            }
        }
        return null;
    }
}

