/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic.catalog;

import it.geosolutions.imageio.maskband.DatasetLayout;
import java.awt.RenderingHints;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.GridFormatFinder;
import org.geotools.factory.Hints;
import org.geotools.gce.imagemosaic.Utils;
import org.geotools.gce.imagemosaic.catalog.MultiLevelROI;
import org.geotools.gce.imagemosaic.catalog.MultiLevelROIProvider;
import org.geotools.gce.imagemosaic.catalog.MultiLevelROIRaster;
import org.geotools.gce.imagemosaic.catalog.SidecarFootprintProvider;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeature;

public class MultiLevelROIRasterProvider
implements MultiLevelROIProvider {
    static final Logger LOGGER = Logging.getLogger(SidecarFootprintProvider.class);
    public static final Hints EXCLUDE_MOSAIC = new Hints((RenderingHints.Key)Utils.EXCLUDE_MOSAIC, (Object)true);
    private File mosaicFolder;

    public MultiLevelROIRasterProvider(File mosaicFolder) {
        this.mosaicFolder = mosaicFolder;
    }

    @Override
    public MultiLevelROI getMultiScaleROI(SimpleFeature sf) throws IOException {
        if (sf == null) {
            return null;
        }
        Object value = sf.getAttribute("location");
        if (value != null && value instanceof String) {
            String strValue = (String)value;
            File file = this.getFile(strValue);
            MultiLevelROI result = null;
            if (file.exists() && file.canRead()) {
                try {
                    int numExternalMaskOverviews;
                    int numInternalMasks;
                    int numExternalMasks;
                    int totalMasks;
                    AbstractGridFormat format = GridFormatFinder.findFormat((Object)file, (Hints)EXCLUDE_MOSAIC);
                    AbstractGridCoverage2DReader reader = format.getReader((Object)file);
                    DatasetLayout layout = reader.getDatasetLayout();
                    if (layout != null && (totalMasks = (numExternalMasks = layout.getNumExternalMasks() > 0 ? layout.getNumExternalMasks() : 0) + (numInternalMasks = layout.getNumInternalMasks() > 0 ? layout.getNumInternalMasks() : 0) + (numExternalMaskOverviews = layout.getNumExternalMaskOverviews() > 0 ? layout.getNumExternalMaskOverviews() : 0)) > 0) {
                        return new MultiLevelROIRaster(layout, file, sf);
                    }
                }
                catch (Exception e) {
                    throw new IOException("Failed to load the footprint for granule " + strValue, e);
                }
            }
            return result;
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Could not use the location attribute value to search for the file, the value was: " + value);
        }
        return null;
    }

    private File getFile(String strValue) throws IOException {
        File file = new File(strValue);
        if (!file.isAbsolute()) {
            file = new File(this.mosaicFolder, strValue);
        }
        return file;
    }

    @Override
    public void dispose() {
    }
}

