/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic.catalog;

import com.vividsolutions.jts.geom.Geometry;
import java.io.IOException;
import org.geotools.gce.imagemosaic.catalog.FootprintGeometryProvider;
import org.geotools.gce.imagemosaic.catalog.FootprintInsetPolicy;
import org.geotools.gce.imagemosaic.catalog.MultiLevelROI;
import org.geotools.gce.imagemosaic.catalog.MultiLevelROIGeometry;
import org.geotools.gce.imagemosaic.catalog.MultiLevelROIProvider;
import org.opengis.feature.simple.SimpleFeature;

public class MultiLevelROIGeometryProvider
implements MultiLevelROIProvider {
    private final FootprintGeometryProvider geometryProvider;
    private final double inset;
    private final FootprintInsetPolicy insetPolicy;

    public MultiLevelROIGeometryProvider(FootprintGeometryProvider geometryProvider, double inset, FootprintInsetPolicy insetPolicy) {
        this.geometryProvider = geometryProvider;
        this.inset = inset;
        this.insetPolicy = insetPolicy;
    }

    @Override
    public MultiLevelROI getMultiScaleROI(SimpleFeature sf) throws IOException {
        Geometry footprint = this.geometryProvider.getFootprint(sf);
        if (footprint == null) {
            return null;
        }
        Geometry granuleBounds = (Geometry)sf.getDefaultGeometry();
        return new MultiLevelROIGeometry(footprint, granuleBounds, this.inset, this.insetPolicy);
    }

    @Override
    public void dispose() {
        this.geometryProvider.dispose();
    }
}

