/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic.catalog;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.spi.ImageReaderSpi;
import org.apache.commons.io.FilenameUtils;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFactorySpi;
import org.geotools.data.DataUtilities;
import org.geotools.data.Query;
import org.geotools.data.QueryCapabilities;
import org.geotools.data.Transaction;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.data.simple.SimpleFeatureStore;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.feature.SchemaException;
import org.geotools.feature.collection.AbstractFeatureVisitor;
import org.geotools.feature.visitor.FeatureCalc;
import org.geotools.gce.imagemosaic.GranuleDescriptor;
import org.geotools.gce.imagemosaic.PathType;
import org.geotools.gce.imagemosaic.Utils;
import org.geotools.gce.imagemosaic.catalog.GranuleCatalog;
import org.geotools.gce.imagemosaic.catalog.GranuleCatalogVisitor;
import org.geotools.gce.imagemosaic.catalog.MultiLevelROI;
import org.geotools.gce.imagemosaic.catalog.oracle.OracleDatastoreWrapper;
import org.geotools.gce.imagemosaic.catalog.postgis.PostgisDatastoreWrapper;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.DefaultProgressListener;
import org.geotools.util.Utilities;
import org.geotools.util.logging.Logging;
import org.opengis.feature.Feature;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.identity.FeatureId;
import org.opengis.geometry.BoundingBox;

class GTDataStoreGranuleCatalog
extends GranuleCatalog {
    static final Logger LOGGER = Logging.getLogger(GTDataStoreGranuleCatalog.class);
    static final FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2(GeoTools.getDefaultHints());
    private DataStore tileIndexStore;
    Set<String> typeNames = new HashSet<String>();
    private String geometryPropertyName;
    PathType pathType;
    String locationAttribute;
    ImageReaderSpi suggestedRasterSPI;
    String parentLocation;
    boolean heterogeneous;
    boolean wrapstore = false;
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock(true);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GTDataStoreGranuleCatalog(Properties params, boolean create, DataStoreFactorySpi spi, Hints hints) {
        super(hints);
        Utilities.ensureNonNull((String)"params", (Object)params);
        Utilities.ensureNonNull((String)"spi", (Object)spi);
        try {
            String[] typeNames;
            this.pathType = (PathType)((Object)params.get("PathType"));
            this.locationAttribute = (String)params.get("LocationAttribute");
            String temp = (String)params.get("SuggestedSPI");
            this.suggestedRasterSPI = temp != null ? (ImageReaderSpi)Class.forName(temp).newInstance() : null;
            this.parentLocation = (String)params.get("ParentLocation");
            if (params.containsKey("Heterogeneous")) {
                this.heterogeneous = (Boolean)params.get("Heterogeneous");
            }
            if (params.containsKey("WrapStore")) {
                this.wrapstore = (Boolean)params.get("WrapStore");
            }
            Map<String, Serializable> dastastoreParams = Utils.filterDataStoreParams(params, spi);
            boolean isPostgis = Utils.isPostgisStore(spi);
            if (Utils.isH2Store(spi)) {
                Utils.fixH2DatabaseLocation(dastastoreParams, this.parentLocation);
                Utils.fixH2MVCCParam(dastastoreParams);
            }
            if (isPostgis) {
                Utils.fixPostgisDBCreationParams(dastastoreParams);
            }
            if (!create) {
                this.tileIndexStore = spi.createDataStore(dastastoreParams);
            } else {
                try {
                    this.tileIndexStore = spi.createNewDataStore(dastastoreParams);
                }
                catch (UnsupportedOperationException e) {
                    this.tileIndexStore = spi.createDataStore(dastastoreParams);
                }
            }
            if (isPostgis && this.wrapstore) {
                this.tileIndexStore = new PostgisDatastoreWrapper(this.tileIndexStore, FilenameUtils.getFullPath((String)this.parentLocation));
            } else if (Utils.isOracleStore(spi)) {
                this.tileIndexStore = new OracleDatastoreWrapper(this.tileIndexStore, FilenameUtils.getFullPath((String)this.parentLocation));
            }
            if (create) {
                return;
            }
            String typeName = null;
            boolean scanForTypeNames = false;
            if (params.containsKey("TypeName")) {
                typeName = (String)params.get("TypeName");
            }
            if (params.containsKey("TypeNames")) {
                scanForTypeNames = Boolean.valueOf(params.get("TypeNames").toString());
            }
            if (scanForTypeNames) {
                typeNames = this.tileIndexStore.getTypeNames();
                if (typeNames != null) {
                    for (String tn : typeNames) {
                        if (!this.isValidMosaicSchema(tn)) continue;
                        this.typeNames.add(tn);
                    }
                }
            } else if (typeName != null) {
                this.checkMosaicSchema(typeName);
                this.addTypeName(typeName, false);
            } else {
                typeNames = this.tileIndexStore.getTypeNames();
                if (typeNames != null) {
                    for (String tn : typeNames) {
                        if (!this.isValidMosaicSchema(tn)) continue;
                        this.addTypeName(tn, false);
                        break;
                    }
                }
            }
            if (this.typeNames.size() == 0) {
                throw new IllegalArgumentException("Could not find a suitable mosaic type (with a footprint and a location attribute named " + this.getLocationAttributeName() + " in the store");
            }
            if (this.typeNames.size() > 0) {
                this.extractBasicProperties(this.typeNames.iterator().next());
            } else if (typeName != null && typeName.contains(",")) {
                for (String tn : typeNames = typeName.split(",")) {
                    this.extractBasicProperties(tn);
                }
            } else if (typeName != null) {
                this.extractBasicProperties(typeName);
            } else {
                this.extractBasicProperties(typeName);
            }
        }
        catch (Throwable e) {
            try {
                if (this.tileIndexStore != null) {
                    this.tileIndexStore.dispose();
                }
            }
            catch (Throwable e1) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, e1.getLocalizedMessage(), e1);
                }
            }
            finally {
                this.tileIndexStore = null;
            }
            throw new IllegalArgumentException(e);
        }
    }

    private boolean isValidMosaicSchema(String typeName) throws IOException {
        SimpleFeatureType schema = this.tileIndexStore.getSchema(typeName);
        return this.isValidMosaicSchema(schema);
    }

    private boolean isValidMosaicSchema(SimpleFeatureType schema) {
        if (schema.getGeometryDescriptor() == null) {
            return false;
        }
        String locationName = this.getLocationAttributeName();
        AttributeDescriptor location = schema.getDescriptor(locationName);
        return location != null && CharSequence.class.isAssignableFrom(location.getType().getBinding());
    }

    private String getLocationAttributeName() {
        if (this.locationAttribute == null) {
            return "location";
        }
        return this.locationAttribute;
    }

    private void checkMosaicSchema(String typeName) throws IOException {
        SimpleFeatureType schema = this.tileIndexStore.getSchema(typeName);
        if (schema == null) {
            throw new IllegalArgumentException("Could not find typename " + schema);
        }
        this.checkMosaicSchema(schema);
    }

    private void checkMosaicSchema(SimpleFeatureType schema) {
        if (!this.isValidMosaicSchema(schema)) {
            throw new IllegalArgumentException("Invalid mosaic schema " + schema + ", " + "it should have a geometry and a location property of name " + this.locationAttribute);
        }
    }

    private void checkStore() throws IllegalStateException {
        if (this.tileIndexStore == null) {
            throw new IllegalStateException("The index store has been disposed already.");
        }
    }

    private void extractBasicProperties(String typeName) throws IOException {
        SimpleFeatureSource featureSource;
        if (typeName == null) {
            String[] typeNames = this.tileIndexStore.getTypeNames();
            if (typeNames == null || typeNames.length <= 0) {
                throw new IllegalArgumentException("BBOXFilterExtractor::extractBasicProperties(): Problems when opening the index, no typenames for the schema are defined");
            }
            if (typeName == null) {
                typeName = typeNames[0];
                this.addTypeName(typeName, false);
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.warning("BBOXFilterExtractor::extractBasicProperties(): passed typename is null, using: " + typeName);
                }
            }
            for (String type : typeNames) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("BBOXFilterExtractor::extractBasicProperties(): Looking for type '" + typeName + "' in DataStore:getTypeNames(). Testing: '" + type + "'.");
                }
                if (!type.equalsIgnoreCase(typeName)) continue;
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("BBOXFilterExtractor::extractBasicProperties(): SUCCESS -> type '" + typeName + "' is equalsIgnoreCase() to '" + type + "'.");
                }
                typeName = type;
                this.addTypeName(typeName, false);
                break;
            }
        }
        if ((featureSource = this.tileIndexStore.getFeatureSource(typeName)) == null) {
            throw new IOException("BBOXFilterExtractor::extractBasicProperties(): unable to get a featureSource for the qualified name" + typeName);
        }
        Object schema = featureSource.getSchema();
        if (schema != null && schema.getGeometryDescriptor() != null) {
            this.geometryPropertyName = schema.getGeometryDescriptor().getLocalName();
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("BBOXFilterExtractor::extractBasicProperties(): geometryPropertyName is set to '" + this.geometryPropertyName + "'.");
            }
        } else {
            throw new IOException("BBOXFilterExtractor::extractBasicProperties(): unable to get a schema from the featureSource");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        Lock l = this.rwLock.writeLock();
        try {
            l.lock();
            try {
                if (this.tileIndexStore != null) {
                    this.tileIndexStore.dispose();
                }
                if (this.multiScaleROIProvider != null) {
                    this.multiScaleROIProvider.dispose();
                }
                this.tileIndexStore = null;
                this.multiScaleROIProvider = null;
            }
            catch (Throwable e) {
                try {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                    }
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    this.tileIndexStore = null;
                    this.multiScaleROIProvider = null;
                }
            }
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int removeGranules(Query query) {
        Utilities.ensureNonNull((String)"query", (Object)query);
        query = this.mergeHints(query);
        Lock lock = this.rwLock.writeLock();
        try {
            lock.lock();
            this.checkStore();
            String typeName = query.getTypeName();
            SimpleFeatureStore fs = null;
            try {
                fs = (SimpleFeatureStore)this.tileIndexStore.getFeatureSource(typeName);
                int retVal = fs.getCount(query);
                fs.removeFeatures(query.getFilter());
                int n = retVal;
                return n;
            }
            catch (Throwable e) {
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
                }
                int n = -1;
                lock.unlock();
                return n;
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addGranules(String typeName, Collection<SimpleFeature> granules, Transaction transaction) throws IOException {
        Utilities.ensureNonNull((String)"granuleMetadata", granules);
        Lock lock = this.rwLock.writeLock();
        try {
            lock.lock();
            this.checkStore();
            SimpleFeatureStore store = (SimpleFeatureStore)this.tileIndexStore.getFeatureSource(typeName);
            store.setTransaction(transaction);
            ListFeatureCollection featureCollection = new ListFeatureCollection(this.tileIndexStore.getSchema(typeName));
            HashSet<FeatureId> fids = new HashSet<FeatureId>();
            for (SimpleFeature f : granules) {
                featureCollection.add(f);
                fids.add(ff.featureId(f.getID()));
            }
            store.addFeatures(featureCollection);
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public void getGranuleDescriptors(Query query, final GranuleCatalogVisitor visitor) throws IOException {
        Utilities.ensureNonNull((String)"query", (Object)query);
        final Query q = this.mergeHints(query);
        String typeName = q.getTypeName();
        Lock lock = this.rwLock.readLock();
        try {
            lock.lock();
            this.checkStore();
            SimpleFeatureSource featureSource = this.tileIndexStore.getFeatureSource(typeName);
            if (featureSource == null) {
                throw new NullPointerException("The provided SimpleFeatureSource is null, it's impossible to create an index!");
            }
            SimpleFeatureCollection features = featureSource.getFeatures(q);
            if (features == null) {
                throw new NullPointerException("The provided SimpleFeatureCollection is null, it's impossible to create an index!");
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Index Loaded");
            }
            final DefaultProgressListener listener = new DefaultProgressListener();
            features.accepts(new AbstractFeatureVisitor(){

                public void visit(Feature feature) {
                    if (feature instanceof SimpleFeature) {
                        SimpleFeature sf = (SimpleFeature)feature;
                        MultiLevelROI footprint = GTDataStoreGranuleCatalog.this.getGranuleFootprint(sf);
                        if (footprint == null || !footprint.isEmpty()) {
                            GranuleDescriptor granule = new GranuleDescriptor(sf, GTDataStoreGranuleCatalog.this.suggestedRasterSPI, GTDataStoreGranuleCatalog.this.pathType, GTDataStoreGranuleCatalog.this.locationAttribute, GTDataStoreGranuleCatalog.this.parentLocation, footprint, GTDataStoreGranuleCatalog.this.heterogeneous, q.getHints());
                            visitor.visit(granule, null);
                        }
                        if (listener.isCanceled() || listener.hasExceptions()) {
                            if (listener.hasExceptions()) {
                                throw new RuntimeException(listener.getExceptions().peek());
                            }
                            throw new IllegalStateException("Feature visitor for query " + q + " has been canceled");
                        }
                    }
                }
            }, listener);
        }
        catch (Throwable e) {
            IOException ioe = new IOException();
            ioe.initCause(e);
            throw ioe;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public SimpleFeatureCollection getGranules(Query q) throws IOException {
        Utilities.ensureNonNull((String)"query", (Object)q);
        q = this.mergeHints(q);
        String typeName = q.getTypeName();
        Lock lock = this.rwLock.readLock();
        try {
            lock.lock();
            this.checkStore();
            SimpleFeatureSource featureSource = this.tileIndexStore.getFeatureSource(typeName);
            if (featureSource == null) {
                throw new NullPointerException("The provided SimpleFeatureSource is null, it's impossible to create an index!");
            }
            SimpleFeatureCollection simpleFeatureCollection = featureSource.getFeatures(q);
            return simpleFeatureCollection;
        }
        catch (Throwable e) {
            IOException ioe = new IOException();
            ioe.initCause(e);
            throw ioe;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BoundingBox getBounds(String typeName) {
        Lock lock = this.rwLock.readLock();
        try {
            lock.lock();
            this.checkStore();
            ReferencedEnvelope referencedEnvelope = this.tileIndexStore.getFeatureSource(typeName).getBounds();
            return referencedEnvelope;
        }
        catch (IOException e) {
            LOGGER.log(Level.FINER, e.getMessage(), e);
        }
        finally {
            lock.unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createType(String namespace, String typeName, String typeSpec) throws IOException, SchemaException {
        Utilities.ensureNonNull((String)"typeName", (Object)typeName);
        Utilities.ensureNonNull((String)"typeSpec", (Object)typeSpec);
        Lock lock = this.rwLock.writeLock();
        String type = null;
        try {
            lock.lock();
            this.checkStore();
            SimpleFeatureType featureType = DataUtilities.createType(namespace, typeName, typeSpec);
            this.checkMosaicSchema(featureType);
            this.tileIndexStore.createSchema(featureType);
            type = featureType.getTypeName();
            if (typeName != null) {
                this.addTypeName(typeName, true);
            }
            this.extractBasicProperties(type);
        }
        finally {
            lock.unlock();
        }
    }

    private void addTypeName(String typeName, boolean check) {
        if (check && this.typeNames.contains(typeName)) {
            throw new IllegalArgumentException("This typeName already exists: " + typeName);
        }
        this.typeNames.add(typeName);
    }

    private void removeTypeName(String typeName) {
        if (this.typeNames.contains(typeName)) {
            this.typeNames.remove(typeName);
        }
    }

    @Override
    public String[] getTypeNames() {
        if (this.typeNames != null && !this.typeNames.isEmpty()) {
            return this.typeNames.toArray(new String[0]);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createType(SimpleFeatureType featureType) throws IOException {
        Utilities.ensureNonNull((String)"featureType", (Object)featureType);
        this.checkMosaicSchema(featureType);
        Lock lock = this.rwLock.writeLock();
        String typeName = null;
        try {
            lock.lock();
            this.checkStore();
            this.tileIndexStore.createSchema(featureType);
            typeName = featureType.getTypeName();
            if (typeName != null) {
                this.addTypeName(typeName, true);
            }
            this.extractBasicProperties(typeName);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeType(String typeName) throws IOException {
        Utilities.ensureNonNull((String)"featureType", (Object)typeName);
        Lock lock = this.rwLock.writeLock();
        try {
            lock.lock();
            this.checkStore();
            this.tileIndexStore.removeSchema(typeName);
            this.removeTypeName(typeName);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createType(String identification, String typeSpec) throws SchemaException, IOException {
        Utilities.ensureNonNull((String)"typeSpec", (Object)typeSpec);
        Utilities.ensureNonNull((String)"identification", (Object)identification);
        Lock lock = this.rwLock.writeLock();
        String typeName = null;
        try {
            lock.lock();
            this.checkStore();
            SimpleFeatureType featureType = DataUtilities.createType(identification, typeSpec);
            this.checkMosaicSchema(featureType);
            this.tileIndexStore.createSchema(featureType);
            typeName = featureType.getTypeName();
            if (typeName != null) {
                this.addTypeName(typeName, true);
            }
            this.extractBasicProperties(typeName);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SimpleFeatureType getType(String typeName) throws IOException {
        Lock lock = this.rwLock.readLock();
        try {
            lock.lock();
            this.checkStore();
            if (this.typeNames.isEmpty() || !this.typeNames.contains(typeName)) {
                SimpleFeatureType simpleFeatureType = null;
                return simpleFeatureType;
            }
            SimpleFeatureType simpleFeatureType = this.tileIndexStore.getSchema(typeName);
            return simpleFeatureType;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void computeAggregateFunction(Query query, FeatureCalc function) throws IOException {
        query = this.mergeHints(query);
        Lock lock = this.rwLock.readLock();
        try {
            lock.lock();
            this.checkStore();
            SimpleFeatureSource fs = this.tileIndexStore.getFeatureSource(query.getTypeName());
            if (fs instanceof ContentFeatureSource) {
                ((ContentFeatureSource)fs).accepts(query, (FeatureVisitor)function, null);
            } else {
                SimpleFeatureCollection collection = fs.getFeatures(query);
                collection.accepts(function, null);
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QueryCapabilities getQueryCapabilities(String typeName) {
        Lock lock = this.rwLock.readLock();
        try {
            lock.lock();
            this.checkStore();
            QueryCapabilities queryCapabilities = this.tileIndexStore.getFeatureSource(typeName).getQueryCapabilities();
            return queryCapabilities;
        }
        catch (IOException e) {
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.log(Level.INFO, "Unable to collect QueryCapabilities", e);
            }
            QueryCapabilities queryCapabilities = null;
            return queryCapabilities;
        }
        finally {
            lock.unlock();
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.tileIndexStore != null) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.warning("This granule catalog was not properly dispose as it still points to:" + this.tileIndexStore.getInfo().toString());
            }
            this.dispose();
        }
    }

    @Override
    public int getGranulesCount(Query q) throws IOException {
        Utilities.ensureNonNull((String)"query", (Object)q);
        q = this.mergeHints(q);
        String typeName = q.getTypeName();
        Lock lock = this.rwLock.readLock();
        try {
            lock.lock();
            this.checkStore();
            SimpleFeatureSource featureSource = this.tileIndexStore.getFeatureSource(typeName);
            if (featureSource == null) {
                throw new NullPointerException("The provided SimpleFeatureSource is null, it's impossible to create an index!");
            }
            int count = featureSource.getCount(q);
            if (count == -1) {
                int n = featureSource.getFeatures(q).size();
                return n;
            }
            int n = count;
            return n;
        }
        catch (Throwable e) {
            IOException ioe = new IOException();
            ioe.initCause(e);
            throw ioe;
        }
        finally {
            lock.unlock();
        }
    }
}

