/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.xml.datatype.XMLGregorianCalendar;
import org.geotools.factory.Hints;
import org.geotools.util.Converter;
import org.geotools.util.ConverterFactory;

class TemporalConverterFactoryHack
implements ConverterFactory {
    TemporalConverterFactoryHack() {
    }

    public Converter createConverter(Class source, Class target, Hints hints) {
        SimpleDateFormat df;
        Object safe;
        boolean isSafeOnly = false;
        if (hints != null && (safe = hints.get((Object)ConverterFactory.SAFE_CONVERSION)) instanceof Boolean && ((Boolean)safe).booleanValue()) {
            isSafeOnly = true;
        }
        if (Date.class.isAssignableFrom(source) && String.class.equals((Object)target)) {
            df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
            df.setTimeZone(TimeZone.getTimeZone("UTC"));
            return new Converter(){

                public Object convert(Object source, Class target) throws Exception {
                    if (source instanceof Date) {
                        return df.format((Date)source);
                    }
                    return null;
                }
            };
        }
        if (Calendar.class.isAssignableFrom(source) && String.class.equals((Object)target)) {
            df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
            df.setTimeZone(TimeZone.getTimeZone("UTC"));
            return new Converter(){

                public Object convert(Object source, Class target) throws Exception {
                    if (source instanceof Calendar) {
                        return df.format(((Calendar)source).getTime());
                    }
                    return null;
                }
            };
        }
        if (XMLGregorianCalendar.class.isAssignableFrom(source) && String.class.equals((Object)target)) {
            df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
            df.setTimeZone(TimeZone.getTimeZone("UTC"));
            return new Converter(){

                public Object convert(Object source, Class target) throws Exception {
                    if (source instanceof XMLGregorianCalendar) {
                        return df.format(((XMLGregorianCalendar)source).toGregorianCalendar(TimeZone.getTimeZone("GMT"), Locale.getDefault(), null).getTime());
                    }
                    return null;
                }
            };
        }
        return null;
    }
}

