/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic;

import java.io.IOException;
import javax.imageio.ImageReadParam;
import org.geotools.coverage.grid.io.DecimationPolicy;
import org.geotools.coverage.grid.io.OverviewPolicy;
import org.geotools.gce.imagemosaic.OverviewsController;
import org.geotools.gce.imagemosaic.RasterManager;
import org.geotools.util.Utilities;
import org.opengis.referencing.operation.TransformException;

public class ReadParamsController {
    private static void performDecimation(RasterManager.SpatialDomainManager spatialDomainManager, double[] requestedResolution, int levelIndex, ImageReadParam readParameters, OverviewsController overviewsController) {
        int rasterHeight;
        int rasterWidth;
        Utilities.ensureNonNull((String)"readParameters", (Object)readParameters);
        Utilities.ensureNonNull((String)"spatialDomainManager", (Object)spatialDomainManager);
        Utilities.ensureNonNull((String)"overviewsController", (Object)overviewsController);
        if (requestedResolution == null) {
            readParameters.setSourceSubsampling(1, 1, 0, 0);
            return;
        }
        double[] selectedRes = new double[2];
        OverviewsController.OverviewLevel level = overviewsController.resolutionsLevels.get(levelIndex);
        selectedRes[0] = level.resolutionX;
        selectedRes[1] = level.resolutionY;
        if (levelIndex == 0) {
            rasterWidth = spatialDomainManager.coverageRasterArea.width;
            rasterHeight = spatialDomainManager.coverageRasterArea.height;
        } else {
            rasterWidth = (int)Math.round(spatialDomainManager.coverageBBox.getSpan(0) / selectedRes[0]);
            rasterHeight = (int)Math.round(spatialDomainManager.coverageBBox.getSpan(1) / selectedRes[1]);
        }
        int subSamplingFactorX = (int)Math.floor(requestedResolution[0] / selectedRes[0]);
        int n = subSamplingFactorX = subSamplingFactorX == 0 ? 1 : subSamplingFactorX;
        while (subSamplingFactorX > 0 && rasterWidth / subSamplingFactorX <= 0) {
            --subSamplingFactorX;
        }
        subSamplingFactorX = subSamplingFactorX <= 0 ? 1 : subSamplingFactorX;
        int subSamplingFactorY = (int)Math.floor(requestedResolution[1] / selectedRes[1]);
        int n2 = subSamplingFactorY = subSamplingFactorY == 0 ? 1 : subSamplingFactorY;
        while (subSamplingFactorY > 0 && rasterHeight / subSamplingFactorY <= 0) {
            --subSamplingFactorY;
        }
        subSamplingFactorY = subSamplingFactorY <= 0 ? 1 : subSamplingFactorY;
        readParameters.setSourceSubsampling(subSamplingFactorX, subSamplingFactorY, 0, 0);
    }

    static int setReadParams(double[] requestedResolution, OverviewPolicy overviewPolicy, DecimationPolicy decimationPolicy, ImageReadParam readParams, RasterManager rasterManager, OverviewsController overviewController) throws IOException, TransformException {
        Utilities.ensureNonNull((String)"readParams", (Object)readParams);
        Utilities.ensureNonNull((String)"RasterManager", (Object)rasterManager);
        Utilities.ensureNonNull((String)"overviewsController", (Object)overviewController);
        if (overviewPolicy == null) {
            overviewPolicy = OverviewPolicy.getDefaultPolicy();
        }
        if (decimationPolicy == null) {
            decimationPolicy = DecimationPolicy.getDefaultPolicy();
        }
        int imageChoice = 0;
        readParams.setSourceSubsampling(1, 1, 0, 0);
        if (overviewPolicy.equals((Object)OverviewPolicy.IGNORE) && decimationPolicy.equals((Object)DecimationPolicy.DISALLOW)) {
            return imageChoice;
        }
        if (!overviewPolicy.equals((Object)OverviewPolicy.IGNORE)) {
            imageChoice = overviewController.pickOverviewLevel(overviewPolicy, requestedResolution);
        }
        if (!decimationPolicy.equals((Object)DecimationPolicy.DISALLOW)) {
            ReadParamsController.performDecimation(rasterManager.spatialDomainManager, requestedResolution, imageChoice, readParams, overviewController);
        }
        return imageChoice;
    }
}

