/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic;

import java.awt.Color;
import java.awt.Dimension;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.jai.Interpolation;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.DecimationPolicy;
import org.geotools.coverage.grid.io.OverviewPolicy;
import org.geotools.data.DataSourceException;
import org.geotools.factory.Hints;
import org.geotools.gce.imagemosaic.FootprintBehavior;
import org.geotools.gce.imagemosaic.ImageMosaicFormat;
import org.geotools.gce.imagemosaic.MergeBehavior;
import org.geotools.gce.imagemosaic.RasterManager;
import org.geotools.gce.imagemosaic.ReadType;
import org.geotools.gce.imagemosaic.SpatialRequestHelper;
import org.geotools.util.logging.Logging;
import org.opengis.filter.Filter;
import org.opengis.metadata.Identifier;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.ReferenceIdentifier;

class RasterLayerRequest {
    private static final Logger LOGGER = Logging.getLogger(RasterLayerRequest.class);
    private ReadType readType = (Boolean)AbstractGridFormat.USE_JAI_IMAGEREAD.getDefaultValue() != false ? ReadType.JAI_IMAGEREAD : ReadType.DIRECT_READ;
    SpatialRequestHelper spatialRequestHelper;
    private DecimationPolicy decimationPolicy;
    private OverviewPolicy overviewPolicy;
    private Interpolation interpolation;
    private FootprintBehavior footprintBehavior = FootprintBehavior.None;
    private int defaultArtifactsFilterThreshold = Integer.MIN_VALUE;
    private double artifactsFilterPTileThreshold;
    private boolean heterogeneousGranules = false;
    RasterManager rasterManager;
    private Color inputTransparentColor = (Color)AbstractGridFormat.INPUT_TRANSPARENT_COLOR.getDefaultValue();
    private boolean blend = (Boolean)ImageMosaicFormat.FADING.getDefaultValue();
    private MergeBehavior mergeBehavior = MergeBehavior.getDefault();
    private Color outputTransparentColor = (Color)ImageMosaicFormat.OUTPUT_TRANSPARENT_COLOR.getDefaultValue();
    private int maximumNumberOfGranules = (Integer)ImageMosaicFormat.MAX_ALLOWED_TILES.getDefaultValue();
    private double[] backgroundValues;
    private Dimension tileDimensions;
    private boolean multithreadingAllowed;
    private List<?> requestedTimes;
    private List<?> elevation;
    private Filter filter;
    private boolean accurateResolution;
    private final Map<String, List> requestedAdditionalDomains = new HashMap<String, List>();
    private String sortClause;

    public List<?> getElevation() {
        return this.elevation;
    }

    public String getSortClause() {
        return this.sortClause;
    }

    public void setSortClause(String sortClause) {
        this.sortClause = sortClause;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public List<?> getRequestedTimes() {
        return this.requestedTimes;
    }

    public boolean isMultithreadingAllowed() {
        return this.multithreadingAllowed;
    }

    public DecimationPolicy getDecimationPolicy() {
        return this.decimationPolicy;
    }

    public boolean isHeterogeneousGranules() {
        return this.heterogeneousGranules;
    }

    public void setHeterogeneousGranules(boolean heterogeneousGranules) {
        this.heterogeneousGranules = heterogeneousGranules;
    }

    RasterManager getRasterManager() {
        return this.rasterManager;
    }

    public Map<String, List> getRequestedAdditionalDomains() {
        return new HashMap<String, List>(this.requestedAdditionalDomains);
    }

    public RasterLayerRequest(GeneralParameterValue[] params, RasterManager rasterManager) throws DataSourceException {
        this.rasterManager = rasterManager;
        this.heterogeneousGranules = rasterManager.heterogeneousGranules;
        SpatialRequestHelper.CoverageProperties coverageProperties = new SpatialRequestHelper.CoverageProperties();
        coverageProperties.setBBox(rasterManager.spatialDomainManager.coverageBBox);
        coverageProperties.setRasterArea(rasterManager.spatialDomainManager.coverageRasterArea);
        coverageProperties.setFullResolution(rasterManager.spatialDomainManager.coverageFullResolution);
        coverageProperties.setGridToWorld2D(rasterManager.spatialDomainManager.coverageGridToWorld2D);
        coverageProperties.setCrs2D(rasterManager.spatialDomainManager.coverageCRS2D);
        coverageProperties.setGeographicBBox(rasterManager.spatialDomainManager.coverageGeographicBBox);
        coverageProperties.setGeographicCRS2D(rasterManager.spatialDomainManager.coverageGeographicCRS2D);
        this.spatialRequestHelper = new SpatialRequestHelper(coverageProperties);
        this.setDefaultParameterValues();
        if (params != null) {
            for (GeneralParameterValue gParam : params) {
                if (!(gParam instanceof ParameterValue)) continue;
                ParameterValue param = (ParameterValue)gParam;
                ReferenceIdentifier name = param.getDescriptor().getName();
                this.extractParameter(param, (Identifier)name);
            }
        }
        this.checkReadType();
        this.spatialRequestHelper.setAccurateResolution(this.accurateResolution);
        this.spatialRequestHelper.compute();
    }

    private void setDefaultParameterValues() {
        ParameterValueGroup readParams = this.rasterManager.parentReader.getFormat().getReadParameters();
        if (readParams == null) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("No default values for the read parameters!");
            }
            return;
        }
        List parametersDescriptors = readParams.getDescriptor().descriptors();
        for (GeneralParameterDescriptor descriptor : parametersDescriptors) {
            Object value;
            ReferenceIdentifier name;
            block20: {
                String[] tilesSize;
                String suggestedTileSize;
                if (!(descriptor instanceof ParameterDescriptor)) continue;
                ParameterDescriptor desc = (ParameterDescriptor)descriptor;
                name = desc.getName();
                value = desc.getDefaultValue();
                if (descriptor.getName().equals(AbstractGridFormat.READ_GRIDGEOMETRY2D.getName())) {
                    if (value == null) continue;
                    GridGeometry2D gg = (GridGeometry2D)value;
                    this.spatialRequestHelper.setRequestedGridGeometry(gg);
                    continue;
                }
                if (name.equals(AbstractGridFormat.USE_JAI_IMAGEREAD.getName())) {
                    if (value == null) continue;
                    this.readType = (Boolean)value != false ? ReadType.JAI_IMAGEREAD : ReadType.DIRECT_READ;
                    continue;
                }
                if (name.equals(AbstractGridFormat.OVERVIEW_POLICY.getName())) {
                    if (value == null) continue;
                    this.overviewPolicy = (OverviewPolicy)value;
                    continue;
                }
                if (name.equals(AbstractGridFormat.DECIMATION_POLICY.getName())) {
                    if (value == null) continue;
                    this.decimationPolicy = (DecimationPolicy)value;
                    continue;
                }
                if (name.equals(ImageMosaicFormat.INTERPOLATION.getName())) {
                    if (value == null) continue;
                    this.interpolation = (Interpolation)value;
                    continue;
                }
                if (name.equals(AbstractGridFormat.INPUT_TRANSPARENT_COLOR.getName())) {
                    if (value == null) continue;
                    this.inputTransparentColor = (Color)value;
                    this.inputTransparentColor = new Color(this.inputTransparentColor.getRed(), this.inputTransparentColor.getGreen(), this.inputTransparentColor.getBlue());
                    continue;
                }
                if (name.equals(ImageMosaicFormat.FADING.getName())) {
                    if (value == null) continue;
                    this.blend = (Boolean)value;
                    continue;
                }
                if (name.equals(ImageMosaicFormat.OUTPUT_TRANSPARENT_COLOR.getName())) {
                    if (value == null) continue;
                    this.outputTransparentColor = (Color)value;
                    this.outputTransparentColor = new Color(this.outputTransparentColor.getRed(), this.outputTransparentColor.getGreen(), this.outputTransparentColor.getBlue());
                    continue;
                }
                if (name.equals(ImageMosaicFormat.BACKGROUND_VALUES.getName())) {
                    if (value == null) continue;
                    this.backgroundValues = (double[])value;
                    continue;
                }
                if (name.equals(ImageMosaicFormat.MAX_ALLOWED_TILES.getName())) {
                    if (value == null) continue;
                    this.maximumNumberOfGranules = (Integer)value;
                    continue;
                }
                if (name.equals(ImageMosaicFormat.DEFAULT_ARTIFACTS_FILTER_THRESHOLD.getName())) {
                    if (value == null) continue;
                    this.defaultArtifactsFilterThreshold = (Integer)value;
                    continue;
                }
                if (name.equals(ImageMosaicFormat.ARTIFACTS_FILTER_PTILE_THRESHOLD.getName())) {
                    if (value == null) continue;
                    this.artifactsFilterPTileThreshold = (Double)value;
                    continue;
                }
                if (name.equals(ImageMosaicFormat.ALLOW_MULTITHREADING.getName())) {
                    if (value == null) continue;
                    this.multithreadingAllowed = (Boolean)value;
                    continue;
                }
                if (name.equals(ImageMosaicFormat.FOOTPRINT_BEHAVIOR.getName())) {
                    if (value == null) continue;
                    this.footprintBehavior = FootprintBehavior.valueOf((String)value);
                    continue;
                }
                if (name.equals(AbstractGridFormat.SUGGESTED_TILE_SIZE.getName()) && (suggestedTileSize = (String)value) != null && suggestedTileSize.trim().length() > 0 && suggestedTileSize.contains(",") && (tilesSize = suggestedTileSize.split(",")).length == 2) {
                    try {
                        int tileWidth = Integer.valueOf(tilesSize[0].trim());
                        int tileHeight = Integer.valueOf(tilesSize[1].trim());
                        this.tileDimensions = new Dimension(tileWidth, tileHeight);
                    }
                    catch (NumberFormatException nfe) {
                        if (!LOGGER.isLoggable(Level.WARNING)) break block20;
                        LOGGER.log(Level.WARNING, "Unable to parse suggested tile size parameter");
                    }
                }
            }
            if (!name.equals(ImageMosaicFormat.ACCURATE_RESOLUTION.getName()) || value == null) continue;
            this.accurateResolution = (Boolean)value;
            return;
        }
    }

    private void extractParameter(ParameterValue<?> param, Identifier name) {
        Object value;
        block47: {
            String[] tilesSize;
            String suggestedTileSize;
            if (name.equals(AbstractGridFormat.READ_GRIDGEOMETRY2D.getName())) {
                Object value2 = param.getValue();
                if (value2 == null) {
                    return;
                }
                GridGeometry2D gg = (GridGeometry2D)value2;
                this.spatialRequestHelper.setRequestedGridGeometry(gg.toCanonical());
                return;
            }
            if (name.equals(AbstractGridFormat.USE_JAI_IMAGEREAD.getName())) {
                Object value3 = param.getValue();
                if (value3 == null) {
                    return;
                }
                this.readType = param.booleanValue() ? ReadType.JAI_IMAGEREAD : ReadType.DIRECT_READ;
                return;
            }
            if (name.equals(ImageMosaicFormat.SORT_BY.getName())) {
                Object value4 = param.getValue();
                if (value4 == null) {
                    return;
                }
                this.sortClause = param.stringValue();
                return;
            }
            if (name.equals(ImageMosaicFormat.MERGE_BEHAVIOR.getName())) {
                Object value5 = param.getValue();
                if (value5 == null) {
                    return;
                }
                this.mergeBehavior = MergeBehavior.valueOf(param.stringValue().toUpperCase());
                return;
            }
            if (name.equals(AbstractGridFormat.OVERVIEW_POLICY.getName())) {
                Object value6 = param.getValue();
                if (value6 == null) {
                    return;
                }
                this.overviewPolicy = (OverviewPolicy)value6;
                return;
            }
            if (name.equals(AbstractGridFormat.DECIMATION_POLICY.getName())) {
                Object value7 = param.getValue();
                if (value7 == null) {
                    return;
                }
                this.decimationPolicy = (DecimationPolicy)value7;
                return;
            }
            if (name.equals(ImageMosaicFormat.INTERPOLATION.getName())) {
                Object value8 = param.getValue();
                if (value8 == null) {
                    return;
                }
                this.interpolation = (Interpolation)value8;
                return;
            }
            if (name.equals(AbstractGridFormat.INPUT_TRANSPARENT_COLOR.getName())) {
                Object value9 = param.getValue();
                if (value9 == null) {
                    return;
                }
                this.inputTransparentColor = (Color)value9;
                this.inputTransparentColor = new Color(this.inputTransparentColor.getRed(), this.inputTransparentColor.getGreen(), this.inputTransparentColor.getBlue());
                return;
            }
            if (name.equals(ImageMosaicFormat.FADING.getName())) {
                Object value10 = param.getValue();
                if (value10 == null) {
                    return;
                }
                this.blend = (Boolean)value10;
                return;
            }
            if (name.equals(ImageMosaicFormat.OUTPUT_TRANSPARENT_COLOR.getName())) {
                Object value11 = param.getValue();
                if (value11 == null) {
                    return;
                }
                this.outputTransparentColor = (Color)value11;
                this.outputTransparentColor = new Color(this.outputTransparentColor.getRed(), this.outputTransparentColor.getGreen(), this.outputTransparentColor.getBlue());
                return;
            }
            if (name.equals(ImageMosaicFormat.BACKGROUND_VALUES.getName())) {
                Object value12 = param.getValue();
                if (value12 == null) {
                    return;
                }
                this.backgroundValues = (double[])value12;
                return;
            }
            if (name.equals(ImageMosaicFormat.MAX_ALLOWED_TILES.getName())) {
                Object value13 = param.getValue();
                if (value13 == null) {
                    return;
                }
                this.maximumNumberOfGranules = param.intValue();
                return;
            }
            if (name.equals(ImageMosaicFormat.DEFAULT_ARTIFACTS_FILTER_THRESHOLD.getName())) {
                Object value14 = param.getValue();
                if (value14 == null) {
                    return;
                }
                this.defaultArtifactsFilterThreshold = param.intValue();
                return;
            }
            if (name.equals(ImageMosaicFormat.ARTIFACTS_FILTER_PTILE_THRESHOLD.getName())) {
                Object value15 = param.getValue();
                if (value15 == null) {
                    return;
                }
                this.artifactsFilterPTileThreshold = param.doubleValue();
                return;
            }
            if (name.equals(ImageMosaicFormat.ALLOW_MULTITHREADING.getName())) {
                Object value16 = param.getValue();
                if (value16 == null) {
                    return;
                }
                this.multithreadingAllowed = (Boolean)value16;
                return;
            }
            if (name.equals(ImageMosaicFormat.FOOTPRINT_BEHAVIOR.getName())) {
                Object value17 = param.getValue();
                if (value17 == null) {
                    return;
                }
                this.footprintBehavior = FootprintBehavior.valueOf((String)value17);
                return;
            }
            if (name.equals(ImageMosaicFormat.ACCURATE_RESOLUTION.getName())) {
                Object value18 = param.getValue();
                if (value18 == null) {
                    return;
                }
                this.accurateResolution = (Boolean)value18;
                return;
            }
            if (name.equals(AbstractGridFormat.SUGGESTED_TILE_SIZE.getName()) && (suggestedTileSize = (String)param.getValue()) != null && suggestedTileSize.trim().length() > 0 && suggestedTileSize.contains(",") && (tilesSize = suggestedTileSize.split(",")).length == 2) {
                try {
                    int tileWidth = Integer.valueOf(tilesSize[0].trim());
                    int tileHeight = Integer.valueOf(tilesSize[1].trim());
                    this.tileDimensions = new Dimension(tileWidth, tileHeight);
                }
                catch (NumberFormatException nfe) {
                    if (!LOGGER.isLoggable(Level.WARNING)) break block47;
                    LOGGER.log(Level.WARNING, "Unable to parse suggested tile size parameter");
                }
            }
        }
        if (name.equals(ImageMosaicFormat.TIME.getName())) {
            value = param.getValue();
            if (value == null) {
                return;
            }
            List dates = (List)value;
            if (dates == null || dates.size() <= 0) {
                return;
            }
            this.requestedTimes = dates;
            return;
        }
        if (name.equals(ImageMosaicFormat.ELEVATION.getName())) {
            value = param.getValue();
            if (value == null) {
                return;
            }
            this.elevation = (List)value;
            return;
        }
        if (name.equals(ImageMosaicFormat.FILTER.getName())) {
            value = param.getValue();
            if (value == null) {
                return;
            }
            this.filter = (Filter)value;
            return;
        }
        String paramName = name.getCode();
        if (this.rasterManager.domainsManager != null && this.rasterManager.domainsManager.isParameterSupported(name)) {
            Object value19 = param.getValue();
            if (value19 == null) {
                return;
            }
            if (value19 instanceof List) {
                List values = (List)value19;
                this.requestedAdditionalDomains.put(paramName, values);
            }
            return;
        }
    }

    public boolean isAccurateResolution() {
        return this.accurateResolution;
    }

    public void setAccurateResolution(boolean accurateResolution) {
        this.accurateResolution = accurateResolution;
    }

    private void checkReadType() {
        Object o;
        if (this.readType != ReadType.UNSPECIFIED) {
            return;
        }
        Hints hints = this.rasterManager.getHints();
        if (hints != null && (o = hints.get((Object)Hints.USE_JAI_IMAGEREAD)) != null) {
            this.readType = (ReadType)((Object)o);
        }
        this.readType = ReadType.getDefault();
    }

    public Color getInputTransparentColor() {
        return this.inputTransparentColor;
    }

    public Color getOutputTransparentColor() {
        return this.outputTransparentColor;
    }

    public int getMaximumNumberOfGranules() {
        return this.maximumNumberOfGranules;
    }

    public FootprintBehavior getFootprintBehavior() {
        return this.footprintBehavior;
    }

    public int getDefaultArtifactsFilterThreshold() {
        return this.defaultArtifactsFilterThreshold;
    }

    public double getArtifactsFilterPTileThreshold() {
        return this.artifactsFilterPTileThreshold;
    }

    public boolean isBlend() {
        return this.blend;
    }

    public ReadType getReadType() {
        return this.readType;
    }

    public double[] getBackgroundValues() {
        return this.backgroundValues;
    }

    public void setInterpolation(Interpolation interpolation) {
        this.interpolation = interpolation;
    }

    public Interpolation getInterpolation() {
        return this.interpolation;
    }

    public Dimension getTileDimensions() {
        return this.tileDimensions;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("RasterLayerRequest description: \n");
        builder.append(this.spatialRequestHelper).append("\n");
        builder.append("\tReadType=").append((Object)this.readType);
        return builder.toString();
    }

    public MergeBehavior getMergeBehavior() {
        return this.mergeBehavior;
    }

    public OverviewPolicy getOverviewPolicy() {
        return this.overviewPolicy;
    }

    public boolean isEmpty() {
        return this.spatialRequestHelper.isEmpty();
    }
}

