/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.DataUtilities;
import org.geotools.gce.imagemosaic.Utils;
import org.geotools.util.Utilities;
import org.geotools.util.logging.Logging;

public enum PathType {
    RELATIVE{

        @Override
        URL resolvePath(String parentLocation, String location) {
            Utilities.ensureNonNull((String)"parentLocation", (Object)parentLocation);
            Utilities.ensureNonNull((String)"location", (Object)location);
            if (LOGGER.isLoggable(Level.FINE)) {
                StringBuilder builder = new StringBuilder();
                builder.append("Trying to resolve path:").append("\n");
                builder.append("type:").append(this.toString()).append("\n");
                builder.append("parentLocation:").append(parentLocation).append("\n");
                builder.append("location:").append(location);
                LOGGER.fine(builder.toString());
            }
            try {
                URL rasterURL = DataUtilities.extendURL(new URL(parentLocation), location);
                if (!Utils.checkURLReadable(rasterURL)) {
                    if (LOGGER.isLoggable(Level.INFO)) {
                        LOGGER.info("Unable to read image for file " + rasterURL);
                    }
                    return null;
                }
                return rasterURL;
            }
            catch (MalformedURLException e) {
                return null;
            }
        }
    }
    ,
    ABSOLUTE{

        @Override
        URL resolvePath(String parentLocation, String location) {
            Utilities.ensureNonNull((String)"location", (Object)location);
            if (LOGGER.isLoggable(Level.FINE)) {
                StringBuilder builder = new StringBuilder();
                builder.append("Trying to resolve path:").append("\n");
                builder.append("type:").append(this.toString()).append("\n");
                if (parentLocation != null) {
                    builder.append("parentLocation:").append(parentLocation).append("\n");
                }
                LOGGER.fine(builder.toString());
            }
            try {
                File rasterFile = new File(location);
                if (!Utils.checkFileReadable(rasterFile)) {
                    URL rasterURL = new URL(location);
                    if (!Utils.checkURLReadable(rasterURL)) {
                        if (LOGGER.isLoggable(Level.INFO)) {
                            LOGGER.info("Unable to read image for file " + rasterURL);
                        }
                        return null;
                    }
                    return rasterURL;
                }
                return DataUtilities.fileToURL(rasterFile);
            }
            catch (MalformedURLException e) {
                return null;
            }
        }
    };

    private static final Logger LOGGER;

    abstract URL resolvePath(String var1, String var2);

    static {
        LOGGER = Logging.getLogger(PathType.class);
    }
}

