/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic;

import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.Query;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.gce.imagemosaic.ImageMosaicConfigHandler;
import org.geotools.gce.imagemosaic.ImageMosaicEventHandlers;
import org.geotools.gce.imagemosaic.ImageMosaicWalker;
import org.geotools.gce.imagemosaic.catalog.GranuleCatalog;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

class ImageMosaicDatastoreWalker
extends ImageMosaicWalker {
    static final Logger LOGGER = Logging.getLogger(ImageMosaicDatastoreWalker.class);

    public ImageMosaicDatastoreWalker(ImageMosaicConfigHandler configHandler, ImageMosaicEventHandlers eventHandler) {
        super(configHandler, eventHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        FeatureIterator it = null;
        try {
            this.configHandler.indexingPreamble();
            this.startTransaction();
            GranuleCatalog catalog = this.configHandler.getCatalog();
            String locationAttrName = this.configHandler.getRunConfiguration().getParameter("LocationAttribute");
            String requestedTypeName = this.configHandler.getRunConfiguration().getParameter("TypeName");
            String[] arr$ = catalog.getTypeNames();
            int len$ = arr$.length;
            int i$ = 0;
            while (true) {
                block45: {
                    block49: {
                        String message;
                        block44: {
                            SimpleFeatureCollection coll;
                            block48: {
                                SimpleFeatureType schema;
                                String typeName;
                                block47: {
                                    int numFiles;
                                    Query query;
                                    block46: {
                                        if (i$ >= len$) break block44;
                                        typeName = arr$[i$];
                                        if (requestedTypeName != null && !requestedTypeName.equals(typeName)) break block45;
                                        query = new Query(typeName);
                                        numFiles = catalog.getGranulesCount(query);
                                        if (numFiles > 0) break block46;
                                        LOGGER.log(Level.FINE, "No rows in the typeName: " + typeName);
                                        break block45;
                                    }
                                    this.setNumFiles(numFiles);
                                    coll = catalog.getGranules(query);
                                    schema = (SimpleFeatureType)coll.getSchema();
                                    if (schema.getDescriptor(locationAttrName) != null) break block47;
                                    LOGGER.fine("Skipping feature type " + typeName + " as the location attribute " + locationAttrName + " is not part of the schema");
                                    break block45;
                                }
                                if (schema.getGeometryDescriptor() != null) break block48;
                                LOGGER.fine("Skipping feature type " + typeName + " as it does not have a footprint column");
                                break block45;
                            }
                            it = coll.features();
                            break block49;
                        }
                        if (this.getStop()) {
                            this.rollbackTransaction();
                        } else {
                            this.commitTransaction();
                        }
                        if (it != null) {
                            try {
                                it.close();
                            }
                            catch (Exception e) {
                                LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                            }
                        }
                        try {
                            this.closeTransaction();
                        }
                        catch (Exception e) {
                            message = "Unable to close indexing" + e.getLocalizedMessage();
                            if (LOGGER.isLoggable(Level.WARNING)) {
                                LOGGER.log(Level.WARNING, message, e);
                            }
                            this.eventHandler.fireException(e);
                        }
                        try {
                            this.configHandler.indexingPostamble(!this.getStop());
                            return;
                        }
                        catch (Exception e) {
                            message = "Unable to close indexing" + e.getLocalizedMessage();
                            if (LOGGER.isLoggable(Level.WARNING)) {
                                LOGGER.log(Level.WARNING, message, e);
                            }
                            this.eventHandler.fireException(e);
                            return;
                        }
                    }
                    while (it.hasNext()) {
                        SimpleFeature feature = (SimpleFeature)it.next();
                        Object locationAttrObj = feature.getAttribute(locationAttrName);
                        File file = null;
                        if (locationAttrObj instanceof String) {
                            String path = (String)locationAttrObj;
                            if (Boolean.getBoolean(this.configHandler.getRunConfiguration().getParameter("AbsolutePath")) && !this.checkFile(file = new File(path))) {
                                file = null;
                            }
                            if (!(file != null || (file = new File(this.configHandler.getRunConfiguration().getParameter("RootMosaicDirectory"), path)).exists() && file.canRead() && file.isFile() || this.checkFile(file = new File(path)))) {
                                file = null;
                            }
                            if (file == null) {
                                super.skipFile(path);
                                continue;
                            }
                        } else if (locationAttrObj instanceof File) {
                            file = (File)locationAttrObj;
                        } else {
                            this.eventHandler.fireException(new IOException("Location attribute type not recognized for column name: " + locationAttrName));
                            this.stop();
                            break;
                        }
                        this.handleFile(file);
                    }
                }
                ++i$;
            }
        }
        catch (Exception e) {
            block43: {
                try {
                    LOGGER.log(Level.WARNING, "Failure occurred while collecting the granules", e);
                    try {
                        this.rollbackTransaction();
                    }
                    catch (IOException e1) {
                        throw new IllegalStateException(e1);
                    }
                    if (it == null) break block43;
                }
                catch (Throwable throwable) {
                    if (it != null) {
                        try {
                            it.close();
                        }
                        catch (Exception e2) {
                            LOGGER.log(Level.FINE, e2.getLocalizedMessage(), e2);
                        }
                    }
                    try {
                        this.closeTransaction();
                    }
                    catch (Exception e3) {
                        String message3 = "Unable to close indexing" + e3.getLocalizedMessage();
                        if (LOGGER.isLoggable(Level.WARNING)) {
                            LOGGER.log(Level.WARNING, message3, e3);
                        }
                        this.eventHandler.fireException(e3);
                    }
                    try {
                        this.configHandler.indexingPostamble(!this.getStop());
                        throw throwable;
                    }
                    catch (Exception e4) {
                        String message2 = "Unable to close indexing" + e4.getLocalizedMessage();
                        if (LOGGER.isLoggable(Level.WARNING)) {
                            LOGGER.log(Level.WARNING, message2, e4);
                        }
                        this.eventHandler.fireException(e4);
                    }
                    throw throwable;
                }
                try {
                    it.close();
                }
                catch (Exception e5) {
                    LOGGER.log(Level.FINE, e5.getLocalizedMessage(), e5);
                }
            }
            try {
                this.closeTransaction();
            }
            catch (Exception e6) {
                String message2 = "Unable to close indexing" + e6.getLocalizedMessage();
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.log(Level.WARNING, message2, e6);
                }
                this.eventHandler.fireException(e6);
            }
            try {
                this.configHandler.indexingPostamble(!this.getStop());
                return;
            }
            catch (Exception e7) {
                String message3 = "Unable to close indexing" + e7.getLocalizedMessage();
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.log(Level.WARNING, message3, e7);
                }
                this.eventHandler.fireException(e7);
                return;
            }
        }
    }
}

