/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic;

import java.awt.RenderingHints;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.SampleModel;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.spi.ImageReaderSpi;
import javax.media.jai.ImageLayout;
import javax.xml.bind.JAXBException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.coverage.grid.io.StructuredGridCoverage2DReader;
import org.geotools.data.DataUtilities;
import org.geotools.data.DefaultTransaction;
import org.geotools.factory.Hints;
import org.geotools.gce.imagemosaic.CatalogManager;
import org.geotools.gce.imagemosaic.ImageMosaicEventHandlers;
import org.geotools.gce.imagemosaic.ImageMosaicReader;
import org.geotools.gce.imagemosaic.MosaicConfigurationBean;
import org.geotools.gce.imagemosaic.RasterManager;
import org.geotools.gce.imagemosaic.Utils;
import org.geotools.gce.imagemosaic.catalog.CatalogConfigurationBean;
import org.geotools.gce.imagemosaic.catalog.GranuleCatalog;
import org.geotools.gce.imagemosaic.catalog.index.DomainType;
import org.geotools.gce.imagemosaic.catalog.index.DomainsType;
import org.geotools.gce.imagemosaic.catalog.index.Indexer;
import org.geotools.gce.imagemosaic.catalog.index.IndexerUtils;
import org.geotools.gce.imagemosaic.catalog.index.ParametersType;
import org.geotools.gce.imagemosaic.catalog.index.SchemaType;
import org.geotools.gce.imagemosaic.catalog.index.SchemasType;
import org.geotools.gce.imagemosaic.catalogbuilder.CatalogBuilderConfiguration;
import org.geotools.gce.imagemosaic.catalogbuilder.MosaicBeanBuilder;
import org.geotools.gce.imagemosaic.properties.PropertiesCollector;
import org.geotools.gce.imagemosaic.properties.PropertiesCollectorFinder;
import org.geotools.gce.imagemosaic.properties.PropertiesCollectorSPI;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.util.Utilities;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class ImageMosaicConfigHandler {
    static final Logger LOGGER = Logging.getLogger(ImageMosaicConfigHandler.class);
    private List<PropertiesCollector> propertiesCollectors = null;
    private Map<String, MosaicConfigurationBean> configurations = new HashMap<String, MosaicConfigurationBean>();
    private volatile boolean stop = false;
    protected GranuleCatalog catalog;
    private CatalogBuilderConfiguration runConfiguration;
    private ImageReaderSpi cachedReaderSPI;
    private ReferencedEnvelope imposedBBox;
    private ImageMosaicReader parentReader;
    private File indexerFile;
    private File parent;
    private ImageMosaicEventHandlers eventHandler;
    private boolean useExistingSchema;

    public ImageMosaicConfigHandler(CatalogBuilderConfiguration configuration, ImageMosaicEventHandlers eventHandler) {
        Utilities.ensureNonNull((String)"runConfiguration", (Object)configuration);
        Utilities.ensureNonNull((String)"eventHandler", (Object)eventHandler);
        this.eventHandler = eventHandler;
        Indexer defaultIndexer = configuration.getIndexer();
        ParametersType params = null;
        String rootMosaicDir = null;
        if (defaultIndexer != null) {
            params = defaultIndexer.getParameters();
            rootMosaicDir = IndexerUtils.getParam(params, "RootMosaicDirectory");
            IndexerUtils.getParameterAsBoolean("UseExistingSchema", defaultIndexer);
        }
        Utilities.ensureNonNull((String)"root location", rootMosaicDir);
        this.parent = new File(rootMosaicDir);
        this.indexerFile = new File(this.parent, "indexer.xml");
        Indexer indexer = null;
        Hints hints = configuration.getHints();
        String ancillaryFile = null;
        String datastoreFile = null;
        if (Utils.checkFileReadable(this.indexerFile)) {
            try {
                indexer = Utils.unmarshal(this.indexerFile);
                if (indexer != null) {
                    this.copyDefaultParams(params, indexer);
                }
            }
            catch (JAXBException e) {
                LOGGER.log(Level.WARNING, e.getMessage(), e);
            }
        } else {
            this.indexerFile = new File(this.parent, "indexer.properties");
            if (Utils.checkFileReadable(this.indexerFile)) {
                Properties props = Utils.loadPropertiesFromURL(DataUtilities.fileToURL(this.indexerFile));
                indexer = this.createIndexer(props, params);
            }
        }
        if (indexer != null) {
            String datastoreFileParam;
            configuration.setIndexer(indexer);
            String auxiliaryFileParam = IndexerUtils.getParameter("AuxiliaryFile", indexer);
            if (auxiliaryFileParam != null) {
                ancillaryFile = auxiliaryFileParam;
            }
            if ((datastoreFileParam = IndexerUtils.getParameter("AuxiliaryDatastoreFile", indexer)) != null) {
                datastoreFile = datastoreFileParam;
            }
            if (datastoreFileParam != null || auxiliaryFileParam != null) {
                this.setReader(hints, false);
            }
            if (IndexerUtils.getParameterAsBoolean("UseExistingSchema", indexer)) {
                this.useExistingSchema = true;
            }
        }
        this.updateConfigurationHints(configuration, hints, ancillaryFile, datastoreFile, IndexerUtils.getParam(params, "RootMosaicDirectory"));
        configuration.check();
        this.runConfiguration = new CatalogBuilderConfiguration(configuration);
    }

    private void setReader(Hints hints, boolean updateHints) {
        Object reader;
        if (hints != null && hints.containsKey((Object)Utils.MOSAIC_READER) && (reader = hints.get((Object)Utils.MOSAIC_READER)) instanceof ImageMosaicReader) {
            if (this.getParentReader() == null) {
                this.setParentReader((ImageMosaicReader)((Object)reader));
            }
            if (updateHints) {
                Hints readerHints = this.getParentReader().getHints();
                readerHints.add((RenderingHints)hints);
            }
        }
    }

    private void updateConfigurationHints(CatalogBuilderConfiguration configuration, Hints hints, String ancillaryFile, String datastoreFile, String rootMosaicDir) {
        boolean isAbsolutePath = Boolean.parseBoolean(configuration.getParameter("AbsolutePath"));
        hints = this.updateHints(ancillaryFile, isAbsolutePath, rootMosaicDir, configuration, hints, Utils.AUXILIARY_FILES_PATH);
        hints = this.updateHints(datastoreFile, isAbsolutePath, rootMosaicDir, configuration, hints, Utils.AUXILIARY_DATASTORE_PATH);
        this.setReader(hints, true);
    }

    private Hints updateHints(String filePath, boolean isAbsolutePath, String rootMosaicDir, CatalogBuilderConfiguration configuration, Hints hints, Hints.Key key) {
        String updatedFilePath = null;
        if (filePath != null) {
            updatedFilePath = isAbsolutePath ? rootMosaicDir + File.separatorChar + filePath : filePath;
            if (hints != null) {
                hints.put((Object)key, (Object)updatedFilePath);
            } else {
                hints = new Hints((RenderingHints.Key)key, (Object)updatedFilePath);
                configuration.setHints(hints);
            }
            if (!isAbsolutePath) {
                hints.put((Object)Utils.PARENT_DIR, (Object)rootMosaicDir);
            }
        }
        return hints;
    }

    private void copyDefaultParams(ParametersType params, Indexer indexer) {
        List<ParametersType.Parameter> defaultParamList;
        if (params != null && (defaultParamList = params.getParameter()) != null && !defaultParamList.isEmpty()) {
            ParametersType parameters = indexer.getParameters();
            if (parameters == null) {
                parameters = Utils.OBJECT_FACTORY.createParametersType();
                indexer.setParameters(parameters);
            }
            List<ParametersType.Parameter> parameterList = parameters.getParameter();
            for (ParametersType.Parameter defaultParameter : defaultParamList) {
                String defaultParameterName = defaultParameter.getName();
                if (IndexerUtils.getParameter(defaultParameterName, indexer) != null) continue;
                IndexerUtils.setParam(parameterList, defaultParameterName, defaultParameter.getValue());
            }
        }
    }

    public void reset() {
        this.eventHandler.removeAllProcessingEventListeners();
        this.stop = false;
        this.runConfiguration = null;
    }

    public boolean getStop() {
        return this.stop;
    }

    public void stop() {
        this.stop = true;
    }

    void indexingPreamble() throws IOException {
        block2: {
            this.catalog = this.buildCatalog();
            String bbox = this.runConfiguration.getParameter("Envelope2D");
            try {
                this.imposedBBox = Utils.parseEnvelope(bbox);
            }
            catch (Exception e) {
                this.imposedBBox = null;
                if (!LOGGER.isLoggable(Level.WARNING)) break block2;
                LOGGER.log(Level.WARNING, "Unable to parse imposed bbox", e);
            }
        }
        this.loadPropertyCollectors();
    }

    protected GranuleCatalog buildCatalog() throws IOException {
        GranuleCatalog catalog;
        this.getParentReader().granuleCatalog = catalog = CatalogManager.createCatalog(this.runConfiguration, !this.useExistingSchema);
        return catalog;
    }

    private void loadPropertyCollectors() {
        Indexer indexer = this.runConfiguration.getIndexer();
        Indexer.Collectors collectors = indexer.getCollectors();
        if (collectors == null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("No properties collector have been found");
            }
            return;
        }
        List<Indexer.Collectors.Collector> collectorList = collectors.getCollector();
        Set<PropertiesCollectorSPI> pcSPIs = PropertiesCollectorFinder.getPropertiesCollectorSPI();
        ArrayList<PropertiesCollector> pcs = new ArrayList<PropertiesCollector>();
        for (Indexer.Collectors.Collector collector : collectorList) {
            PropertiesCollectorSPI selectedSPI = null;
            String spiName = collector.getSpi();
            for (PropertiesCollectorSPI spi : pcSPIs) {
                if (!spi.isAvailable() || !spi.getName().equalsIgnoreCase(spiName)) continue;
                selectedSPI = spi;
                break;
            }
            if (selectedSPI == null) {
                if (!LOGGER.isLoggable(Level.INFO)) continue;
                LOGGER.info("Unable to find a PropertyCollector for this definition: " + spiName);
                continue;
            }
            String collectorValue = collector.getValue();
            String config = !collectorValue.startsWith("regex=") ? "regex=" + collector.getValue() : collector.getValue();
            PropertiesCollector pc = selectedSPI.create(config, Arrays.asList(collector.getMapped()));
            if (pc != null) {
                pcs.add(pc);
                continue;
            }
            if (!LOGGER.isLoggable(Level.INFO)) continue;
            LOGGER.info("Unable to create PropertyCollector");
        }
        this.propertiesCollectors = pcs;
    }

    void indexingPostamble(boolean success) throws IOException {
        if (success) {
            boolean haveConfigs;
            Indexer indexer = this.runConfiguration.getIndexer();
            boolean supportsEmpty = false;
            if (indexer != null) {
                supportsEmpty = IndexerUtils.getParameterAsBoolean("CanBeEmpty", indexer);
            }
            boolean bl = haveConfigs = this.configurations != null && !this.configurations.isEmpty();
            if (haveConfigs || supportsEmpty) {
                Set<String> keys = this.configurations.keySet();
                int keySize = keys.size();
                if (haveConfigs || !supportsEmpty) {
                    boolean useName = keySize > 1;
                    for (String key : keys) {
                        MosaicConfigurationBean mosaicConfiguration = this.configurations.get(key);
                        RasterManager manager = this.parentReader.getRasterManager(key);
                        manager.initialize(supportsEmpty);
                        this.createSampleImage(mosaicConfiguration, useName);
                        this.eventHandler.fireEvent(Level.INFO, "Creating final properties file ", 99.9);
                        this.createPropertiesFiles(mosaicConfiguration);
                    }
                }
                String base = FilenameUtils.getName((String)this.parent.getAbsolutePath());
                if (supportsEmpty || keySize > 1 || keySize > 0 && !base.equals(keys.iterator().next())) {
                    File mosaicFile = null;
                    File originFile = null;
                    if (this.indexerFile.getAbsolutePath().endsWith("xml")) {
                        mosaicFile = new File(this.indexerFile.getAbsolutePath().replace("indexer.xml", base + ".xml"));
                        originFile = this.indexerFile;
                    } else if (this.indexerFile.getAbsolutePath().endsWith("properties")) {
                        mosaicFile = new File(this.indexerFile.getAbsolutePath().replace("indexer.properties", base + ".properties"));
                        originFile = this.indexerFile;
                    } else {
                        String source = this.runConfiguration.getParameter("RootMosaicDirectory") + File.separatorChar + this.configurations.get(keys.iterator().next()).getName() + ".properties";
                        mosaicFile = new File(this.indexerFile.getAbsolutePath().replace("indexer.properties", base + ".properties"));
                        originFile = new File(source);
                    }
                    if (!mosaicFile.exists()) {
                        FileUtils.copyFile((File)originFile, (File)mosaicFile);
                    }
                }
                this.eventHandler.fireEvent(Level.FINE, "Done!!!", 100.0);
            } else {
                this.eventHandler.fireEvent(Level.FINE, "Nothing to process!!!", 100.0);
            }
        } else {
            this.eventHandler.fireEvent(Level.FINE, "Canceled!!!", 100.0);
        }
    }

    private void createSampleImage(MosaicConfigurationBean mosaicConfiguration, boolean useName) {
        Utilities.ensureNonNull((String)"mosaicConfiguration", (Object)mosaicConfiguration);
        String filePath = null;
        if (mosaicConfiguration.getSampleModel() != null && mosaicConfiguration.getColorModel() != null) {
            String baseName = this.runConfiguration.getParameter("RootMosaicDirectory") + "/";
            filePath = baseName + (useName ? mosaicConfiguration.getName() : "") + "sample_image";
            try {
                Utils.storeSampleImage(new File(filePath), mosaicConfiguration.getSampleModel(), mosaicConfiguration.getColorModel());
            }
            catch (IOException e) {
                this.eventHandler.fireEvent(Level.SEVERE, e.getLocalizedMessage(), 0.0);
            }
        }
    }

    private Indexer createIndexer(Properties props, ParametersType params) {
        DomainType domain;
        Indexer indexer = Utils.OBJECT_FACTORY.createIndexer();
        indexer.setParameters(params != null ? params : Utils.OBJECT_FACTORY.createParametersType());
        Indexer.Coverages coverages = Utils.OBJECT_FACTORY.createIndexerCoverages();
        indexer.setCoverages(coverages);
        List<Indexer.Coverages.Coverage> coverageList = coverages.getCoverage();
        Indexer.Coverages.Coverage coverage = Utils.OBJECT_FACTORY.createIndexerCoveragesCoverage();
        coverageList.add(coverage);
        indexer.setParameters(params);
        List<ParametersType.Parameter> parameters = params.getParameter();
        if (props.containsKey("Name")) {
            IndexerUtils.setParam(parameters, props, "Name");
            coverage.setName(props.getProperty("Name"));
        }
        if (props.containsKey("TypeName")) {
            IndexerUtils.setParam(parameters, props, "TypeName");
            coverage.setName(props.getProperty("TypeName"));
        }
        if (props.containsKey("AbsolutePath")) {
            IndexerUtils.setParam(parameters, props, "AbsolutePath");
        }
        if (props.containsKey("Recursive")) {
            IndexerUtils.setParam(parameters, props, "Recursive");
        }
        if (props.containsKey("Wildcard")) {
            IndexerUtils.setParam(parameters, props, "Wildcard");
        }
        if (props.containsKey("Schema")) {
            SchemasType schemas = Utils.OBJECT_FACTORY.createSchemasType();
            SchemaType schema = Utils.OBJECT_FACTORY.createSchemaType();
            indexer.setSchemas(schemas);
            schemas.getSchema().add(schema);
            schema.setAttributes(props.getProperty("Schema"));
            schema.setName(IndexerUtils.getParameter("Name", indexer));
        }
        DomainsType domains = coverage.getDomains();
        List<DomainType> domainList = null;
        if (props.containsKey("TimeAttribute")) {
            if (domains == null) {
                domains = Utils.OBJECT_FACTORY.createDomainsType();
                coverage.setDomains(domains);
                domainList = domains.getDomain();
            }
            domain = Utils.OBJECT_FACTORY.createDomainType();
            domain.setName("TIME".toLowerCase());
            IndexerUtils.setAttributes(domain, props.getProperty("TimeAttribute"));
            domainList.add(domain);
        }
        if (props.containsKey("ElevationAttribute")) {
            if (domains == null) {
                domains = Utils.OBJECT_FACTORY.createDomainsType();
                coverage.setDomains(domains);
                domainList = domains.getDomain();
            }
            domain = Utils.OBJECT_FACTORY.createDomainType();
            domain.setName("ELEVATION".toLowerCase());
            IndexerUtils.setAttributes(domain, props.getProperty("ElevationAttribute"));
            domainList.add(domain);
        }
        if (props.containsKey("AdditionalDomainAttributes")) {
            if (domains == null) {
                domains = Utils.OBJECT_FACTORY.createDomainsType();
                coverage.setDomains(domains);
                domainList = domains.getDomain();
            }
            String attributes = props.getProperty("AdditionalDomainAttributes");
            IndexerUtils.parseAdditionalDomains(attributes, domainList);
        }
        if (props.containsKey("Envelope2D")) {
            IndexerUtils.setParam(parameters, props, "Envelope2D");
        }
        if (props.containsKey("ResolutionLevels")) {
            IndexerUtils.setParam(parameters, props, "ResolutionLevels");
        }
        if (props.containsKey("PropertyCollectors")) {
            IndexerUtils.setPropertyCollectors(indexer, props.getProperty("PropertyCollectors"));
        }
        if (props.containsKey("Caching")) {
            IndexerUtils.setParam(parameters, props, "Caching");
        }
        if (props.containsKey("RootMosaicDirectory")) {
            IndexerUtils.setParam(parameters, props, "RootMosaicDirectory");
        }
        if (props.containsKey("IndexingDirectories")) {
            IndexerUtils.setParam(parameters, props, "IndexingDirectories");
        }
        if (props.containsKey("AuxiliaryFile")) {
            IndexerUtils.setParam(parameters, props, "AuxiliaryFile");
        }
        if (props.containsKey("AuxiliaryDatastoreFile")) {
            IndexerUtils.setParam(parameters, props, "AuxiliaryDatastoreFile");
        }
        if (props.containsKey("CanBeEmpty")) {
            IndexerUtils.setParam(parameters, props, "CanBeEmpty");
        }
        if (props.containsKey("WrapStore")) {
            IndexerUtils.setParam(parameters, props, "WrapStore");
        }
        if (props.containsKey("UseExistingSchema")) {
            IndexerUtils.setParam(parameters, props, "UseExistingSchema");
        }
        if (props.containsKey("CheckAuxiliaryMetadata")) {
            IndexerUtils.setParam(parameters, props, "CheckAuxiliaryMetadata");
        }
        return indexer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void createPropertiesFiles(MosaicConfigurationBean mosaicConfiguration) {
        String additionalDomainAttribute;
        String elevationAttribute;
        CatalogConfigurationBean catalogConfigurationBean = mosaicConfiguration.getCatalogConfigurationBean();
        Properties properties = new Properties();
        properties.setProperty("AbsolutePath", Boolean.toString(catalogConfigurationBean.isAbsolutePath()));
        properties.setProperty("LocationAttribute", catalogConfigurationBean.getLocationAttribute());
        String timeAttribute = mosaicConfiguration.getTimeAttribute();
        if (timeAttribute != null) {
            properties.setProperty("TimeAttribute", mosaicConfiguration.getTimeAttribute());
        }
        if ((elevationAttribute = mosaicConfiguration.getElevationAttribute()) != null) {
            properties.setProperty("ElevationAttribute", mosaicConfiguration.getElevationAttribute());
        }
        if ((additionalDomainAttribute = mosaicConfiguration.getAdditionalDomainAttributes()) != null) {
            properties.setProperty("AdditionalDomainAttributes", mosaicConfiguration.getAdditionalDomainAttributes());
        }
        int numberOfLevels = mosaicConfiguration.getLevelsNum();
        double[][] resolutionLevels = mosaicConfiguration.getLevels();
        properties.setProperty("LevelsNum", Integer.toString(numberOfLevels));
        StringBuilder levels = new StringBuilder();
        for (int k = 0; k < numberOfLevels; ++k) {
            levels.append(Double.toString(resolutionLevels[k][0])).append(",").append(Double.toString(resolutionLevels[k][1]));
            if (k >= numberOfLevels - 1) continue;
            levels.append(" ");
        }
        properties.setProperty("Levels", levels.toString());
        properties.setProperty("Name", mosaicConfiguration.getName());
        String typeName = mosaicConfiguration.getCatalogConfigurationBean().getTypeName();
        if (typeName == null) {
            typeName = mosaicConfiguration.getName();
        }
        properties.setProperty("TypeName", typeName);
        properties.setProperty("ExpandToRGB", Boolean.toString(mosaicConfiguration.isExpandToRGB()));
        properties.setProperty("CheckAuxiliaryMetadata", Boolean.toString(mosaicConfiguration.isCheckAuxiliaryMetadata()));
        properties.setProperty("Heterogeneous", Boolean.toString(catalogConfigurationBean.isHeterogeneous()));
        boolean wrapStore = catalogConfigurationBean.isWrapStore();
        if (wrapStore) {
            properties.setProperty("WrapStore", Boolean.toString(wrapStore));
        }
        if (this.cachedReaderSPI != null) {
            properties.setProperty("SuggestedSPI", this.cachedReaderSPI.getClass().getName());
        }
        if (this.imposedBBox != null) {
            properties.setProperty("Envelope2D", this.imposedBBox.getMinX() + "," + this.imposedBBox.getMinY() + " " + this.imposedBBox.getMaxX() + "," + this.imposedBBox.getMaxY());
        }
        properties.setProperty("Caching", Boolean.toString(catalogConfigurationBean.isCaching()));
        if (mosaicConfiguration.getAuxiliaryFilePath() != null) {
            properties.setProperty("AuxiliaryFile", mosaicConfiguration.getAuxiliaryFilePath());
        }
        if (mosaicConfiguration.getAuxiliaryDatastorePath() != null) {
            properties.setProperty("AuxiliaryDatastoreFile", mosaicConfiguration.getAuxiliaryDatastorePath());
        }
        BufferedOutputStream outStream = null;
        String filePath = this.runConfiguration.getParameter("RootMosaicDirectory") + "/" + mosaicConfiguration.getName() + ".properties";
        try {
            outStream = new BufferedOutputStream(new FileOutputStream(filePath));
            properties.store(outStream, "-Automagically created from GeoTools-");
            if (outStream == null) return;
        }
        catch (FileNotFoundException e) {
            this.eventHandler.fireEvent(Level.SEVERE, e.getLocalizedMessage(), 0.0);
            if (outStream == null) return;
            IOUtils.closeQuietly((OutputStream)outStream);
            return;
        }
        catch (IOException e2) {
            this.eventHandler.fireEvent(Level.SEVERE, e2.getLocalizedMessage(), 0.0);
            if (outStream == null) return;
            {
                catch (Throwable throwable) {
                    if (outStream == null) throw throwable;
                    IOUtils.closeQuietly(outStream);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((OutputStream)outStream);
            return;
        }
        IOUtils.closeQuietly((OutputStream)outStream);
        return;
    }

    protected boolean coverageExists(String coverageName) throws IOException {
        String[] coverages;
        for (String coverage : coverages = this.getParentReader().getGridCoverageNames()) {
            if (!coverage.equals(coverageName)) continue;
            return true;
        }
        return false;
    }

    public void updateConfiguration(GridCoverage2DReader coverageReader, String inputCoverageName, File fileBeingProcessed, int fileIndex, double numFiles, DefaultTransaction transaction) throws IOException {
        CatalogBuilderConfiguration catalogConfig;
        String indexName = this.getRunConfiguration().getParameter("Name");
        String coverageName = coverageReader instanceof StructuredGridCoverage2DReader ? inputCoverageName : indexName;
        Indexer indexer = this.getRunConfiguration().getIndexer();
        boolean coverageExists = this.coverageExists(coverageName);
        MosaicConfigurationBean mosaicConfiguration = null;
        MosaicConfigurationBean currentConfigurationBean = null;
        RasterManager rasterManager = null;
        if (coverageExists) {
            rasterManager = this.getParentReader().getRasterManager(coverageName);
            mosaicConfiguration = rasterManager.getConfiguration();
        }
        MosaicBeanBuilder configBuilder = new MosaicBeanBuilder();
        GeneralEnvelope envelope = coverageReader.getOriginalEnvelope(inputCoverageName);
        CoordinateReferenceSystem actualCRS = coverageReader.getCoordinateReferenceSystem(inputCoverageName);
        SampleModel sm = null;
        ColorModel cm = null;
        int numberOfLevels = 1;
        double[][] resolutionLevels = null;
        if (mosaicConfiguration == null) {
            catalogConfig = this.getRunConfiguration();
            ImageLayout layout = coverageReader.getImageLayout(inputCoverageName);
            cm = layout.getColorModel(null);
            sm = layout.getSampleModel(null);
            numberOfLevels = coverageReader.getNumOverviews(inputCoverageName) + 1;
            resolutionLevels = coverageReader.getResolutionLevels(inputCoverageName);
            configBuilder.setSampleModel(sm);
            configBuilder.setColorModel(cm);
            ColorModel defaultCM = cm;
            if (defaultCM instanceof IndexColorModel) {
                IndexColorModel icm = (IndexColorModel)defaultCM;
                byte[][] defaultPalette = Utils.extractPalette(icm);
                configBuilder.setPalette(defaultPalette);
            }
            configBuilder.setCrs(actualCRS);
            configBuilder.setLevels(resolutionLevels);
            configBuilder.setLevelsNum(numberOfLevels);
            configBuilder.setName(coverageName);
            configBuilder.setTimeAttribute(IndexerUtils.getAttribute(coverageName, "TIME", indexer));
            configBuilder.setElevationAttribute(IndexerUtils.getAttribute(coverageName, "ELEVATION", indexer));
            configBuilder.setAdditionalDomainAttributes(IndexerUtils.getAttribute(coverageName, "ADDITIONAL", indexer));
            Hints runHints = this.getRunConfiguration().getHints();
            if (runHints != null) {
                String auxiliaryDatastorePath;
                String auxiliaryFilePath;
                if (runHints.containsKey((Object)Utils.AUXILIARY_FILES_PATH) && (auxiliaryFilePath = (String)runHints.get((Object)Utils.AUXILIARY_FILES_PATH)) != null && auxiliaryFilePath.trim().length() > 0) {
                    configBuilder.setAuxiliaryFilePath(auxiliaryFilePath);
                }
                if (runHints.containsKey((Object)Utils.AUXILIARY_DATASTORE_PATH) && (auxiliaryDatastorePath = (String)runHints.get((Object)Utils.AUXILIARY_DATASTORE_PATH)) != null && auxiliaryDatastorePath.trim().length() > 0) {
                    configBuilder.setAuxiliaryDatastorePath(auxiliaryDatastorePath);
                }
            }
            CatalogConfigurationBean catalogConfigurationBean = new CatalogConfigurationBean();
            catalogConfigurationBean.setCaching(IndexerUtils.getParameterAsBoolean("Caching", indexer));
            catalogConfigurationBean.setAbsolutePath(IndexerUtils.getParameterAsBoolean("AbsolutePath", indexer));
            catalogConfigurationBean.setLocationAttribute(IndexerUtils.getParameter("LocationAttribute", indexer));
            catalogConfigurationBean.setWrapStore(IndexerUtils.getParameterAsBoolean("WrapStore", indexer));
            String configuredTypeName = IndexerUtils.getParameter("TypeName", indexer);
            if (configuredTypeName != null) {
                catalogConfigurationBean.setTypeName(configuredTypeName);
            } else {
                catalogConfigurationBean.setTypeName(coverageName);
            }
            configBuilder.setCatalogConfigurationBean(catalogConfigurationBean);
            configBuilder.setCheckAuxiliaryMetadata(IndexerUtils.getParameterAsBoolean("CheckAuxiliaryMetadata", indexer));
            currentConfigurationBean = configBuilder.getMosaicConfigurationBean();
            rasterManager = this.getParentReader().addRasterManager(currentConfigurationBean, false);
            if (!this.useExistingSchema) {
                SimpleFeatureType indexSchema = CatalogManager.createSchema(this.getRunConfiguration(), currentConfigurationBean.getName(), actualCRS);
                this.getParentReader().createCoverage(coverageName, indexSchema);
            }
            this.getConfigurations().put(currentConfigurationBean.getName(), currentConfigurationBean);
        } else {
            catalogConfig = new CatalogBuilderConfiguration();
            CatalogConfigurationBean bean = mosaicConfiguration.getCatalogConfigurationBean();
            catalogConfig.setParameter("LocationAttribute", bean.getLocationAttribute());
            catalogConfig.setParameter("AbsolutePath", Boolean.toString(bean.isAbsolutePath()));
            catalogConfig.setParameter("RootMosaicDirectory", this.getRunConfiguration().getParameter("RootMosaicDirectory"));
            CatalogConfigurationBean catalogConfigurationBean = bean;
            if (!catalogConfigurationBean.isHeterogeneous()) {
                numberOfLevels = coverageReader.getNumOverviews(inputCoverageName) + 1;
                boolean needUpdate = false;
                if (numberOfLevels != mosaicConfiguration.getLevelsNum()) {
                    catalogConfigurationBean.setHeterogeneous(true);
                    if (numberOfLevels > mosaicConfiguration.getLevelsNum()) {
                        resolutionLevels = coverageReader.getResolutionLevels(inputCoverageName);
                        mosaicConfiguration.setLevels(resolutionLevels);
                        mosaicConfiguration.setLevelsNum(numberOfLevels);
                        needUpdate = true;
                    }
                } else {
                    double[][] mosaicLevels = mosaicConfiguration.getLevels();
                    resolutionLevels = coverageReader.getResolutionLevels(inputCoverageName);
                    boolean homogeneousLevels = Utils.homogeneousCheck(numberOfLevels, resolutionLevels, mosaicLevels);
                    if (!homogeneousLevels) {
                        catalogConfigurationBean.setHeterogeneous(true);
                        needUpdate = true;
                    }
                }
                if (needUpdate) {
                    this.getConfigurations().put(mosaicConfiguration.getName(), mosaicConfiguration);
                }
            }
            ImageLayout layout = coverageReader.getImageLayout(inputCoverageName);
            cm = layout.getColorModel(null);
            sm = layout.getSampleModel(null);
            ColorModel actualCM = cm;
            CoordinateReferenceSystem expectedCRS = mosaicConfiguration.getCrs() != null ? mosaicConfiguration.getCrs() : rasterManager.spatialDomainManager.coverageCRS;
            if (!CRS.equalsIgnoreMetadata((Object)expectedCRS, (Object)actualCRS)) {
                this.eventHandler.fireFileEvent(Level.INFO, fileBeingProcessed, false, "Skipping image " + fileBeingProcessed + " because CRSs do not match.", (double)(fileIndex + 1) * 99.0 / numFiles);
                return;
            }
            byte[][] palette = mosaicConfiguration.getPalette();
            ColorModel colorModel = mosaicConfiguration.getColorModel();
            if (colorModel == null) {
                colorModel = rasterManager.defaultCM;
            }
            if (palette == null) {
                palette = rasterManager.defaultPalette;
            }
            if (Utils.checkColorModels(colorModel, palette, actualCM)) {
                this.eventHandler.fireFileEvent(Level.INFO, fileBeingProcessed, false, "Skipping image " + fileBeingProcessed + " because color models do not match.", (double)(fileIndex + 1) * 99.0 / numFiles);
                return;
            }
        }
        if (!this.useExistingSchema) {
            CatalogManager.updateCatalog(coverageName, fileBeingProcessed, coverageReader, this.getParentReader(), catalogConfig, envelope, transaction, this.getPropertiesCollectors());
        }
    }

    public void dispose() {
        this.reset();
    }

    public Map<String, MosaicConfigurationBean> getConfigurations() {
        return this.configurations;
    }

    public GranuleCatalog getCatalog() {
        return this.catalog;
    }

    public CatalogBuilderConfiguration getRunConfiguration() {
        return this.runConfiguration;
    }

    public ImageMosaicReader getParentReader() {
        return this.parentReader;
    }

    public void setParentReader(ImageMosaicReader parentReader) {
        this.parentReader = parentReader;
    }

    public List<PropertiesCollector> getPropertiesCollectors() {
        return this.propertiesCollectors;
    }

    public boolean isUseExistingSchema() {
        return this.useExistingSchema;
    }

    public ImageReaderSpi getCachedReaderSPI() {
        return this.cachedReaderSPI;
    }

    public void setCachedReaderSPI(ImageReaderSpi cachedReaderSPI) {
        this.cachedReaderSPI = cachedReaderSPI;
    }
}

