/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.PrecisionModel;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.geotools.coverage.grid.io.GranuleSource;
import org.geotools.coverage.grid.io.GranuleStore;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.coverage.grid.io.StructuredGridCoverage2DReader;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataStoreFactorySpi;
import org.geotools.data.DataUtilities;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.Transaction;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.data.shapefile.ShapefileDataStoreFactory;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.factory.Hints;
import org.geotools.feature.collection.AbstractFeatureVisitor;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.gce.imagemosaic.ImageMosaicReader;
import org.geotools.gce.imagemosaic.MosaicConfigurationBean;
import org.geotools.gce.imagemosaic.ShapefileCompatibleFeature;
import org.geotools.gce.imagemosaic.Utils;
import org.geotools.gce.imagemosaic.catalog.CatalogConfigurationBean;
import org.geotools.gce.imagemosaic.catalog.GranuleCatalog;
import org.geotools.gce.imagemosaic.catalog.GranuleCatalogFactory;
import org.geotools.gce.imagemosaic.catalog.MultiLevelROIProvider;
import org.geotools.gce.imagemosaic.catalog.MultiLevelROIProviderFactory;
import org.geotools.gce.imagemosaic.catalog.index.Indexer;
import org.geotools.gce.imagemosaic.catalog.index.IndexerUtils;
import org.geotools.gce.imagemosaic.catalog.index.SchemaType;
import org.geotools.gce.imagemosaic.catalog.index.SchemasType;
import org.geotools.gce.imagemosaic.catalogbuilder.CatalogBuilderConfiguration;
import org.geotools.gce.imagemosaic.properties.PropertiesCollector;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.util.DefaultProgressListener;
import org.geotools.util.Utilities;
import org.geotools.util.logging.Logging;
import org.opengis.feature.Feature;
import org.opengis.feature.Property;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.expression.Expression;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class CatalogManager {
    private static final PrecisionModel PRECISION_MODEL = new PrecisionModel(PrecisionModel.FLOATING);
    private static final GeometryFactory GEOM_FACTORY = new GeometryFactory(PRECISION_MODEL);
    private static final Boolean USE_MEMORY_MAPPED_BUFFERS = !System.getProperty("os.name", "Windows").contains("Windows");
    private static final Logger LOGGER = Logging.getLogger(CatalogManager.class);

    public static GranuleCatalog createCatalog(CatalogBuilderConfiguration runConfiguration) throws IOException {
        return CatalogManager.createCatalog(runConfiguration, true);
    }

    public static GranuleCatalog createCatalog(CatalogBuilderConfiguration runConfiguration, boolean create) throws IOException {
        GranuleCatalog catalog;
        File parent = new File(runConfiguration.getParameter("RootMosaicDirectory"));
        File datastoreProperties = new File(parent, "datastore.properties");
        if (Utils.checkFileReadable(datastoreProperties)) {
            Properties properties = CatalogManager.createGranuleCatalogProperties(datastoreProperties);
            String indexerTypeName = runConfiguration.getParameter("TypeName");
            if (indexerTypeName != null && properties.getProperty("TypeName") == null) {
                properties.put("TypeName", indexerTypeName);
            }
            catalog = CatalogManager.createGranuleCatalogFromDatastore(parent, properties, create, Boolean.parseBoolean(runConfiguration.getParameter("WrapStore")), runConfiguration.getHints());
        } else {
            URL file = new File(parent, runConfiguration.getParameter("Name") + ".shp").toURI().toURL();
            Properties params = new Properties();
            params.put(ShapefileDataStoreFactory.URLP.key, file);
            if (file.getProtocol().equalsIgnoreCase("file")) {
                params.put(ShapefileDataStoreFactory.CREATE_SPATIAL_INDEX.key, Boolean.TRUE);
            }
            params.put(ShapefileDataStoreFactory.MEMORY_MAPPED.key, USE_MEMORY_MAPPED_BUFFERS);
            params.put(ShapefileDataStoreFactory.DBFTIMEZONE.key, TimeZone.getTimeZone("UTC"));
            params.put("LocationAttribute", runConfiguration.getParameter("LocationAttribute"));
            catalog = GranuleCatalogFactory.createGranuleCatalog(params, false, create, Utils.SHAPE_SPI, runConfiguration.getHints());
            MultiLevelROIProvider roi = MultiLevelROIProviderFactory.createFootprintProvider(parent);
            catalog.setMultiScaleROIProvider(roi);
        }
        return catalog;
    }

    public static void dropDatastore(File datastoreProperties) throws IOException {
        Properties properties = CatalogManager.createGranuleCatalogProperties(datastoreProperties);
        String SPIClass = properties.getProperty("SPI");
        try {
            DataStoreFactorySpi spi = (DataStoreFactorySpi)Class.forName(SPIClass).newInstance();
            Utils.dropDB(spi, properties);
        }
        catch (Exception e) {
            IOException ioe = new IOException();
            throw (IOException)ioe.initCause(e);
        }
    }

    public static Properties createGranuleCatalogProperties(File datastoreProperties) throws IOException {
        Properties properties = Utils.loadPropertiesFromURL(DataUtilities.fileToURL(datastoreProperties));
        if (properties == null) {
            throw new IOException("Unable to load properties from:" + datastoreProperties.getAbsolutePath());
        }
        return properties;
    }

    public static GranuleCatalog createGranuleCatalogFromDatastore(File parent, File datastoreProperties, boolean create, Hints hints) throws IOException {
        return CatalogManager.createGranuleCatalogFromDatastore(parent, datastoreProperties, create, false, hints);
    }

    public static GranuleCatalog createGranuleCatalogFromDatastore(File parent, File datastoreProperties, boolean create, boolean wraps, Hints hints) throws IOException {
        Utilities.ensureNonNull((String)"datastoreProperties", (Object)datastoreProperties);
        Properties properties = CatalogManager.createGranuleCatalogProperties(datastoreProperties);
        return CatalogManager.createGranuleCatalogFromDatastore(parent, properties, create, wraps, hints);
    }

    public static GranuleCatalog createGranuleCatalogFromDatastore(File parent, Properties properties, boolean create, boolean wraps, Hints hints) throws IOException {
        GranuleCatalog catalog = null;
        String SPIClass = properties.getProperty("SPI");
        try {
            DataStoreFactorySpi spi = (DataStoreFactorySpi)Class.forName(SPIClass).newInstance();
            properties.put("ParentLocation", DataUtilities.fileToURL(parent).toExternalForm());
            if (wraps) {
                properties.put("WrapStore", (Object)wraps);
            }
            catalog = GranuleCatalogFactory.createGranuleCatalog(properties, false, create, spi, hints);
            MultiLevelROIProvider rois = MultiLevelROIProviderFactory.createFootprintProvider(parent);
            catalog.setMultiScaleROIProvider(rois);
        }
        catch (Exception e) {
            IOException ioe = new IOException();
            throw (IOException)ioe.initCause(e);
        }
        return catalog;
    }

    public static SimpleFeatureType createSchema(CatalogBuilderConfiguration runConfiguration, String name, CoordinateReferenceSystem actualCRS) {
        SimpleFeatureType indexSchema = null;
        SchemaType schema = null;
        String schemaAttributes = null;
        Indexer indexer = runConfiguration.getIndexer();
        if (indexer != null) {
            List<SchemaType> schemaList;
            SchemasType schemas = indexer.getSchemas();
            Indexer.Coverages.Coverage coverage = IndexerUtils.getCoverage(indexer, name);
            if (coverage != null) {
                schema = IndexerUtils.getSchema(indexer, coverage);
            }
            if (schema != null) {
                schemaAttributes = schema.getAttributes();
            } else if (schemas != null && !(schemaList = schemas.getSchema()).isEmpty()) {
                schemaAttributes = schemaList.get(0).getAttributes();
            }
        }
        if (schemaAttributes == null) {
            schemaAttributes = runConfiguration.getSchema(name);
        }
        if (schemaAttributes != null) {
            schemaAttributes = schemaAttributes.trim();
            try {
                Set identifiers;
                indexSchema = DataUtilities.createType(name, schemaAttributes);
                indexSchema = DataUtilities.createSubType(indexSchema, DataUtilities.attributeNames(indexSchema), actualCRS);
                if (actualCRS != null && ((identifiers = actualCRS.getIdentifiers()) == null || identifiers.isEmpty())) {
                    Integer code = CRS.lookupEpsgCode((CoordinateReferenceSystem)actualCRS, (boolean)true);
                    int nativeSrid = code == null ? 0 : code;
                    GeometryDescriptor geometryDescriptor = indexSchema.getGeometryDescriptor();
                    if (geometryDescriptor != null) {
                        Map userData = geometryDescriptor.getUserData();
                        userData.put("nativeSRID", nativeSrid);
                    }
                }
            }
            catch (Throwable e) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                }
                indexSchema = null;
            }
        }
        if (indexSchema == null) {
            SimpleFeatureTypeBuilder featureBuilder = new SimpleFeatureTypeBuilder();
            featureBuilder.setName(runConfiguration.getParameter("Name"));
            featureBuilder.setNamespaceURI("http://www.geo-solutions.it/");
            featureBuilder.add(runConfiguration.getParameter("LocationAttribute").trim(), String.class);
            featureBuilder.add("the_geom", Polygon.class, actualCRS);
            featureBuilder.setDefaultGeometry("the_geom");
            String timeAttribute = runConfiguration.getTimeAttribute();
            CatalogManager.addAttributes(timeAttribute, featureBuilder, Date.class);
            indexSchema = featureBuilder.buildFeatureType();
        }
        return indexSchema;
    }

    private static void addAttributes(String attribute, SimpleFeatureTypeBuilder featureBuilder, Class classType) {
        if (attribute != null) {
            if (!attribute.contains(";")) {
                featureBuilder.add(attribute, classType);
            } else {
                String[] ranges = attribute.split(";");
                if (ranges.length != 2) {
                    throw new IllegalArgumentException("All ranges attribute need to be composed of a maximum of 2 elements:\nAs an instance (min;max) or (low;high) or (begin;end) , ...");
                }
                featureBuilder.add(ranges[0], classType);
                featureBuilder.add(ranges[1], classType);
            }
        }
    }

    static void updateCatalog(String coverageName, final File fileBeingProcessed, final GridCoverage2DReader inputReader, ImageMosaicReader mosaicReader, CatalogBuilderConfiguration configuration, GeneralEnvelope envelope, DefaultTransaction transaction, final List<PropertiesCollector> propertiesCollectors) throws IOException {
        GranuleStore store = (GranuleStore)mosaicReader.getGranules(coverageName, false);
        if (store == null) {
            throw new IllegalArgumentException("No valid granule store has been found for: " + coverageName);
        }
        final SimpleFeatureType indexSchema = store.getSchema();
        ShapefileCompatibleFeature feature = new ShapefileCompatibleFeature(DataUtilities.template(indexSchema));
        store.setTransaction((Transaction)transaction);
        final ListFeatureCollection collection = new ListFeatureCollection(indexSchema);
        final String fileLocation = CatalogManager.prepareLocation(configuration, fileBeingProcessed);
        final String locationAttribute = configuration.getParameter("LocationAttribute");
        if (inputReader instanceof StructuredGridCoverage2DReader) {
            GranuleSource source = ((StructuredGridCoverage2DReader)inputReader).getGranules(coverageName, true);
            SimpleFeatureCollection originCollection = source.getGranules(null);
            final DefaultProgressListener listener = new DefaultProgressListener();
            Collection destProps = feature.getProperties();
            final HashSet<Name> destAttributes = new HashSet<Name>();
            for (Property prop : destProps) {
                destAttributes.add(prop.getName());
            }
            originCollection.accepts(new AbstractFeatureVisitor(){

                public void visit(Feature feature) {
                    if (feature instanceof SimpleFeature) {
                        SimpleFeature sourceFeature = (SimpleFeature)feature;
                        SimpleFeature destFeature = DataUtilities.template(indexSchema);
                        Collection props = sourceFeature.getProperties();
                        Name propName = null;
                        Object propValue = null;
                        for (Property prop : props) {
                            propName = prop.getName();
                            propValue = prop.getValue();
                            if (!destAttributes.contains(propName)) continue;
                            destFeature.setAttribute(propName, propValue);
                        }
                        destFeature.setAttribute(locationAttribute, (Object)fileLocation);
                        CatalogManager.updateAttributesFromCollectors(destFeature, fileBeingProcessed, inputReader, propertiesCollectors);
                        collection.add(destFeature);
                        if (listener.isCanceled() || listener.hasExceptions()) {
                            if (listener.hasExceptions()) {
                                throw new RuntimeException(listener.getExceptions().peek());
                            }
                            throw new IllegalStateException("Feature visitor has been canceled");
                        }
                    }
                }
            }, listener);
        } else {
            feature.setAttribute(indexSchema.getGeometryDescriptor().getLocalName(), GEOM_FACTORY.toGeometry((Envelope)new ReferencedEnvelope((org.opengis.geometry.Envelope)envelope)));
            feature.setAttribute(locationAttribute, fileLocation);
            CatalogManager.updateAttributesFromCollectors(feature, fileBeingProcessed, inputReader, propertiesCollectors);
            collection.add(feature);
        }
        PropertyIsEqualTo filter = Utils.FF.equal((Expression)Utils.FF.property(locationAttribute), (Expression)Utils.FF.literal((Object)fileLocation), !CatalogManager.isCaseSensitiveFileSystem(fileBeingProcessed));
        store.removeGranules((Filter)filter);
        store.addGranules((SimpleFeatureCollection)collection);
    }

    private static boolean isCaseSensitiveFileSystem(File fileBeingProcessed) {
        File loCase = new File(fileBeingProcessed.getParentFile(), fileBeingProcessed.getName().toLowerCase());
        File upCase = new File(fileBeingProcessed.getParentFile(), fileBeingProcessed.getName().toUpperCase());
        return loCase.exists() && upCase.exists();
    }

    private static void updateAttributesFromCollectors(SimpleFeature feature, File fileBeingProcessed, GridCoverage2DReader inputReader, List<PropertiesCollector> propertiesCollectors) {
        if (propertiesCollectors != null && propertiesCollectors.size() > 0) {
            for (PropertiesCollector pc : propertiesCollectors) {
                pc.collect(fileBeingProcessed).collect(inputReader).setProperties(feature);
                pc.reset();
            }
        }
    }

    private static String prepareLocation(CatalogBuilderConfiguration runConfiguration, File fileBeingProcessed) throws IOException {
        if (Boolean.valueOf(runConfiguration.getParameter("AbsolutePath")).booleanValue()) {
            return fileBeingProcessed.getAbsolutePath();
        }
        String targetPath = fileBeingProcessed.getCanonicalPath();
        String basePath = runConfiguration.getParameter("RootMosaicDirectory");
        String relative = CatalogManager.getRelativePath(targetPath, basePath, File.separator);
        return relative;
    }

    public static String getRelativePath(String targetPath, String basePath, String pathSeparator) {
        int commonIndex;
        String normalizedTargetPath = FilenameUtils.normalizeNoEndSeparator((String)targetPath);
        String normalizedBasePath = FilenameUtils.normalizeNoEndSeparator((String)basePath);
        if (pathSeparator.equals("/")) {
            normalizedTargetPath = FilenameUtils.separatorsToUnix((String)normalizedTargetPath);
            normalizedBasePath = FilenameUtils.separatorsToUnix((String)normalizedBasePath);
        } else if (pathSeparator.equals("\\")) {
            normalizedTargetPath = FilenameUtils.separatorsToWindows((String)normalizedTargetPath);
            normalizedBasePath = FilenameUtils.separatorsToWindows((String)normalizedBasePath);
        } else {
            throw new IllegalArgumentException("Unrecognised dir separator '" + pathSeparator + "'");
        }
        String[] base = normalizedBasePath.split(Pattern.quote(pathSeparator));
        String[] target = normalizedTargetPath.split(Pattern.quote(pathSeparator));
        StringBuilder common = new StringBuilder();
        for (commonIndex = 0; commonIndex < target.length && commonIndex < base.length && target[commonIndex].equals(base[commonIndex]); ++commonIndex) {
            common.append(target[commonIndex] + pathSeparator);
        }
        if (commonIndex == 0) {
            throw new RuntimeException("No common path element found for '" + normalizedTargetPath + "' and '" + normalizedBasePath + "'");
        }
        boolean baseIsFile = true;
        File baseResource = new File(normalizedBasePath);
        if (baseResource.exists()) {
            baseIsFile = baseResource.isFile();
        } else if (basePath.endsWith(pathSeparator)) {
            baseIsFile = false;
        }
        StringBuilder relative = new StringBuilder();
        if (base.length != commonIndex) {
            int numDirsUp = baseIsFile ? base.length - commonIndex - 1 : base.length - commonIndex;
            for (int i = 0; i < numDirsUp; ++i) {
                relative.append(".." + pathSeparator);
            }
        }
        relative.append(normalizedTargetPath.substring(common.length()));
        return relative.toString();
    }

    private static void checkTypeName(URL sourceURL, MosaicConfigurationBean configuration) throws IOException {
        CatalogConfigurationBean catalogBean = configuration.getCatalogConfigurationBean();
        if (catalogBean.getTypeName() == null) {
            if (sourceURL.getPath().endsWith("shp")) {
                File file = DataUtilities.urlToFile(sourceURL);
                catalogBean.setTypeName(FilenameUtils.getBaseName((String)file.getCanonicalPath()));
            } else {
                catalogBean.setTypeName("mosaic");
            }
        }
    }

    static GranuleCatalog createCatalog(URL sourceURL, MosaicConfigurationBean configuration, Hints hints) throws IOException {
        CatalogConfigurationBean catalogBean = configuration.getCatalogConfigurationBean();
        CatalogManager.checkTypeName(sourceURL, configuration);
        if (hints != null && hints.containsKey((Object)Hints.MOSAIC_LOCATION_ATTRIBUTE)) {
            String hintLocation = (String)hints.get((Object)Hints.MOSAIC_LOCATION_ATTRIBUTE);
            if (!catalogBean.getLocationAttribute().equalsIgnoreCase(hintLocation)) {
                throw new DataSourceException("wrong location attribute");
            }
        }
        GranuleCatalog catalog = GranuleCatalogFactory.createGranuleCatalog(sourceURL, catalogBean, null, hints);
        File parent = DataUtilities.urlToFile(sourceURL).getParentFile();
        MultiLevelROIProvider rois = MultiLevelROIProviderFactory.createFootprintProvider(parent);
        catalog.setMultiScaleROIProvider(rois);
        return catalog;
    }
}

