/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.web.jdbc;

import java.sql.Connection;
import java.sql.DriverManager;
import java.util.logging.Level;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxSubmitLink;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.PasswordTextField;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.panel.FeedbackPanel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.StringResourceModel;
import org.geoserver.security.jdbc.config.JDBCConnectAuthProviderConfig;
import org.geoserver.security.web.auth.AuthenticationProviderPanel;
import org.geoserver.security.web.jdbc.JDBCDriverChoice;
import org.geoserver.security.web.usergroup.UserGroupServiceChoice;

public class JDBCAuthProviderPanel
extends AuthenticationProviderPanel<JDBCConnectAuthProviderConfig> {
    private static final long serialVersionUID = 1L;
    FeedbackPanel feedbackPanel;
    String username;
    String password;

    public JDBCAuthProviderPanel(String id, IModel<JDBCConnectAuthProviderConfig> model) {
        super(id, model);
        this.add(new Component[]{new UserGroupServiceChoice("userGroupServiceName")});
        this.add(new Component[]{new JDBCDriverChoice("driverClassName")});
        this.add(new Component[]{new TextField("connectURL")});
        TextField userNameField = new TextField("username");
        userNameField.setModel((IModel)new PropertyModel((Object)this, "username"));
        userNameField.setRequired(false);
        this.add(new Component[]{userNameField});
        PasswordTextField pwdField = new PasswordTextField("password");
        pwdField.setModel((IModel)new PropertyModel((Object)this, "password"));
        pwdField.setRequired(false);
        pwdField.setResetPassword(true);
        this.add(new Component[]{pwdField});
        this.add(new Component[]{new AjaxSubmitLink("cxTest"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                try {
                    JDBCAuthProviderPanel.this.test();
                    this.info((String)new StringResourceModel("connectionSuccessful", (Component)JDBCAuthProviderPanel.this, null).getObject());
                }
                catch (Exception e) {
                    this.error(e);
                    LOGGER.log(Level.WARNING, "Connection error", e);
                }
                finally {
                    target.addComponent((Component)JDBCAuthProviderPanel.this.feedbackPanel);
                }
            }
        }.setDefaultFormProcessing(false)});
        Component[] componentArray = new Component[1];
        this.feedbackPanel = new FeedbackPanel("feedback");
        componentArray[0] = this.feedbackPanel;
        this.add(componentArray);
        this.feedbackPanel.setOutputMarkupId(true);
    }

    public void test() throws Exception {
        ((FormComponent)this.get("driverClassName")).processInput();
        ((FormComponent)this.get("connectURL")).processInput();
        ((FormComponent)this.get("username")).processInput();
        ((FormComponent)this.get("password")).processInput();
        Class.forName(this.get("driverClassName").getDefaultModelObjectAsString());
        Connection cx = DriverManager.getConnection(this.get("connectURL").getDefaultModelObjectAsString(), this.get("username").getDefaultModelObjectAsString(), this.get("password").getDefaultModelObjectAsString());
        cx.close();
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }
}

