/*
 * Decompiled with CFR 0.152.
 */
package org.tuckey.web.filters.validation;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletOutputStream;
import org.tuckey.web.filters.validation.ResponseCollector;

public class ServletStreamCollector
extends ServletOutputStream {
    private static final int BUFFER_SIZE = 4096;
    private OutputStream outputStream = new ByteArrayOutputStream(4096);
    private boolean checkForDocTypeDone = false;
    ResponseCollector rc;

    protected ServletStreamCollector(ResponseCollector rc) {
        this.rc = rc;
    }

    public String toString() {
        this.checkForDocType();
        return this.outputStream.toString();
    }

    public void write(int b) throws IOException {
        this.outputStream.write(b);
        this.checkForDocType();
    }

    public void write(byte[] b) throws IOException {
        this.outputStream.write(b);
        this.checkForDocType();
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.outputStream.write(b, off, len);
        this.checkForDocType();
    }

    public byte[] getBytes() {
        return ((ByteArrayOutputStream)this.outputStream).toByteArray();
    }

    private void checkForDocType() {
        if (!this.rc.isCheckForDtdDefnEnabled()) {
            return;
        }
        if (this.outputStream instanceof ServletOutputStream) {
            return;
        }
        if (((ByteArrayOutputStream)this.outputStream).size() < 128) {
            return;
        }
        if (this.checkForDocTypeDone) {
            return;
        }
        this.checkForDocTypeDone = true;
        String contentSoFar = this.outputStream.toString();
        if (!this.rc.isContentXHTML(contentSoFar)) {
            try {
                ServletOutputStream sos = this.rc.getResponseOutputStream();
                sos.write(((ByteArrayOutputStream)this.outputStream).toByteArray());
                this.outputStream = sos;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

