/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.web.usergroup;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.geoserver.security.config.SecurityUserGroupServiceConfig;
import org.geoserver.security.web.SecurityNamedServiceProvider;
import org.geoserver.web.wicket.GeoServerDataProvider;

public class UserGroupServiceProvider
extends SecurityNamedServiceProvider<SecurityUserGroupServiceConfig> {
    public static final GeoServerDataProvider.Property<SecurityUserGroupServiceConfig> PWD_ENCODER = new SecurityNamedServiceProvider.ResourceBeanProperty("passwordEncoderName", "passwordEncoderName");
    public static final GeoServerDataProvider.Property<SecurityUserGroupServiceConfig> PWD_POLICY = new SecurityNamedServiceProvider.ResourceBeanProperty("passwordPolicyName", "passwordPolicyName");

    protected List<SecurityUserGroupServiceConfig> getItems() {
        ArrayList<SecurityUserGroupServiceConfig> result = new ArrayList<SecurityUserGroupServiceConfig>();
        try {
            for (String name : this.getSecurityManager().listUserGroupServices()) {
                result.add(this.getSecurityManager().loadUserGroupServiceConfig(name));
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return result;
    }

    @Override
    protected List<GeoServerDataProvider.Property<SecurityUserGroupServiceConfig>> getProperties() {
        ArrayList<GeoServerDataProvider.Property<SecurityUserGroupServiceConfig>> props = new ArrayList<GeoServerDataProvider.Property<SecurityUserGroupServiceConfig>>(super.getProperties());
        props.add(PWD_ENCODER);
        props.add(PWD_POLICY);
        return props;
    }
}

