/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.web.user;

import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.repeater.DefaultItemReuseStrategy;
import org.apache.wicket.markup.repeater.IItemReuseStrategy;
import org.apache.wicket.model.IModel;
import org.geoserver.security.impl.GeoServerUser;
import org.geoserver.security.web.user.EditUserPage;
import org.geoserver.security.web.user.UserListProvider;
import org.geoserver.web.CatalogIconFactory;
import org.geoserver.web.wicket.GeoServerDataProvider;
import org.geoserver.web.wicket.GeoServerTablePanel;
import org.geoserver.web.wicket.Icon;
import org.geoserver.web.wicket.SimpleAjaxLink;

public class UserTablePanel
extends GeoServerTablePanel<GeoServerUser> {
    String ugServiceName;

    public UserTablePanel(String id, String ugServiceName, GeoServerDataProvider<GeoServerUser> dataProvider) {
        super(id, dataProvider);
        this.ugServiceName = ugServiceName;
    }

    public UserTablePanel(String id, String ugServiceName, GeoServerDataProvider<GeoServerUser> dataProvider, boolean selectable) {
        super(id, dataProvider, selectable);
        this.ugServiceName = ugServiceName;
        this.setItemReuseStrategy((IItemReuseStrategy)new DefaultItemReuseStrategy());
    }

    protected Component getComponentForProperty(String id, IModel itemModel, GeoServerDataProvider.Property<GeoServerUser> property) {
        if (property == UserListProvider.USERNAME) {
            return this.editUserLink(id, itemModel, property);
        }
        if (property == UserListProvider.ENABLED) {
            if (((Boolean)property.getModel(itemModel).getObject()).booleanValue()) {
                return new Icon(id, CatalogIconFactory.ENABLED_ICON);
            }
            return new Label(id, "");
        }
        if (property == UserListProvider.HASATTRIBUTES) {
            if (((Boolean)property.getModel(itemModel).getObject()).booleanValue()) {
                return new Icon(id, CatalogIconFactory.ENABLED_ICON);
            }
            return new Label(id, "");
        }
        throw new RuntimeException("Uknown property " + property);
    }

    protected Component editUserLink(String id, IModel itemModel, GeoServerDataProvider.Property<GeoServerUser> property) {
        return new SimpleAjaxLink(id, itemModel, property.getModel(itemModel)){

            protected void onClick(AjaxRequestTarget target) {
                this.setResponsePage((Page)new EditUserPage(UserTablePanel.this.ugServiceName, (GeoServerUser)this.getDefaultModelObject()).setReturnPage(this.getPage()));
            }
        };
    }
}

