/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.web.user;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.markup.html.form.ChoiceRenderer;
import org.apache.wicket.markup.html.form.SubmitLink;
import org.apache.wicket.model.IModel;
import org.geoserver.security.GeoServerSecurityManager;
import org.geoserver.security.impl.GeoServerUser;
import org.geoserver.security.impl.GeoServerUserGroup;
import org.geoserver.security.web.PaletteFormComponent;
import org.geoserver.security.web.group.NewGroupPage;
import org.geoserver.security.web.user.GroupsModel;
import org.geoserver.web.GeoServerApplication;

public class UserGroupPaletteFormComponent
extends PaletteFormComponent<GeoServerUserGroup> {
    private static final long serialVersionUID = 1L;
    GeoServerUser user;

    public UserGroupPaletteFormComponent(String id, String ugServiceName, GeoServerUser user) {
        this(id, new SelectedGroupsModel(ugServiceName, user), ugServiceName, user);
    }

    public UserGroupPaletteFormComponent(String id, IModel<List<GeoServerUserGroup>> model, final String ugServiceName, GeoServerUser user) {
        super(id, model, new GroupsModel(ugServiceName), new ChoiceRenderer("groupname", "groupname"));
        this.add(new Component[]{new SubmitLink("addGroup"){

            public void onSubmit() {
                this.setResponsePage((Page)new NewGroupPage(ugServiceName).setReturnPage(this.getPage()));
            }
        }});
    }

    public List<GeoServerUserGroup> getSelectedGroups() {
        return new ArrayList<GeoServerUserGroup>(this.palette.getModelCollection());
    }

    public void diff(Collection<GeoServerUserGroup> orig, Collection<GeoServerUserGroup> add, Collection<GeoServerUserGroup> remove) {
        remove.addAll(orig);
        for (GeoServerUserGroup group : this.getSelectedGroups()) {
            if (!orig.contains(group)) {
                add.add(group);
                continue;
            }
            remove.remove(group);
        }
    }

    @Override
    protected String getSelectedHeaderPropertyKey() {
        return "UserGroupPaletteFormComponent.selectedHeader";
    }

    @Override
    protected String getAvaliableHeaderPropertyKey() {
        return "UserGroupPaletteFormComponent.availableHeader";
    }

    static class SelectedGroupsModel
    implements IModel<List<GeoServerUserGroup>> {
        List<GeoServerUserGroup> groups;

        public SelectedGroupsModel(String ugServiceName, GeoServerUser user) {
            try {
                GeoServerSecurityManager secMgr = GeoServerApplication.get().getSecurityManager();
                this.setObject(new ArrayList<GeoServerUserGroup>(secMgr.loadUserGroupService(ugServiceName).getGroupsForUser(user)));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public List<GeoServerUserGroup> getObject() {
            return this.groups;
        }

        public void setObject(List<GeoServerUserGroup> object) {
            this.groups = object;
        }

        public void detach() {
        }
    }
}

