/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.web.user;

import java.io.IOException;
import org.geoserver.security.GeoServerRoleStore;
import org.geoserver.security.GeoServerUserGroupService;
import org.geoserver.security.impl.GeoServerRole;
import org.geoserver.security.impl.GeoServerUser;
import org.geoserver.security.impl.GeoServerUserGroup;
import org.geoserver.security.validation.PasswordPolicyException;
import org.geoserver.security.validation.RoleStoreValidationWrapper;
import org.geoserver.security.validation.UserGroupStoreValidationWrapper;
import org.geoserver.security.web.user.AbstractUserPage;

public class NewUserPage
extends AbstractUserPage {
    public NewUserPage(String userGroupServiceName) {
        super(userGroupServiceName, new GeoServerUser(""));
        if (!this.hasUserGroupStore(userGroupServiceName)) {
            throw new IllegalStateException("New user not possible for read only service");
        }
    }

    @Override
    protected void onFormSubmit(GeoServerUser user) throws IOException, PasswordPolicyException {
        UserGroupStoreValidationWrapper ugStore = new UserGroupStoreValidationWrapper(this.getUserGroupStore(this.ugServiceName));
        try {
            ugStore.addUser(user);
            for (GeoServerUserGroup group : this.userGroupPalette.getSelectedGroups()) {
                ugStore.associateUserToGroup(user, group);
            }
            ugStore.store();
        }
        catch (IOException ex) {
            try {
                ugStore.load();
            }
            catch (IOException ex2) {
                // empty catch block
            }
            throw ex;
        }
        catch (PasswordPolicyException ex) {
            try {
                ugStore.load();
            }
            catch (IOException ex2) {
                // empty catch block
            }
            throw ex;
        }
        GeoServerRoleStore gaStore = null;
        try {
            if (this.hasRoleStore(this.getSecurityManager().getActiveRoleService().getName())) {
                gaStore = this.getRoleStore(this.getSecurityManager().getActiveRoleService().getName());
                gaStore = new RoleStoreValidationWrapper(gaStore, new GeoServerUserGroupService[0]);
                for (GeoServerRole role : this.rolePalette.getSelectedRoles()) {
                    gaStore.associateRoleToUser(role, user.getUsername());
                }
                gaStore.store();
            }
        }
        catch (IOException ex) {
            try {
                gaStore.load();
            }
            catch (IOException ex2) {
                // empty catch block
            }
            throw ex;
        }
    }
}

