/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.web.service;

import java.io.IOException;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.StringResourceModel;
import org.geoserver.security.impl.ServiceAccessRule;
import org.geoserver.security.impl.ServiceAccessRuleDAO;
import org.geoserver.security.web.service.ConfirmRemovalServicePanel;
import org.geoserver.web.wicket.GeoServerDialog;
import org.geoserver.web.wicket.GeoServerTablePanel;
import org.geoserver.web.wicket.ParamResourceModel;

public class SelectionServiceRemovalLink
extends AjaxLink {
    GeoServerTablePanel<ServiceAccessRule> services;
    GeoServerDialog.DialogDelegate delegate;
    GeoServerDialog dialog;
    ConfirmRemovalServicePanel removePanel;

    public SelectionServiceRemovalLink(String id, GeoServerTablePanel<ServiceAccessRule> services, GeoServerDialog dialog) {
        super(id);
        this.services = services;
        this.dialog = dialog;
    }

    public void onClick(AjaxRequestTarget target) {
        final List selection = this.services.getSelection();
        if (selection.size() == 0) {
            return;
        }
        this.dialog.setTitle((IModel)new ParamResourceModel("confirmRemoval", (Component)this, new Object[0]));
        this.delegate = new GeoServerDialog.DialogDelegate(){

            protected Component getContents(String id) {
                SelectionServiceRemovalLink.this.removePanel = new ConfirmRemovalServicePanel(id, selection){

                    @Override
                    protected IModel<String> canRemove(ServiceAccessRule service) {
                        return SelectionServiceRemovalLink.this.canRemove(service);
                    }
                };
                return SelectionServiceRemovalLink.this.removePanel;
            }

            protected boolean onSubmit(AjaxRequestTarget target, Component contents) {
                ServiceAccessRuleDAO dao = ServiceAccessRuleDAO.get();
                for (ServiceAccessRule service : SelectionServiceRemovalLink.this.removePanel.getRoots()) {
                    dao.removeRule((Comparable)service);
                }
                try {
                    dao.storeRules();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                SelectionServiceRemovalLink.this.services.clearSelection();
                return true;
            }

            public void onClose(AjaxRequestTarget target) {
                if (SelectionServiceRemovalLink.this.services.getSelection().size() == 0) {
                    SelectionServiceRemovalLink.this.setEnabled(false);
                    target.addComponent((Component)SelectionServiceRemovalLink.this);
                    target.addComponent(SelectionServiceRemovalLink.this.services);
                }
            }
        };
        this.dialog.showOkCancel(target, this.delegate);
    }

    protected StringResourceModel canRemove(ServiceAccessRule service) {
        return null;
    }
}

