/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.web.service;

import java.io.Serializable;
import java.util.logging.Level;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.validation.AbstractFormValidator;
import org.apache.wicket.markup.html.form.validation.IFormValidator;
import org.geoserver.security.impl.ServiceAccessRule;
import org.geoserver.security.impl.ServiceAccessRuleDAO;
import org.geoserver.security.web.service.AbstractServiceAccessRulePage;
import org.geoserver.security.web.service.ServiceAccessRulePage;
import org.geoserver.web.wicket.ParamResourceModel;

public class NewServiceAccessRulePage
extends AbstractServiceAccessRulePage {
    public NewServiceAccessRulePage() {
        super(new ServiceAccessRule());
        ((Form)this.get("form")).add((IFormValidator)new DuplicateRuleValidator());
    }

    @Override
    protected void onFormSubmit(ServiceAccessRule rule) {
        try {
            ServiceAccessRuleDAO dao = ServiceAccessRuleDAO.get();
            dao.addRule((Comparable)rule);
            dao.storeRules();
            this.doReturn(ServiceAccessRulePage.class);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Error occurred while saving service rule", e);
            this.error((Serializable)new ParamResourceModel("saveError", (Component)this.getPage(), new Object[]{e.getMessage()}));
        }
    }

    class DuplicateRuleValidator
    extends AbstractFormValidator {
        DuplicateRuleValidator() {
        }

        public void validate(Form<?> form) {
            if (form.findSubmittingButton() != form.get("save")) {
                return;
            }
            NewServiceAccessRulePage.this.updateModels();
            ServiceAccessRule rule = (ServiceAccessRule)form.getModelObject();
            if (ServiceAccessRuleDAO.get().getRules().contains(rule)) {
                form.error((Serializable)((Object)new ParamResourceModel("duplicateRule", (Component)NewServiceAccessRulePage.this.getPage(), new Object[]{rule.getKey()}).getString()));
            }
        }

        public FormComponent<?>[] getDependentFormComponents() {
            return new FormComponent[]{NewServiceAccessRulePage.this.serviceChoice, NewServiceAccessRulePage.this.methodChoice, NewServiceAccessRulePage.this.rolesFormComponent};
        }
    }
}

