/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.web.role;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.ChoiceRenderer;
import org.apache.wicket.markup.html.form.SubmitLink;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.StringResourceModel;
import org.geoserver.security.GeoServerRoleService;
import org.geoserver.security.GeoServerSecurityManager;
import org.geoserver.security.impl.GeoServerRole;
import org.geoserver.security.web.PaletteFormComponent;
import org.geoserver.security.web.role.NewRolePage;
import org.geoserver.security.web.role.RolesModel;
import org.geoserver.security.web.role.RuleRolesModel;
import org.geoserver.web.GeoServerApplication;

public class RolePaletteFormComponent
extends PaletteFormComponent<GeoServerRole> {
    public RolePaletteFormComponent(String id, IModel<List<GeoServerRole>> model) {
        this(id, model, (IModel<Collection<GeoServerRole>>)new RolesModel());
    }

    public RolePaletteFormComponent(String id, IModel<List<GeoServerRole>> model, IModel<Collection<GeoServerRole>> choicesModel) {
        super(id, model, choicesModel, new ChoiceRenderer("authority", "authority"));
        GeoServerRoleService roleService = this.getSecurityManager().getActiveRoleService();
        final String roleServiceName = roleService.getName();
        if (choicesModel instanceof RuleRolesModel) {
            this.add(new Component[]{new Label("roles", (IModel)new StringResourceModel("roles", (Component)this, null))});
        } else {
            this.add(new Component[]{new Label("roles", (IModel)new StringResourceModel("rolesFromActiveService", (Component)this, null, new Object[]{roleServiceName}))});
        }
        this.add(new Component[]{new SubmitLink("addRole"){

            public void onSubmit() {
                this.setResponsePage((Page)new NewRolePage(roleServiceName).setReturnPage(this.getPage()));
            }
        }.setVisible(roleService.canCreateStore())});
    }

    public GeoServerSecurityManager getSecurityManager() {
        return GeoServerApplication.get().getSecurityManager();
    }

    public void diff(Collection<GeoServerRole> orig, Collection<GeoServerRole> add, Collection<GeoServerRole> remove) {
        remove.addAll(orig);
        for (GeoServerRole role : this.getSelectedRoles()) {
            if (!orig.contains(role)) {
                add.add(role);
                continue;
            }
            remove.remove(role);
        }
    }

    public List<GeoServerRole> getSelectedRoles() {
        return new ArrayList<GeoServerRole>(this.palette.getModelCollection());
    }

    @Override
    protected String getSelectedHeaderPropertyKey() {
        return "RolePaletteFormComponent.selectedHeader";
    }

    @Override
    protected String getAvaliableHeaderPropertyKey() {
        return "RolePaletteFormComponent.availableHeader";
    }
}

