/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.web.role;

import java.io.IOException;
import java.util.Map;
import org.geoserver.security.GeoServerUserGroupService;
import org.geoserver.security.impl.GeoServerRole;
import org.geoserver.security.validation.RoleStoreValidationWrapper;
import org.geoserver.security.web.role.AbstractRolePage;

public class NewRolePage
extends AbstractRolePage {
    public NewRolePage(String roleServiceName) {
        super(roleServiceName, null);
        if (!this.hasRoleStore(roleServiceName)) {
            throw new RuntimeException("Workflow error, new role not possible for read only service");
        }
    }

    @Override
    protected void onFormSubmit(GeoServerRole role) throws IOException {
        RoleStoreValidationWrapper store = null;
        try {
            store = new RoleStoreValidationWrapper(this.getRoleStore(this.roleServiceName), new GeoServerUserGroupService[0]);
            GeoServerRole newRole = store.createRoleObject(this.get("form:name").getDefaultModelObjectAsString());
            newRole.setUserName(role.getUserName());
            newRole.getProperties().putAll((Map<?, ?>)role.getProperties());
            role = newRole;
            store.addRole(role);
            String parentRoleName = this.get("form:parent").getDefaultModelObjectAsString();
            if (parentRoleName != null) {
                GeoServerRole parentRole = store.getRoleByName(parentRoleName);
                store.setParentRole(role, parentRole);
            }
            store.store();
        }
        catch (IOException ex) {
            try {
                store.load();
            }
            catch (IOException ex2) {
                // empty catch block
            }
            throw ex;
        }
    }
}

