/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.web.passwd;

import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.SubmitLink;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.geoserver.security.password.MasterPasswordConfig;
import org.geoserver.security.web.AbstractSecurityPage;
import org.geoserver.security.web.passwd.MasterPasswordChangePage;
import org.geoserver.security.web.passwd.MasterPasswordConfigModel;
import org.geoserver.security.web.passwd.MasterPasswordInfoPage;
import org.geoserver.security.web.passwd.MasterPasswordProviderChoice;
import org.geoserver.security.web.passwd.MasterPasswordProvidersPanel;
import org.geoserver.security.web.passwd.PasswordPoliciesPanel;
import org.geoserver.web.wicket.HelpLink;

public class PasswordPage
extends AbstractSecurityPage {
    public PasswordPage() {
        Form form = new Form("form", (IModel)new CompoundPropertyModel((Object)new MasterPasswordConfigModel()));
        this.add(new Component[]{form});
        form.add(new Component[]{new MasterPasswordProviderChoice("providerName")});
        form.add(new Component[]{new Link("changePassword"){

            public void onClick() {
                MasterPasswordChangePage page = new MasterPasswordChangePage();
                page.setReturnPage(this.getPage());
                this.setResponsePage((Page)page);
            }
        }});
        form.add(new Component[]{new Link("masterPasswordInfo"){

            public void onClick() {
                MasterPasswordInfoPage page = new MasterPasswordInfoPage();
                page.setReturnPage(this.getPage());
                this.setResponsePage((Page)page);
            }
        }});
        form.add(new Component[]{new MasterPasswordProvidersPanel("masterPasswordProviders")});
        form.add(new Component[]{new HelpLink("masterPasswordProvidersHelp").setDialog(this.dialog)});
        form.add(new Component[]{new PasswordPoliciesPanel("passwordPolicies")});
        form.add(new Component[]{new HelpLink("passwordPoliciesHelp").setDialog(this.dialog)});
        form.add(new Component[]{new SubmitLink("save", form){

            public void onSubmit() {
                MasterPasswordConfig config = (MasterPasswordConfig)this.getForm().getModelObject();
                try {
                    PasswordPage.this.getSecurityManager().saveMasterPasswordConfig(config);
                    PasswordPage.this.doReturn();
                }
                catch (Exception e) {
                    this.error(e);
                }
            }
        }});
        form.add(new Component[]{new AjaxLink("cancel"){

            public void onClick(AjaxRequestTarget target) {
                PasswordPage.this.doReturn();
            }
        }});
    }
}

