/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.web.group;

import java.io.IOException;
import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.markup.repeater.DefaultItemReuseStrategy;
import org.apache.wicket.markup.repeater.IItemReuseStrategy;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.StringResourceModel;
import org.geoserver.security.GeoServerUserGroupService;
import org.geoserver.security.impl.GeoServerUserGroup;
import org.geoserver.security.web.group.EditGroupPage;
import org.geoserver.security.web.group.GroupListProvider;
import org.geoserver.security.web.group.NewGroupPage;
import org.geoserver.security.web.group.SelectionGroupRemovalLink;
import org.geoserver.web.CatalogIconFactory;
import org.geoserver.web.GeoServerApplication;
import org.geoserver.web.wicket.GeoServerDataProvider;
import org.geoserver.web.wicket.GeoServerDialog;
import org.geoserver.web.wicket.GeoServerTablePanel;
import org.geoserver.web.wicket.Icon;
import org.geoserver.web.wicket.SimpleAjaxLink;

public class GroupPanel
extends Panel {
    protected GeoServerTablePanel<GeoServerUserGroup> groups;
    protected GeoServerDialog dialog;
    protected SelectionGroupRemovalLink removal;
    protected SelectionGroupRemovalLink removalWithRoles;
    protected Link<?> add;
    protected String serviceName;

    protected GeoServerUserGroupService getService() {
        try {
            return GeoServerApplication.get().getSecurityManager().loadUserGroupService(this.serviceName);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public GroupPanel(String id, String serviceName) {
        super(id);
        this.serviceName = serviceName;
        GroupListProvider provider = new GroupListProvider(serviceName);
        Component[] componentArray = new Component[1];
        this.groups = new GeoServerTablePanel<GeoServerUserGroup>("table", (GeoServerDataProvider)provider, true){

            protected Component getComponentForProperty(String id, IModel itemModel, GeoServerDataProvider.Property<GeoServerUserGroup> property) {
                if (property == GroupListProvider.GROUPNAME) {
                    return GroupPanel.this.editGroupLink(id, itemModel, property);
                }
                if (property == GroupListProvider.ENABLED) {
                    if (((Boolean)property.getModel(itemModel).getObject()).booleanValue()) {
                        return new Icon(id, CatalogIconFactory.ENABLED_ICON);
                    }
                    return new Label(id, "");
                }
                throw new RuntimeException("Uknown property " + property);
            }

            protected void onSelectionUpdate(AjaxRequestTarget target) {
                GroupPanel.this.removal.setEnabled(GroupPanel.this.groups.getSelection().size() > 0);
                target.addComponent((Component)GroupPanel.this.removal);
                GroupPanel.this.removalWithRoles.setEnabled(GroupPanel.this.groups.getSelection().size() > 0);
                target.addComponent((Component)GroupPanel.this.removalWithRoles);
            }
        };
        componentArray[0] = this.groups;
        this.add(componentArray);
        this.groups.setItemReuseStrategy((IItemReuseStrategy)new DefaultItemReuseStrategy());
        this.groups.setOutputMarkupId(true);
        Component[] componentArray2 = new Component[1];
        this.dialog = new GeoServerDialog("dialog");
        componentArray2[0] = this.dialog;
        this.add(componentArray2);
        this.headerComponents();
    }

    public GroupPanel setHeaderVisible(boolean visible) {
        this.get("header").setVisible(visible);
        return this;
    }

    public GroupPanel setPagersVisible(boolean top, boolean bottom) {
        this.groups.getTopPager().setVisible(top);
        this.groups.getBottomPager().setVisible(bottom);
        return this;
    }

    protected void headerComponents() {
        boolean canCreateStore = this.getService().canCreateStore();
        WebMarkupContainer h = new WebMarkupContainer("header");
        this.add(new Component[]{h});
        if (!canCreateStore) {
            h.add(new Component[]{new Label("message", (IModel)new StringResourceModel("noCreateStore", (Component)this, null)).add(new IBehavior[]{new AttributeAppender("class", (IModel)new Model((Serializable)((Object)"info-link")), " ")})});
        } else {
            h.add(new Component[]{new Label("message", (IModel)new Model())});
        }
        Component[] componentArray = new Component[1];
        this.add = new Link("addNew"){

            public void onClick() {
                this.setResponsePage((Page)new NewGroupPage(GroupPanel.this.serviceName).setReturnPage(this.getPage()));
            }
        };
        componentArray[0] = this.add;
        h.add(componentArray);
        this.add.setVisible(canCreateStore);
        Component[] componentArray2 = new Component[1];
        this.removal = new SelectionGroupRemovalLink(this.serviceName, "removeSelected", this.groups, this.dialog, false);
        componentArray2[0] = this.removal;
        h.add(componentArray2);
        this.removal.setOutputMarkupId(true);
        this.removal.setEnabled(false);
        this.removal.setVisibilityAllowed(canCreateStore);
        Component[] componentArray3 = new Component[1];
        this.removalWithRoles = new SelectionGroupRemovalLink(this.serviceName, "removeSelectedWithRoles", this.groups, this.dialog, true);
        componentArray3[0] = this.removalWithRoles;
        h.add(componentArray3);
        this.removalWithRoles.setOutputMarkupId(true);
        this.removalWithRoles.setEnabled(false);
        this.removalWithRoles.setVisibilityAllowed(canCreateStore && GeoServerApplication.get().getSecurityManager().getActiveRoleService().canCreateStore());
        h.setEnabled(this.getService().getSecurityManager().checkAuthenticationForAdminRole());
    }

    Component editGroupLink(String id, IModel itemModel, GeoServerDataProvider.Property<GeoServerUserGroup> property) {
        return new SimpleAjaxLink(id, itemModel, property.getModel(itemModel)){

            protected void onClick(AjaxRequestTarget target) {
                this.setResponsePage((Page)new EditGroupPage(GroupPanel.this.serviceName, (GeoServerUserGroup)this.getDefaultModelObject()).setReturnPage(this.getPage()));
            }
        };
    }

    protected void onBeforeRender() {
        this.groups.clearSelection();
        this.removal.setEnabled(false);
        this.removalWithRoles.setEnabled(false);
        super.onBeforeRender();
    }
}

