/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.web.auth;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.geoserver.security.HTTPMethod;
import org.geoserver.security.RequestFilterChain;
import org.springframework.util.StringUtils;

public class RequestFilterChainWrapper
implements Serializable {
    private static final long serialVersionUID = 1L;
    RequestFilterChain chain;

    public RequestFilterChainWrapper(RequestFilterChain chain) {
        this.chain = chain;
    }

    public boolean equals(Object obj) {
        return this.chain.equals(obj);
    }

    public void setName(String name) {
        this.chain.setName(name);
    }

    public String getName() {
        return this.chain.getName();
    }

    public List<String> getPatterns() {
        return this.chain.getPatterns();
    }

    public void setPatterns(List<String> patterns) {
        this.chain.setPatterns(patterns);
    }

    public List<String> getFilterNames() {
        return this.chain.getFilterNames();
    }

    public void setFilterNames(String ... filterNames) {
        this.chain.setFilterNames(filterNames);
    }

    public void setFilterNames(List<String> filterNames) {
        this.chain.setFilterNames(filterNames);
    }

    public int hashCode() {
        return this.chain.hashCode();
    }

    public boolean isDisabled() {
        return this.chain.isDisabled();
    }

    public void setDisabled(boolean disabled) {
        this.chain.setDisabled(disabled);
    }

    public boolean isAllowSessionCreation() {
        return this.chain.isAllowSessionCreation();
    }

    public void setAllowSessionCreation(boolean allowSessionCreation) {
        this.chain.setAllowSessionCreation(allowSessionCreation);
    }

    public boolean isRequireSSL() {
        return this.chain.isRequireSSL();
    }

    public void setRequireSSL(boolean requireSSL) {
        this.chain.setRequireSSL(requireSSL);
    }

    public boolean isMatchHTTPMethod() {
        return this.chain.isMatchHTTPMethod();
    }

    public void setMatchHTTPMethod(boolean matchHTTPMethod) {
        this.chain.setMatchHTTPMethod(matchHTTPMethod);
    }

    public Set<HTTPMethod> getHttpMethods() {
        return this.chain.getHttpMethods();
    }

    public void setHttpMethods(Set<HTTPMethod> httpMethods) {
        this.chain.setHttpMethods(httpMethods);
    }

    public String getPatternString() {
        if (this.chain.getPatterns() != null) {
            return StringUtils.collectionToCommaDelimitedString((Collection)this.chain.getPatterns());
        }
        return "";
    }

    public void setPatternString(String patternString) {
        if (StringUtils.hasLength((String)patternString)) {
            this.chain.setPatterns(Arrays.asList(StringUtils.commaDelimitedListToStringArray((String)patternString)));
        } else {
            this.chain.getPatterns().clear();
        }
    }

    public boolean isGET() {
        return this.chain.getHttpMethods().contains(HTTPMethod.GET);
    }

    public void setGET(boolean gET) {
        if (gET) {
            this.chain.getHttpMethods().add(HTTPMethod.GET);
        } else {
            this.chain.getHttpMethods().remove(HTTPMethod.GET);
        }
    }

    public boolean isPUT() {
        return this.chain.getHttpMethods().contains(HTTPMethod.PUT);
    }

    public void setPUT(boolean pUT) {
        if (pUT) {
            this.chain.getHttpMethods().add(HTTPMethod.PUT);
        } else {
            this.chain.getHttpMethods().remove(HTTPMethod.PUT);
        }
    }

    public boolean isDELETE() {
        return this.chain.getHttpMethods().contains(HTTPMethod.DELETE);
    }

    public void setDELETE(boolean dELETE) {
        if (dELETE) {
            this.chain.getHttpMethods().add(HTTPMethod.DELETE);
        } else {
            this.chain.getHttpMethods().remove(HTTPMethod.DELETE);
        }
    }

    public boolean isPOST() {
        return this.chain.getHttpMethods().contains(HTTPMethod.POST);
    }

    public void setPOST(boolean pOST) {
        if (pOST) {
            this.chain.getHttpMethods().add(HTTPMethod.POST);
        } else {
            this.chain.getHttpMethods().remove(HTTPMethod.POST);
        }
    }

    public boolean isOPTIONS() {
        return this.chain.getHttpMethods().contains(HTTPMethod.OPTIONS);
    }

    public void setOPTIONS(boolean oPTIONS) {
        if (oPTIONS) {
            this.chain.getHttpMethods().add(HTTPMethod.OPTIONS);
        } else {
            this.chain.getHttpMethods().remove(HTTPMethod.OPTIONS);
        }
    }

    public boolean isTRACE() {
        return this.chain.getHttpMethods().contains(HTTPMethod.TRACE);
    }

    public void setTRACE(boolean tRACE) {
        if (tRACE) {
            this.chain.getHttpMethods().add(HTTPMethod.TRACE);
        } else {
            this.chain.getHttpMethods().remove(HTTPMethod.TRACE);
        }
    }

    public boolean isHEAD() {
        return this.chain.getHttpMethods().contains(HTTPMethod.HEAD);
    }

    public void setHEAD(boolean hEAD) {
        if (hEAD) {
            this.chain.getHttpMethods().add(HTTPMethod.HEAD);
        } else {
            this.chain.getHttpMethods().remove(HTTPMethod.HEAD);
        }
    }

    public RequestFilterChain getChain() {
        return this.chain;
    }

    public String getHttpMethodString() {
        if (this.chain.isMatchHTTPMethod()) {
            return StringUtils.collectionToCommaDelimitedString((Collection)this.chain.getHttpMethods());
        }
        return "*";
    }

    public String getRoleFilterName() {
        return this.chain.getRoleFilterName();
    }

    public void setRoleFilterName(String roleFilterName) {
        this.chain.setRoleFilterName(roleFilterName);
    }
}

