/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.web;

import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.FormComponentPanel;
import org.apache.wicket.markup.html.form.SubmitLink;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.StringResourceModel;
import org.geoserver.security.GeoServerSecurityManager;
import org.geoserver.security.config.SecurityManagerConfig;
import org.geoserver.security.web.AbstractSecurityPage;
import org.geoserver.security.web.SecurityManagerConfigModel;
import org.geoserver.security.web.passwd.PasswordEncoderChoice;
import org.geoserver.security.web.role.RoleServiceChoice;
import org.geoserver.web.wicket.HelpLink;

public class SecuritySettingsPage
extends AbstractSecurityPage {
    public SecuritySettingsPage() {
        this.initComponents();
    }

    void initComponents() {
        Form form = new Form("form", (IModel)new CompoundPropertyModel((Object)new SecurityManagerConfigModel()));
        this.add(new Component[]{form});
        form.add(new Component[]{new RoleServiceChoice("roleServiceName")});
        form.add(new Component[]{new EncryptionPanel("encryption")});
        form.add(new Component[]{new HelpLink("encryptionHelp").setDialog(this.dialog)});
        form.add(new Component[]{new SubmitLink("save", form){

            public void onSubmit() {
                SecurityManagerConfig config = (SecurityManagerConfig)this.getForm().getModelObject();
                try {
                    SecuritySettingsPage.this.getSecurityManager().saveSecurityConfig(config);
                    SecuritySettingsPage.this.doReturn();
                }
                catch (Exception e) {
                    this.error(e);
                }
            }
        }});
        form.add(new Component[]{new AjaxLink("cancel"){

            public void onClick(AjaxRequestTarget target) {
                SecuritySettingsPage.this.doReturn();
            }
        }});
    }

    class EncryptionPanel
    extends FormComponentPanel {
        public EncryptionPanel(String id) {
            super(id, (IModel)new Model());
            GeoServerSecurityManager secMgr = SecuritySettingsPage.this.getSecurityManager();
            if (secMgr.isStrongEncryptionAvailable()) {
                this.add(new Component[]{new Label("strongEncryptionMsg", (IModel)new StringResourceModel("strongEncryption", (Component)this, null)).add(new IBehavior[]{new AttributeAppender("class", (IModel)new Model((Serializable)((Object)"info-link")), " ")})});
            } else {
                this.add(new Component[]{new Label("strongEncryptionMsg", (IModel)new StringResourceModel("noStrongEncryption", (Component)this, null)).add(new IBehavior[]{new AttributeAppender("class", (IModel)new Model((Serializable)((Object)"warning-link")), " ")})});
            }
            this.add(new Component[]{new CheckBox("encryptingUrlParams")});
            this.add(new Component[]{new PasswordEncoderChoice("configPasswordEncrypterName", SecuritySettingsPage.this.getSecurityManager().loadPasswordEncoders(null, Boolean.valueOf(true), null))});
        }
    }
}

