/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest.util;

import com.noelios.restlet.ext.servlet.ServletCall;
import com.noelios.restlet.http.HttpRequest;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CoverageStoreInfo;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.MetadataMap;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.config.SettingsInfo;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.platform.resource.Paths;
import org.geoserver.platform.resource.Resource;
import org.geoserver.rest.RestletException;
import org.geoserver.rest.util.IOUtils;
import org.geoserver.rest.util.RESTUploadPathMapper;
import org.geotools.util.logging.Logging;
import org.restlet.data.MediaType;
import org.restlet.data.Reference;
import org.restlet.data.Request;
import org.restlet.data.Status;
import org.vfny.geoserver.global.ConfigurationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RESTUtils {
    static Logger LOGGER = Logging.getLogger((String)"org.geoserver.rest.util");
    public static final String ROOT_KEY = "root";
    public static final String QUIET_ON_NOT_FOUND_KEY = "quietOnNotFound";
    static Set<String> ZIP_MIME_TYPES = new HashSet<String>();

    public static HttpServletRequest getServletRequest(Request request) {
        HttpRequest httpRequest;
        if (request instanceof HttpRequest && (httpRequest = (HttpRequest)request).getHttpCall() instanceof ServletCall) {
            ServletCall call = (ServletCall)httpRequest.getHttpCall();
            return call.getRequest();
        }
        return null;
    }

    public static String getBaseURL(Request request) {
        Reference ref = request.getResourceRef();
        HttpServletRequest servletRequest = RESTUtils.getServletRequest(request);
        if (servletRequest != null) {
            String baseURL = ref.getIdentifier();
            return baseURL.substring(0, baseURL.length() - servletRequest.getPathInfo().length());
        }
        return ref.getParentRef().getIdentifier();
    }

    public static File handleBinUpload(String datasetName, String extension, Request request) throws IOException, ConfigurationException {
        GeoServerResourceLoader loader = (GeoServerResourceLoader)GeoServerExtensions.bean(GeoServerResourceLoader.class);
        Resource data = loader.get("data");
        File dir = data.dir();
        return RESTUtils.handleBinUpload(datasetName + "." + extension, null, dir, request);
    }

    public static File handleBinUpload(String fileName, String workSpace, File directory, Request request) throws IOException {
        return RESTUtils.handleBinUpload(fileName, directory, true, request, workSpace);
    }

    public static File handleBinUpload(String fileName, File directory, boolean deleteDirectoryContent, Request request) throws IOException {
        return RESTUtils.handleBinUpload(fileName, directory, deleteDirectoryContent, request, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File handleBinUpload(String fileName, File directory, boolean deleteDirectoryContent, Request request, String workSpace) throws IOException {
        File newFile;
        StringBuilder itemPath = new StringBuilder(fileName);
        MediaType mediaType = request.getEntity().getMediaType();
        if (mediaType == null || !RESTUtils.isZipMediaType(mediaType)) {
            String baseName = FilenameUtils.getBaseName((String)fileName);
            String itemName = FilenameUtils.getName((String)fileName);
            HashMap<String, String> storeParams = new HashMap<String, String>();
            RESTUtils.remapping(workSpace, baseName, itemPath, itemName, storeParams);
        }
        if ((newFile = new File(directory, itemPath.toString())).exists()) {
            if (deleteDirectoryContent) {
                FileUtils.cleanDirectory((File)directory);
            } else {
                newFile.delete();
            }
        } else {
            newFile.getParentFile().mkdirs();
        }
        ReadableByteChannel source = request.getEntity().getChannel();
        RandomAccessFile raf = null;
        FileChannel outputChannel = null;
        try {
            raf = new RandomAccessFile(newFile, "rw");
            outputChannel = raf.getChannel();
            IOUtils.copyChannel(0x100000, source, outputChannel);
        }
        finally {
            try {
                if (raf != null) {
                    raf.close();
                }
            }
            finally {
                IOUtils.closeQuietly(source);
                IOUtils.closeQuietly(outputChannel);
            }
        }
        return newFile;
    }

    public static File handleURLUpload(String datasetName, String workSpace, String extension, Request request) throws IOException, ConfigurationException {
        GeoServerResourceLoader loader = (GeoServerResourceLoader)GeoServerExtensions.bean(GeoServerResourceLoader.class);
        Resource data = loader.get("data");
        File dir = data.dir();
        return RESTUtils.handleURLUpload(datasetName + "." + extension, workSpace, dir, request);
    }

    public static File handleURLUpload(String fileName, String workSpace, File directory, Request request) throws IOException {
        StringBuilder itemPath = new StringBuilder(fileName);
        MediaType mediaType = request.getEntity().getMediaType();
        if (mediaType == null || !RESTUtils.isZipMediaType(mediaType)) {
            String baseName = FilenameUtils.getBaseName((String)fileName);
            HashMap<String, String> storeParams = new HashMap<String, String>();
            String itemName = FilenameUtils.getName((String)fileName);
            RESTUtils.remapping(workSpace, baseName, itemPath, itemName, storeParams);
        }
        File newFile = new File(directory, itemPath.toString());
        InputStream inStream = request.getEntity().getStream();
        String stringURL = IOUtils.getStringFromStream(inStream);
        URL fileURL = new URL(stringURL);
        File inputFile = IOUtils.URLToFile(fileURL);
        if (inputFile != null && inputFile.exists() && inputFile.canRead()) {
            IOUtils.copyFile(inputFile, newFile);
        } else {
            InputStream inputStream = fileURL.openStream();
            FileOutputStream outStream = new FileOutputStream(newFile);
            IOUtils.copyStream(inputStream, outStream, true, true);
        }
        return newFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File handleEXTERNALUpload(Request request) throws IOException {
        URL fileURL;
        InputStream inStream = null;
        try {
            inStream = request.getEntity().getStream();
            String stringURL = IOUtils.getStringFromStream(inStream);
            fileURL = new URL(stringURL);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inStream);
        }
        File inputFile = IOUtils.URLToFile(fileURL);
        if (inputFile == null || !inputFile.exists()) {
            throw new RestletException("Failed to locate the input file " + fileURL, Status.CLIENT_ERROR_BAD_REQUEST);
        }
        if (!inputFile.canRead()) {
            throw new RestletException("Input file is not readable, check filesystem permissions: " + fileURL, Status.CLIENT_ERROR_BAD_REQUEST);
        }
        return inputFile;
    }

    public static boolean isZipMediaType(MediaType mediaType) {
        return ZIP_MIME_TYPES.contains(mediaType.toString());
    }

    public static void unzipFile(File zipFile, File outputDirectory) throws IOException {
        RESTUtils.unzipFile(zipFile, outputDirectory, null, null, null, null, false);
    }

    public static void unzipFile(File zipFile, File outputDirectory, String workspace, String store, Request request, List<File> files, boolean external) throws IOException {
        if (outputDirectory == null) {
            outputDirectory = zipFile.getParentFile();
        }
        if (outputDirectory != null && !outputDirectory.exists()) {
            outputDirectory.mkdir();
        }
        ZipFile archive = new ZipFile(zipFile);
        IOUtils.inflate(archive, outputDirectory, null, workspace, store, request, files, external);
        IOUtils.deleteFile(zipFile);
    }

    public static File unpackZippedDataset(String storeName, File zipFile) throws IOException, ConfigurationException {
        GeoServerResourceLoader loader = (GeoServerResourceLoader)GeoServerExtensions.bean(GeoServerResourceLoader.class);
        String outputPath = Paths.path((String[])new String[]{"data", Paths.convert((String)storeName)});
        Resource directory = loader.get(outputPath);
        File outputDirectory = directory.dir();
        RESTUtils.unzipFile(zipFile, outputDirectory, null, null, null, null, false);
        return outputDirectory;
    }

    public static String getAttribute(Request request, String name) {
        Object o = request.getAttributes().get(name);
        return RESTUtils.decode(o);
    }

    public static String getQueryStringValue(Request request, String key) {
        String value = request.getResourceRef().getQueryAsForm().getFirstValue(key);
        return RESTUtils.decode(value);
    }

    static String decode(Object value) {
        if (value == null) {
            return null;
        }
        try {
            return URLDecoder.decode(value.toString(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public static String getItem(String workspaceName, String storeName, Catalog catalog, String key) {
        String item = null;
        item = RESTUtils.extractMapItem(RESTUtils.loadMapfromStore(storeName, catalog), key);
        if (item == null) {
            item = RESTUtils.extractMapItem(RESTUtils.loadMapfromWorkSpace(workspaceName, catalog), key);
        }
        if (item == null) {
            item = RESTUtils.extractMapItem(RESTUtils.loadMapFromGlobal(), key);
        }
        return item;
    }

    public static MetadataMap loadMapfromStore(String storeName, Catalog catalog) {
        StoreInfo storeInfo = catalog.getStoreByName(storeName, CoverageStoreInfo.class);
        if (storeInfo == null) {
            storeInfo = catalog.getStoreByName(storeName, DataStoreInfo.class);
        }
        if (storeInfo != null) {
            MetadataMap map = storeInfo.getMetadata();
            return map;
        }
        return null;
    }

    public static MetadataMap loadMapfromWorkSpace(String workspaceName, Catalog catalog) {
        WorkspaceInfo wsInfo = catalog.getWorkspaceByName(workspaceName);
        if (wsInfo != null) {
            GeoServer gs = (GeoServer)GeoServerExtensions.bean(GeoServer.class);
            SettingsInfo info = gs.getSettings(wsInfo);
            MetadataMap map = info != null ? info.getMetadata() : null;
            return map;
        }
        return null;
    }

    public static MetadataMap loadMapFromGlobal() {
        GeoServerInfo gsInfo = ((GeoServer)GeoServerExtensions.bean(GeoServer.class)).getGlobal();
        if (gsInfo != null) {
            SettingsInfo info = gsInfo.getSettings();
            MetadataMap map = info != null ? info.getMetadata() : null;
            return map;
        }
        return null;
    }

    public static String extractMapItem(MetadataMap map, String key) {
        String item;
        if (map != null && !map.isEmpty() && (item = (String)map.get(key, String.class)) != null && !item.isEmpty()) {
            return item;
        }
        return null;
    }

    public static String getRootDirectory(String workspaceName, String storeName, Catalog catalog) {
        String rootDir = RESTUtils.getItem(workspaceName, storeName, catalog, ROOT_KEY);
        if (rootDir != null) {
            File root = new File(rootDir);
            if (!root.exists()) {
                if (!root.mkdirs()) {
                    root.delete();
                    return null;
                }
            } else if (!root.isDirectory()) {
                LOGGER.info(rootDir + " ROOT path is not a directory");
                return null;
            }
        }
        return rootDir;
    }

    public static void remapping(String workspace, String store, StringBuilder itemPath, String initialFileName, Map<String, String> storeParams) throws IOException {
        List mappers = GeoServerExtensions.extensions(RESTUploadPathMapper.class);
        for (RESTUploadPathMapper mapper : mappers) {
            mapper.mapItemPath(workspace, store, storeParams, itemPath, initialFileName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void unzipInputStream(InputStream in, File outputDirectory) throws IOException {
        ZipInputStream zin = null;
        try {
            ZipEntry entry;
            zin = new ZipInputStream(in);
            byte[] buffer = new byte[2048];
            while ((entry = zin.getNextEntry()) != null) {
                String outpath = outputDirectory.getAbsolutePath() + "/" + entry.getName();
                FileOutputStream output = null;
                try {
                    output = new FileOutputStream(outpath);
                    int len = 0;
                    while ((len = zin.read(buffer)) > 0) {
                        output.write(buffer, 0, len);
                    }
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(output);
                    throw throwable;
                }
                IOUtils.closeQuietly((OutputStream)output);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(zin);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)zin);
    }

    static {
        ZIP_MIME_TYPES.add("application/zip");
        ZIP_MIME_TYPES.add("multipart/x-zip");
        ZIP_MIME_TYPES.add("application/x-zip-compressed");
    }
}

