/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest;

import com.noelios.restlet.ext.servlet.ServletConverter;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.geoserver.config.GeoServer;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.rest.BeanDelegatingRestlet;
import org.geoserver.rest.BeanResourceFinder;
import org.geoserver.rest.DispatcherCallback;
import org.geoserver.rest.GeoServerServletConverter;
import org.geoserver.rest.IndexRestlet;
import org.geoserver.rest.PageInfo;
import org.geoserver.rest.RESTMapping;
import org.geoserver.rest.RestletException;
import org.geotools.util.logging.Logging;
import org.restlet.Restlet;
import org.restlet.Router;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.resource.Resource;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;

public class RESTDispatcher
extends AbstractController {
    public static final String METHOD_PUT = "PUT";
    public static final String METHOD_DELETE = "DELETE";
    static Logger LOG = Logging.getLogger((String)"org.geoserver.rest");
    ServletConverter myConverter;
    Router myRouter;
    List<DispatcherCallback> callbacks;
    GeoServer gs;

    public RESTDispatcher(GeoServer gs) {
        this.gs = gs;
        this.setSupportedMethods(new String[]{"GET", "POST", METHOD_PUT, METHOD_DELETE, "HEAD"});
    }

    protected void initApplicationContext() throws BeansException {
        super.initApplicationContext();
        this.myConverter = new GeoServerServletConverter(this.getServletContext());
        this.myConverter.setTarget(this.createRoot());
        this.callbacks = GeoServerExtensions.extensions(DispatcherCallback.class, (ApplicationContext)this.getApplicationContext());
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        try {
            this.myConverter.service(req, resp);
        }
        catch (Exception e) {
            RestletException re = null;
            if (e instanceof RestletException) {
                re = (RestletException)e;
            }
            if (re == null && e.getCause() instanceof RestletException) {
                re = (RestletException)e.getCause();
            }
            if (re != null) {
                resp.setStatus(re.getStatus().getCode());
                String reStr = re.getRepresentation().getText();
                if (reStr != null) {
                    LOG.severe(reStr);
                    resp.setContentType("text/plain");
                    resp.getOutputStream().write(reStr.getBytes());
                }
                LOG.log(Level.SEVERE, "", re);
            } else {
                LOG.log(Level.SEVERE, "", e);
                resp.setStatus(500);
                if (e.getMessage() != null) {
                    resp.getOutputStream().write(e.getMessage().getBytes());
                }
            }
            resp.getOutputStream().flush();
        }
        return null;
    }

    public void addRoutes(Map m, Router r) {
        for (Map.Entry entry : m.entrySet()) {
            Object restlet = this.getApplicationContext().getBean(entry.getValue().toString()) instanceof Resource ? new BeanResourceFinder(this.getApplicationContext(), entry.getValue().toString()) : new BeanDelegatingRestlet(this.getApplicationContext(), entry.getValue().toString());
            String path = entry.getKey().toString();
            r.attach(path, (Restlet)restlet);
            if (path.indexOf("?") == -1) {
                r.attach(path + "?{q}", (Restlet)restlet);
                continue;
            }
            LOG.fine("Query string already listed in restlet mapping: " + path);
        }
    }

    public Restlet createRoot() {
        if (this.myRouter == null) {
            this.myRouter = new Router(){

                protected synchronized void init(Request request, Response response) {
                    String extension;
                    super.init(request, response);
                    String baseURL = request.getRootRef().getParentRef().toString();
                    String rootPath = request.getRootRef().toString().substring(baseURL.length());
                    String pagePath = request.getResourceRef().toString().substring(baseURL.length());
                    String basePath = null;
                    if (request.getResourceRef().getBaseRef() != null) {
                        basePath = request.getResourceRef().getBaseRef().toString().substring(baseURL.length());
                    }
                    if ((extension = ResponseUtils.getExtension((String)pagePath)) != null) {
                        pagePath = pagePath.substring(0, pagePath.length() - extension.length() - 1);
                    }
                    if (pagePath.endsWith("/")) {
                        pagePath = pagePath.substring(0, pagePath.length() - 1);
                    }
                    PageInfo pageInfo = new PageInfo();
                    pageInfo.setBaseURL(baseURL);
                    pageInfo.setRootPath(rootPath);
                    pageInfo.setBasePath(basePath);
                    pageInfo.setPagePath(pagePath);
                    pageInfo.setExtension(extension);
                    request.getAttributes().put("org.geoserver.pageDetails", pageInfo);
                    for (DispatcherCallback callback : RESTDispatcher.this.callbacks) {
                        callback.init(request, response);
                    }
                }

                public Restlet getNext(Request request, Response response) {
                    Restlet next = super.getNext(request, response);
                    if (next != null) {
                        for (DispatcherCallback callback : RESTDispatcher.this.callbacks) {
                            callback.dispatched(request, response, next);
                        }
                    }
                    return next;
                }

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void handle(Request request, Response response) {
                    Iterator<DispatcherCallback> i$2;
                    try {
                        try {
                            super.handle(request, response);
                        }
                        catch (Exception e) {
                            for (DispatcherCallback callback : RESTDispatcher.this.callbacks) {
                                callback.exception(request, response, e);
                            }
                            if (e instanceof RuntimeException) {
                                throw (RuntimeException)e;
                            }
                            throw new RuntimeException(e);
                        }
                        Object var7_3 = null;
                        i$2 = RESTDispatcher.this.callbacks.iterator();
                    }
                    catch (Throwable throwable) {
                        Object var7_4 = null;
                        Iterator<DispatcherCallback> i$2 = RESTDispatcher.this.callbacks.iterator();
                        while (true) {
                            if (!i$2.hasNext()) {
                                throw throwable;
                            }
                            DispatcherCallback callback = i$2.next();
                            callback.finished(request, response);
                        }
                    }
                    while (i$2.hasNext()) {
                        DispatcherCallback callback = i$2.next();
                        callback.finished(request, response);
                    }
                    return;
                }
            };
            for (RESTMapping rm : GeoServerExtensions.extensions(RESTMapping.class)) {
                this.addRoutes(rm.getRoutes(), this.myRouter);
            }
            this.myRouter.attach("", (Restlet)new IndexRestlet(this.myRouter));
        }
        return this.myRouter;
    }
}

