/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.geoserver.rest.AbstractResource;
import org.geoserver.rest.RestletException;
import org.geoserver.rest.format.DataFormat;
import org.geoserver.rest.format.MapJSONFormat;
import org.geoserver.rest.format.MapXMLFormat;
import org.geotools.util.logging.Logging;
import org.restlet.Context;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MapResource
extends AbstractResource {
    protected static Logger LOG = Logging.getLogger((String)"org.geoserver.rest");

    public MapResource(Context context, Request request, Response response) {
        super(context, request, response);
    }

    public MapResource() {
    }

    @Override
    protected List<DataFormat> createSupportedFormats(Request request, Response response) {
        ArrayList<DataFormat> formats = new ArrayList<DataFormat>();
        formats.add(new MapXMLFormat());
        formats.add(new MapJSONFormat());
        return formats;
    }

    public void handleGet() {
        Map map;
        try {
            map = this.getMap();
        }
        catch (Exception e) {
            throw this.createRestletException(e);
        }
        DataFormat format = this.getFormatGet();
        this.getResponse().setEntity(format.toRepresentation(map));
    }

    public abstract Map getMap() throws Exception;

    public void handlePost() {
        DataFormat format = this.getFormatPostOrPut();
        Map map = (Map)format.toObject(this.getRequest().getEntity());
        try {
            this.postMap(map);
        }
        catch (Exception e) {
            throw this.createRestletException(e);
        }
    }

    protected void postMap(Map map) throws Exception {
    }

    public void handlePut() {
        DataFormat format = this.getFormatPostOrPut();
        Map map = (Map)format.toObject(this.getRequest().getEntity());
        try {
            this.putMap(map);
        }
        catch (Exception e) {
            throw this.createRestletException(e);
        }
    }

    protected void putMap(Map map) throws Exception {
    }

    protected RestletException createRestletException(Exception ex) {
        if (ex instanceof RestletException) {
            return (RestletException)ex;
        }
        return new RestletException("", Status.SERVER_ERROR_INTERNAL, (Throwable)ex);
    }
}

