/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.service.rest;

import freemarker.ext.beans.BeansWrapper;
import freemarker.ext.beans.CollectionModel;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.SimpleHash;
import java.util.Collection;
import java.util.Map;
import org.geoserver.catalog.LayerIdentifierInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.impl.AuthorityURL;
import org.geoserver.catalog.rest.CatalogFreemarkerHTMLFormat;
import org.geoserver.config.GeoServer;
import org.geoserver.config.SettingsInfo;
import org.geoserver.config.util.XStreamPersister;
import org.geoserver.rest.format.DataFormat;
import org.geoserver.rest.format.ReflectiveHTMLFormat;
import org.geoserver.service.rest.ServiceSettingsResource;
import org.geoserver.wms.WMSInfo;
import org.geoserver.wms.WMSInfoImpl;
import org.geoserver.wms.WatermarkInfo;
import org.geoserver.wms.WatermarkInfoImpl;
import org.restlet.Context;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.resource.Resource;

public class WMSSettingsResource
extends ServiceSettingsResource {
    public WMSSettingsResource(Context context, Request request, Response response, Class clazz, GeoServer geoServer) {
        super(context, request, response, clazz, geoServer);
    }

    @Override
    protected DataFormat createHTMLFormat(Request request, Response response) {
        return new WMSSettingsHTMLFormat(request, response, (Resource)this);
    }

    @Override
    protected void configurePersister(XStreamPersister persister, DataFormat format) {
        persister.setHideFeatureTypeAttributes();
        persister.getXStream().alias("wms", WMSInfoImpl.class);
        persister.getXStream().alias("class", WatermarkInfo.class, WatermarkInfoImpl.class);
    }

    static class WMSSettingsHTMLFormat
    extends CatalogFreemarkerHTMLFormat {
        public WMSSettingsHTMLFormat(Request request, Response response, Resource resource) {
            super(SettingsInfo.class, request, response, resource);
        }

        protected String getTemplateName(Object data) {
            return "wmsSettings";
        }

        @Override
        protected Configuration createConfiguration(Object data, Class clazz) {
            Configuration cfg = super.createConfiguration(data, clazz);
            cfg.setClassForTemplateLoading(((Object)((Object)this)).getClass(), "templates");
            cfg.setObjectWrapper((ObjectWrapper)new ReflectiveHTMLFormat.ObjectToMapWrapper<WMSInfo>(WMSInfo.class){

                protected void wrapInternal(Map properties, SimpleHash model, WMSInfo wmsInfo) {
                    WorkspaceInfo workspaceInfo = wmsInfo.getWorkspace();
                    properties.put("workspaceName", workspaceInfo != null ? workspaceInfo.getName() : "NO_WORKSPACE");
                    properties.put("enabled", wmsInfo.isEnabled() ? "true" : "false");
                    properties.put("name", wmsInfo.getName());
                    properties.put("title", wmsInfo.getTitle());
                    properties.put("maintainer", wmsInfo.getMaintainer());
                    properties.put("abstract", wmsInfo.getAbstract());
                    properties.put("accessConstraints", wmsInfo.getAccessConstraints());
                    properties.put("fees", wmsInfo.getFees());
                    properties.put("versions", wmsInfo.getVersions());
                    properties.put("keywords", wmsInfo.getKeywords());
                    properties.put("metadataLink", wmsInfo.getMetadataLink());
                    properties.put("citeCompliant", wmsInfo.isCiteCompliant() ? "true" : "false");
                    properties.put("onlineResource", wmsInfo.getOnlineResource());
                    properties.put("schemaBaseURL", wmsInfo.getSchemaBaseURL());
                    properties.put("verbose", wmsInfo.isVerbose() ? "true" : "false");
                    properties.put("authorityURLs", wmsInfo.getAuthorityURLs() != null ? new CollectionModel((Collection)wmsInfo.getAuthorityURLs(), (BeansWrapper)new ReflectiveHTMLFormat.ObjectToMapWrapper((ReflectiveHTMLFormat)WMSSettingsHTMLFormat.this, AuthorityURL.class)) : "NO_AUTHORITY_URL");
                    properties.put("identifiers", wmsInfo.getIdentifiers() != null ? new CollectionModel((Collection)wmsInfo.getIdentifiers(), (BeansWrapper)new ReflectiveHTMLFormat.ObjectToMapWrapper((ReflectiveHTMLFormat)WMSSettingsHTMLFormat.this, LayerIdentifierInfo.class)) : "NO_IDENTIFIER");
                    properties.put("srsList", wmsInfo.getSRS().size() > 0 ? wmsInfo.getSRS() : "NO_SRSList");
                    properties.put("bboxForEachCRS", wmsInfo.isBBOXForEachCRS().toString());
                    properties.put("interpolation", wmsInfo.getInterpolation().name());
                    properties.put("kmlReflectorMode", wmsInfo.getMetadata().get((Object)"kmlReflectorMode") != null ? wmsInfo.getMetadata().get((Object)"kmlReflectorMode") : "NO_KMLREFLECTORMODE");
                    properties.put("kmlSuperoverlayMode", wmsInfo.getMetadata().get((Object)"kmlSuperoverlayMode") != null ? wmsInfo.getMetadata().get((Object)"kmlSuperoverlayMode") : "NO_KMLSUPEROVERLAY");
                    properties.put("kmlAttr", wmsInfo.getMetadata().get((Object)"kmlAttr") != null ? wmsInfo.getMetadata().get((Object)"kmlAttr").toString() : "NO_KMLATTR");
                    properties.put("kmlPlacemark", wmsInfo.getMetadata().get((Object)"kmlPlacemark") != null ? wmsInfo.getMetadata().get((Object)"kmlPlacemark").toString() : "NO_KMLPLACEMARK");
                    properties.put("kmlKmscore", wmsInfo.getMetadata().get((Object)"kmlKmscore") != null ? String.valueOf(wmsInfo.getMetadata().get((Object)"kmlKmscore")) : "NO_KMLKMSCORE");
                    properties.put("maxRequestMemory", String.valueOf(wmsInfo.getMaxRequestMemory()));
                    properties.put("maxRenderingTime", String.valueOf(wmsInfo.getMaxRenderingTime()));
                    properties.put("maxRenderindErrors", String.valueOf(wmsInfo.getMaxRenderingErrors()));
                    properties.put("watermarkEnabled", wmsInfo.getWatermark().isEnabled() ? "true" : "false");
                    properties.put("watermarkUrl", wmsInfo.getWatermark().getURL() != null ? wmsInfo.getWatermark().getURL() : "NO_WATERMARK_URL");
                    properties.put("watermarkTransparency", String.valueOf(wmsInfo.getWatermark().getTransparency()));
                    properties.put("watermarkPosition", wmsInfo.getWatermark().getPosition());
                    properties.put("pngCompression", String.valueOf(wmsInfo.getMetadata().get((Object)"pngCompression")));
                    properties.put("jpegCompression", String.valueOf(wmsInfo.getMetadata().get((Object)"jpegCompression")));
                    properties.put("maxAllowedFrames", String.valueOf(wmsInfo.getMetadata().get((Object)"maxAllowedFrames")));
                    properties.put("maxAnimatorRenderingTime", String.valueOf(wmsInfo.getMetadata().get((Object)"maxAnimatorRenderingTime")));
                    properties.put("maxRenderingSize", String.valueOf(wmsInfo.getMetadata().get((Object)"maxRenderingSize")));
                    properties.put("framesDelay", String.valueOf(wmsInfo.getMetadata().get((Object)"framesDelay")));
                    properties.put("loopContinuosly", String.valueOf(wmsInfo.getMetadata().get((Object)"loopContinuosly")));
                    properties.put("svgAntiAlias", String.valueOf(wmsInfo.getMetadata().get((Object)"svgAntiAlias")));
                    properties.put("svgRenderer", String.valueOf(wmsInfo.getMetadata().get((Object)"svgRenderer")));
                }
            });
            return cfg;
        }
    }
}

