/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.service.rest;

import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.rest.AbstractCatalogResource;
import org.geoserver.config.GeoServer;
import org.geoserver.config.ServiceInfo;
import org.geoserver.ows.util.OwsUtils;
import org.geoserver.rest.RestletException;
import org.restlet.Context;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;

public class ServiceSettingsResource
extends AbstractCatalogResource {
    protected GeoServer geoServer;
    private Class clazz;

    public ServiceSettingsResource(Context context, Request request, Response response, Class clazz, GeoServer geoServer) {
        super(context, request, response, clazz, geoServer.getCatalog());
        this.clazz = clazz;
        this.geoServer = geoServer;
    }

    public boolean allowPut() {
        return true;
    }

    public boolean allowDelete() {
        String workspace = this.getAttribute("workspace");
        if (workspace != null) {
            WorkspaceInfo ws = this.geoServer.getCatalog().getWorkspaceByName(workspace);
            return this.geoServer.getService(ws, this.clazz) != null;
        }
        return false;
    }

    protected Object handleObjectGet() throws Exception {
        ServiceInfo service;
        String workspace = this.getAttribute("workspace");
        if (workspace != null) {
            WorkspaceInfo ws = this.geoServer.getCatalog().getWorkspaceByName(workspace);
            service = this.geoServer.getService(ws, this.clazz);
        } else {
            service = this.geoServer.getService(this.clazz);
        }
        if (service == null) {
            throw new RestletException("Service for workspace " + workspace + " does not exist", Status.CLIENT_ERROR_NOT_FOUND);
        }
        return service;
    }

    protected void handleObjectPut(Object object) throws Exception {
        String workspace = this.getAttribute("workspace");
        WorkspaceInfo ws = null;
        if (workspace != null) {
            ws = this.geoServer.getCatalog().getWorkspaceByName(workspace);
        }
        ServiceInfo serviceInfo = (ServiceInfo)object;
        ServiceInfo originalInfo = ws != null ? this.geoServer.getService(ws, this.clazz) : this.geoServer.getService(this.clazz);
        if (originalInfo != null) {
            OwsUtils.copy((Object)serviceInfo, (Object)originalInfo, (Class)this.clazz);
            this.geoServer.save(originalInfo);
        } else {
            if (ws != null) {
                serviceInfo.setWorkspace(ws);
            }
            this.geoServer.add(serviceInfo);
        }
    }

    protected void handleObjectDelete() throws Exception {
        WorkspaceInfo ws;
        ServiceInfo serviceInfo;
        String workspace = this.getAttribute("workspace");
        if (workspace != null && (serviceInfo = this.geoServer.getService(ws = this.geoServer.getCatalog().getWorkspaceByName(workspace), this.clazz)) != null) {
            this.geoServer.remove(serviceInfo);
        }
    }
}

