/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.rest;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.geoserver.rest.format.StreamDataFormat;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.restlet.data.MediaType;

public class RuleXMLFormat
extends StreamDataFormat {
    static final String ROOTELEMENT = "rules";
    static final String RULEELEMENT = "rule";
    static final String RESOURCEATTR = "resource";

    public RuleXMLFormat() {
        super(MediaType.APPLICATION_XML);
    }

    protected void write(Object object, OutputStream out) throws IOException {
        Element root = new Element(ROOTELEMENT);
        Document doc = new Document(root);
        this.insert(root, (Map)object);
        XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat());
        outputter.output(doc, out);
    }

    private final void insert(Element elem, Map<String, String> ruleMap) {
        for (Map.Entry<String, String> entry : ruleMap.entrySet()) {
            Element ruleElement = new Element(RULEELEMENT);
            ruleElement.setAttribute(RESOURCEATTR, entry.getKey());
            ruleElement.setText(entry.getValue());
            elem.getChildren().add(ruleElement);
        }
    }

    protected Object read(InputStream in) throws IOException {
        Document doc;
        Map<String, String> result = null;
        SAXBuilder builder = new SAXBuilder();
        try {
            doc = builder.build(in);
        }
        catch (JDOMException e) {
            throw (IOException)new IOException("Error building document").initCause(e);
        }
        Element elem = doc.getRootElement();
        result = this.convert(elem);
        return result;
    }

    private Map<String, String> convert(Element elem) {
        HashMap<String, String> ruleMap = new HashMap<String, String>();
        List children = elem.getChildren();
        for (Element ruleElement : children) {
            String resource = ruleElement.getAttributeValue(RESOURCEATTR);
            ruleMap.put(resource, ruleElement.getTextTrim());
        }
        return ruleMap;
    }
}

