/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.rest;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.rest.MapResource;
import org.geoserver.rest.RestletException;
import org.geoserver.rest.format.DataFormat;
import org.geoserver.rest.format.MapJSONFormat;
import org.geoserver.rest.format.MapXMLFormat;
import org.geoserver.security.GeoServerSecurityManager;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;

public class MasterPasswordResource
extends MapResource {
    static final String MP_CURRENT_KEY = "oldMasterPassword";
    static final String MP_NEW_KEY = "newMasterPassword";
    static final String XML_ROOT_ELEM = "masterPassword";
    Map putMap;

    GeoServerSecurityManager getManager() {
        return (GeoServerSecurityManager)GeoServerExtensions.bean(GeoServerSecurityManager.class);
    }

    protected List<DataFormat> createSupportedFormats(Request request, Response response) {
        ArrayList<DataFormat> formats = new ArrayList<DataFormat>();
        formats.add((DataFormat)new MapXMLFormat(XML_ROOT_ELEM));
        formats.add((DataFormat)new MapJSONFormat());
        return formats;
    }

    public boolean allowPut() {
        if (!this.getManager().checkAuthenticationForAdminRole()) {
            return false;
        }
        try {
            String providerName = this.getManager().loadMasterPasswordConfig().getProviderName();
            return !this.getManager().loadMasterPassswordProviderConfig(providerName).isReadOnly();
        }
        catch (IOException e) {
            throw new RestletException("Cannot calculate if PUT is allowed", Status.CLIENT_ERROR_UNPROCESSABLE_ENTITY, (Throwable)e);
        }
    }

    public void handleGet() {
        if (!this.getManager().checkAuthenticationForAdminRole()) {
            throw new RestletException("Amdinistrative privelges required", Status.CLIENT_ERROR_FORBIDDEN);
        }
        super.handleGet();
    }

    public Map getMap() throws Exception {
        char[] masterpw = this.getManager().getMasterPasswordForREST();
        HashMap<String, String> m = new HashMap<String, String>();
        m.put(MP_CURRENT_KEY, new String(masterpw));
        this.getManager().disposePassword(masterpw);
        return m;
    }

    protected void putMap(Map map) throws Exception {
        this.putMap = map;
    }

    public void handlePut() {
        super.handlePut();
        String current = (String)this.putMap.get(MP_CURRENT_KEY);
        String newpass = (String)this.putMap.get(MP_NEW_KEY);
        if (!StringUtils.isNotBlank((String)current)) {
            throw new RestletException("no master password", Status.CLIENT_ERROR_BAD_REQUEST);
        }
        if (!StringUtils.isNotBlank((String)newpass)) {
            throw new RestletException("no master password", Status.CLIENT_ERROR_BAD_REQUEST);
        }
        char[] currentArray = current.trim().toCharArray();
        char[] newpassArray = newpass.trim().toCharArray();
        GeoServerSecurityManager m = this.getManager();
        try {
            m.saveMasterPasswordConfig(m.loadMasterPasswordConfig(), currentArray, newpassArray, newpassArray);
        }
        catch (Exception e) {
            throw new RestletException("Cannot change master password", Status.CLIENT_ERROR_UNPROCESSABLE_ENTITY, (Throwable)e);
        }
        finally {
            m.disposePassword(currentArray);
            m.disposePassword(newpassArray);
        }
    }
}

