/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.rest;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.rest.MapResource;
import org.geoserver.rest.RestletException;
import org.geoserver.rest.format.DataFormat;
import org.geoserver.rest.format.MapJSONFormat;
import org.geoserver.rest.format.MapXMLFormat;
import org.geoserver.security.CatalogMode;
import org.geoserver.security.GeoServerSecurityManager;
import org.geoserver.security.impl.DataAccessRuleDAO;
import org.geoserver.security.rest.AbstractAccessControlResource;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;

public class CatalogModeResource
extends MapResource {
    static final String MODE_ELEMENT = "mode";
    static final String XML_ROOT_ELEM = "catalog";
    DataAccessRuleDAO ruleDAO = DataAccessRuleDAO.get();

    protected List<DataFormat> createSupportedFormats(Request request, Response response) {
        ArrayList<DataFormat> formats = new ArrayList<DataFormat>();
        formats.add((DataFormat)new MapXMLFormat(XML_ROOT_ELEM));
        formats.add((DataFormat)new MapJSONFormat());
        return formats;
    }

    GeoServerSecurityManager getManager() {
        return (GeoServerSecurityManager)GeoServerExtensions.bean(GeoServerSecurityManager.class);
    }

    public boolean allowDelete() {
        return false;
    }

    public boolean allowPost() {
        return false;
    }

    public boolean allowPut() {
        return true;
    }

    public boolean allowGet() {
        return true;
    }

    public void handleGet() {
        if (!this.getManager().checkAuthenticationForAdminRole()) {
            throw AbstractAccessControlResource.createNonAdminException();
        }
        super.handleGet();
    }

    public void handlePut() {
        if (!this.getManager().checkAuthenticationForAdminRole()) {
            throw AbstractAccessControlResource.createNonAdminException();
        }
        super.handlePut();
    }

    public Map getMap() throws Exception {
        CatalogMode mode = this.ruleDAO.getMode();
        HashMap<String, String> modeMap = new HashMap<String, String>();
        modeMap.put(MODE_ELEMENT, mode.toString());
        return modeMap;
    }

    protected void putMap(Map map) throws Exception {
        String mode = (String)map.get(MODE_ELEMENT);
        if (mode == null) {
            throw this.createRestletException((Exception)((Object)new RestletException("Element mode is missing", Status.CLIENT_ERROR_NOT_FOUND)));
        }
        CatalogMode modeValue = null;
        for (CatalogMode m : CatalogMode.values()) {
            if (!m.toString().equals(mode)) continue;
            modeValue = m;
            break;
        }
        if (modeValue == null) {
            throw this.createRestletException((Exception)((Object)new RestletException("Not a valid mode: " + mode, Status.CLIENT_ERROR_UNPROCESSABLE_ENTITY)));
        }
        this.ruleDAO.setCatalogMode(modeValue);
        this.ruleDAO.storeRules();
    }
}

