/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.rest;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.rest.MapResource;
import org.geoserver.rest.RestletException;
import org.geoserver.rest.format.DataFormat;
import org.geoserver.rest.format.MapJSONFormat;
import org.geoserver.security.GeoServerSecurityManager;
import org.geoserver.security.impl.AbstractAccessRuleDAO;
import org.geoserver.security.rest.RuleXMLFormat;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;

public abstract class AbstractAccessControlResource<DAO extends AbstractAccessRuleDAO<Comparable<?>>>
extends MapResource {
    public static final String ANY = "*";
    DAO ruleDAO;

    AbstractAccessControlResource(DAO ruleDAO) {
        this.ruleDAO = ruleDAO;
    }

    GeoServerSecurityManager getManager() {
        return (GeoServerSecurityManager)GeoServerExtensions.bean(GeoServerSecurityManager.class);
    }

    protected List<DataFormat> createSupportedFormats(Request request, Response response) {
        ArrayList<DataFormat> formats = new ArrayList<DataFormat>();
        formats.add((DataFormat)new RuleXMLFormat());
        formats.add((DataFormat)new MapJSONFormat());
        return formats;
    }

    public boolean allowPut() {
        return true;
    }

    public boolean allowDelete() {
        return true;
    }

    public boolean allowPost() {
        return true;
    }

    public boolean allowGet() {
        return true;
    }

    static RestletException createNonAdminException() {
        return new RestletException("Amdinistrative priveleges required", Status.CLIENT_ERROR_FORBIDDEN);
    }

    public void handleGet() {
        if (!this.getManager().checkAuthenticationForAdminRole()) {
            throw AbstractAccessControlResource.createNonAdminException();
        }
        super.handleGet();
    }

    public void handlePost() {
        if (!this.getManager().checkAuthenticationForAdminRole()) {
            throw AbstractAccessControlResource.createNonAdminException();
        }
        super.handlePost();
    }

    public void handlePut() {
        if (!this.getManager().checkAuthenticationForAdminRole()) {
            throw AbstractAccessControlResource.createNonAdminException();
        }
        super.handlePut();
    }

    public void handleDelete() {
        if (!this.getManager().checkAuthenticationForAdminRole()) {
            throw AbstractAccessControlResource.createNonAdminException();
        }
        String ruleURI = (String)this.getRequest().getAttributes().get("rule");
        String ruleString = null;
        try {
            ruleString = URLDecoder.decode(ruleURI, "utf-8");
        }
        catch (UnsupportedEncodingException e1) {
            throw new RestletException(e1.getMessage(), Status.SERVER_ERROR_INTERNAL, (Throwable)e1);
        }
        String msg = this.validateRuleKey(ruleString);
        if (msg != null) {
            throw this.createRestletException((Exception)((Object)new RestletException(msg, Status.CLIENT_ERROR_UNPROCESSABLE_ENTITY)));
        }
        Comparable rule = null;
        for (Comparable ruleCandidate : this.ruleDAO.getRules()) {
            if (!ruleString.equals(this.keyFor(ruleCandidate))) continue;
            rule = ruleCandidate;
            break;
        }
        if (rule == null) {
            throw new RestletException("Rule not found: " + rule, Status.CLIENT_ERROR_NOT_FOUND);
        }
        try {
            this.ruleDAO.removeRule(rule);
            this.ruleDAO.storeRules();
        }
        catch (Exception e) {
            throw this.createRestletException(e);
        }
    }

    protected abstract void addRuleToMap(Comparable var1, Map<String, String> var2);

    public Map getMap() throws Exception {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Comparable rule : this.ruleDAO.getRules()) {
            this.addRuleToMap(rule, result);
        }
        return result;
    }

    protected Set<Object> intersection(Map map) {
        HashSet<Object> result = new HashSet<Object>();
        HashSet<String> ruleKeys = new HashSet<String>();
        for (Comparable comparable : this.ruleDAO.getRules()) {
            ruleKeys.add(this.keyFor(comparable));
        }
        if (ruleKeys.isEmpty() || map.isEmpty()) {
            return result;
        }
        for (Object e : ruleKeys) {
            if (!map.containsKey(e)) continue;
            result.add(e);
        }
        return result;
    }

    protected Set<Object> nonExistingKeys(Map map) {
        List rules = this.ruleDAO.getRules();
        if (rules.isEmpty()) {
            return map.keySet();
        }
        HashSet<Object> result = new HashSet<Object>();
        HashSet<String> ruleKeys = new HashSet<String>();
        for (Comparable rule : rules) {
            ruleKeys.add(this.keyFor(rule));
        }
        for (Object key : map.keySet()) {
            if (ruleKeys.contains(key)) continue;
            result.add(key);
        }
        return result;
    }

    protected abstract String keyFor(Comparable<?> var1);

    protected String validateRule(String ruleKey, String ruleValue) {
        return this.validateRuleKey(ruleKey);
    }

    protected abstract String validateRuleKey(String var1);

    protected abstract Comparable convertEntryToRule(Map.Entry<String, String> var1);

    protected void validateMap(Map<String, String> ruleMap) {
        for (Map.Entry<String, String> entry : ruleMap.entrySet()) {
            String msg = this.validateRule(entry.getKey(), entry.getValue());
            if (msg == null) continue;
            throw this.createRestletException((Exception)((Object)new RestletException(msg, Status.CLIENT_ERROR_UNPROCESSABLE_ENTITY)));
        }
    }

    protected void postMap(Map map) throws Exception {
        this.validateMap(map);
        Set<Object> commonKeys = this.intersection(map);
        if (!commonKeys.isEmpty()) {
            String msg = "Already existing rules: " + StringUtils.join(commonKeys.iterator(), (String)",");
            throw new RestletException(msg, Status.CLIENT_ERROR_CONFLICT);
        }
        ArrayList toBeAdded = new ArrayList();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            Comparable rule = this.convertEntryToRule(entry);
            this.ruleDAO.addRule(rule);
        }
        this.ruleDAO.storeRules();
    }

    protected void putMap(Map map) throws Exception {
        this.validateMap(map);
        Set<Object> nonExisting = this.nonExistingKeys(map);
        if (!nonExisting.isEmpty()) {
            String msg = "Unknown rules: " + StringUtils.join(nonExisting.iterator(), (String)",");
            throw new RestletException(msg, Status.CLIENT_ERROR_CONFLICT);
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            Comparable rule = this.convertEntryToRule(entry);
            this.ruleDAO.removeRule(rule);
            this.ruleDAO.addRule(rule);
        }
        this.ruleDAO.storeRules();
    }

    protected Set<String> parseRoles(String roleCsv) {
        String[] rolesArray = roleCsv.split("[\\s,]+");
        HashSet<String> roles = new HashSet<String>(rolesArray.length);
        roles.addAll(Arrays.asList(rolesArray));
        for (String role : roles) {
            if (!ANY.equals(role)) continue;
            return Collections.singleton(ANY);
        }
        return roles;
    }
}

