/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest;

import org.geoserver.GeoServerConfigurationLock;
import org.geoserver.rest.BeanDelegatingRestlet;
import org.geoserver.rest.DispatcherCallback;
import org.restlet.Restlet;
import org.restlet.Route;
import org.restlet.data.Method;
import org.restlet.data.Request;
import org.restlet.data.Response;

public class RestConfigurationLockCallback
implements DispatcherCallback {
    GeoServerConfigurationLock locker;
    static ThreadLocal<GeoServerConfigurationLock.LockType> THREAD_LOCK = new ThreadLocal();

    public RestConfigurationLockCallback(GeoServerConfigurationLock locker) {
        this.locker = locker;
    }

    public void init(Request request, Response response) {
        GeoServerConfigurationLock.LockType type = THREAD_LOCK.get();
        if (type != null) {
            throw new RuntimeException("The previous lock was not released: " + type);
        }
    }

    public void dispatched(Request request, Response response, Restlet restlet) {
        Method m = request.getMethod();
        if (restlet instanceof Route) {
            restlet = ((Route)restlet).getNext();
        }
        if (restlet instanceof BeanDelegatingRestlet) {
            restlet = ((BeanDelegatingRestlet)restlet).getBean();
        }
        if (restlet != null && restlet.getClass().getPackage().getName().startsWith("org.geoserver.catalog.rest")) {
            GeoServerConfigurationLock.LockType type = m == Method.DELETE || m == Method.COPY || m == Method.MKCOL || m == Method.MOVE || m == Method.PROPPATCH || m == Method.POST || m == Method.PUT ? GeoServerConfigurationLock.LockType.WRITE : GeoServerConfigurationLock.LockType.READ;
            THREAD_LOCK.set(type);
            this.locker.lock(type);
        }
    }

    public void exception(Request request, Response response, Exception error) {
    }

    public void finished(Request request, Response response) {
        GeoServerConfigurationLock.LockType type = THREAD_LOCK.get();
        if (type != null) {
            THREAD_LOCK.remove();
            this.locker.unlock(type);
        }
    }
}

