/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest;

import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.SimpleHash;
import java.util.Map;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.rest.AbstractCatalogResource;
import org.geoserver.catalog.rest.CatalogFreemarkerHTMLFormat;
import org.geoserver.config.ContactInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.config.SettingsInfo;
import org.geoserver.config.impl.SettingsInfoImpl;
import org.geoserver.ows.util.OwsUtils;
import org.geoserver.rest.RestletException;
import org.geoserver.rest.format.DataFormat;
import org.geoserver.rest.format.ReflectiveHTMLFormat;
import org.restlet.Context;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.resource.Resource;

public class LocalSettingsResource
extends AbstractCatalogResource {
    private GeoServer geoServer;

    public LocalSettingsResource(Context context, Request request, Response response, Class clazz, GeoServer geoServer) {
        super(context, request, response, clazz, geoServer.getCatalog());
        this.geoServer = geoServer;
    }

    @Override
    protected DataFormat createHTMLFormat(Request request, Response response) {
        return new LocalSettingsHTMLFormat(request, response, (Resource)this);
    }

    public boolean allowPut() {
        return true;
    }

    public boolean allowDelete() {
        return this.allowExisting();
    }

    private boolean allowExisting() {
        String workspace = this.getAttribute("workspace");
        WorkspaceInfo ws = this.geoServer.getCatalog().getWorkspaceByName(workspace);
        if (ws != null) {
            return this.geoServer.getSettings(ws) != null;
        }
        return this.geoServer.getSettings(ws) == null;
    }

    protected Object handleObjectGet() throws Exception {
        String workspace = this.getAttribute("workspace");
        if (workspace != null) {
            WorkspaceInfo workspaceInfo = this.geoServer.getCatalog().getWorkspaceByName(workspace);
            SettingsInfo settingsInfo = this.geoServer.getSettings(workspaceInfo);
            if (settingsInfo == null) {
                settingsInfo = new SettingsInfoImpl();
                settingsInfo.setVerbose(false);
            }
            return settingsInfo;
        }
        throw new RestletException("Workspace " + workspace + " not found", Status.CLIENT_ERROR_BAD_REQUEST);
    }

    protected String handleObjectPost(Object obj) throws Exception {
        String name = "";
        String workspace = this.getAttribute("workspace");
        if (workspace != null) {
            Catalog catalog = this.geoServer.getCatalog();
            WorkspaceInfo workspaceInfo = catalog.getWorkspaceByName(workspace);
            SettingsInfo settings = (SettingsInfo)obj;
            settings.setWorkspace(workspaceInfo);
            this.geoServer.add(settings);
            this.geoServer.save(this.geoServer.getSettings(workspaceInfo));
            name = settings.getWorkspace().getName();
        }
        return name;
    }

    protected void handleObjectPut(Object obj) throws Exception {
        String workspace = this.getAttribute("workspace");
        if (workspace != null) {
            WorkspaceInfo workspaceInfo = this.catalog.getWorkspaceByName(workspace);
            SettingsInfo settingsInfo = (SettingsInfo)obj;
            SettingsInfo original = this.geoServer.getSettings(workspaceInfo);
            if (original == null) {
                settingsInfo.setWorkspace(workspaceInfo);
                this.geoServer.add(settingsInfo);
                this.geoServer.save(this.geoServer.getSettings(workspaceInfo));
            } else {
                OwsUtils.copy((Object)settingsInfo, (Object)original, SettingsInfo.class);
                original.setWorkspace(workspaceInfo);
                this.geoServer.save(original);
            }
        }
    }

    public void handleObjectDelete() throws Exception {
        String workspace = this.getAttribute("workspace");
        if (workspace != null) {
            WorkspaceInfo workspaceInfo = this.geoServer.getCatalog().getWorkspaceByName(workspace);
            SettingsInfo settingsInfo = this.geoServer.getSettings(workspaceInfo);
            this.geoServer.remove(settingsInfo);
        }
    }

    static class LocalSettingsHTMLFormat
    extends CatalogFreemarkerHTMLFormat {
        public LocalSettingsHTMLFormat(Request request, Response response, Resource resource) {
            super(SettingsInfo.class, request, response, resource);
        }

        protected String getTemplateName(Object data) {
            return "localSettings";
        }

        @Override
        protected Configuration createConfiguration(Object data, Class clazz) {
            Configuration cfg = super.createConfiguration(data, clazz);
            cfg.setClassForTemplateLoading(((Object)((Object)this)).getClass(), "templates");
            cfg.setObjectWrapper((ObjectWrapper)new ReflectiveHTMLFormat.ObjectToMapWrapper<SettingsInfo>(SettingsInfo.class){

                protected void wrapInternal(Map properties, SimpleHash model, SettingsInfo settingsInfo) {
                    WorkspaceInfo workspaceInfo = settingsInfo.getWorkspace();
                    properties.put("workspaceName", settingsInfo.getWorkspace() != null ? workspaceInfo.getName() : "NO_WORKSPACE");
                    ContactInfo contactInfo = settingsInfo.getContact();
                    properties.put("contactPerson", contactInfo.getContactPerson() != null ? contactInfo.getContactPerson() : "");
                    properties.put("contactOrganization", contactInfo.getContactOrganization() != null ? contactInfo.getContactOrganization() : "");
                    properties.put("contactPosition", contactInfo.getContactPosition() != null ? contactInfo.getContactPosition() : "");
                    properties.put("addressType", contactInfo.getAddressType() != null ? contactInfo.getAddressType() : "");
                    properties.put("address", contactInfo.getAddress() != null ? contactInfo.getAddress() : "");
                    properties.put("addressCity", contactInfo.getAddressCity() != null ? contactInfo.getAddressCity() : "");
                    properties.put("addressState", contactInfo.getAddressState() != null ? contactInfo.getAddressState() : "");
                    properties.put("addressPostalCode", contactInfo.getAddressPostalCode() != null ? contactInfo.getAddressPostalCode() : "");
                    properties.put("addressCountry", contactInfo.getAddressCountry() != null ? contactInfo.getAddressCountry() : "");
                    properties.put("contactVoice", contactInfo.getContactVoice() != null ? contactInfo.getContactVoice() : "");
                    properties.put("contactFacsimile", contactInfo.getContactFacsimile() != null ? contactInfo.getContactFacsimile() : "");
                    properties.put("contactEmail", contactInfo.getContactEmail() != null ? contactInfo.getContactEmail() : "");
                    properties.put("verbose", settingsInfo.isVerbose() ? "true" : "false");
                    properties.put("verboseExceptions", settingsInfo.isVerboseExceptions() ? "true" : "false");
                    properties.put("numDecimals", String.valueOf(settingsInfo.getNumDecimals()));
                    properties.put("charset", settingsInfo.getCharset());
                    properties.put("proxyBaseUrl", settingsInfo.getProxyBaseUrl() != null ? settingsInfo.getProxyBaseUrl() : "");
                }
            });
            return cfg;
        }
    }
}

