/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest;

import freemarker.template.Configuration;
import org.geoserver.catalog.rest.AbstractCatalogResource;
import org.geoserver.catalog.rest.CatalogFreemarkerHTMLFormat;
import org.geoserver.config.ContactInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.config.util.XStreamPersister;
import org.geoserver.ows.util.OwsUtils;
import org.geoserver.rest.RestletException;
import org.geoserver.rest.format.DataFormat;
import org.restlet.Context;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.resource.Resource;

public class GlobalContactResource
extends AbstractCatalogResource {
    public GlobalContactResource(Context context, Request request, Response response, Class clazz, GeoServer geoServer) {
        super(context, request, response, clazz, geoServer.getCatalog());
    }

    @Override
    protected DataFormat createHTMLFormat(Request request, Response response) {
        return new GlobalContactHTMLFormat(request, response, (Resource)this);
    }

    public boolean allowPut() {
        return this.allowExisting();
    }

    private boolean allowExisting() {
        return this.geoServer.getGlobal().getSettings().getContact() != null;
    }

    protected Object handleObjectGet() throws Exception {
        if (this.geoServer.getSettings().getContact() == null) {
            throw new RestletException("No contact information available", Status.CLIENT_ERROR_NOT_FOUND);
        }
        return this.geoServer.getGlobal().getSettings().getContact();
    }

    protected void handleObjectPut(Object obj) throws Exception {
        GeoServerInfo geoServerInfo = this.geoServer.getGlobal();
        ContactInfo original = geoServerInfo.getSettings().getContact();
        OwsUtils.copy((Object)((ContactInfo)obj), (Object)original, ContactInfo.class);
        this.geoServer.save(geoServerInfo);
    }

    @Override
    protected void configurePersister(XStreamPersister persister, DataFormat format) {
        persister.setHideFeatureTypeAttributes();
        persister.getXStream().alias("contact", ContactInfo.class);
    }

    static class GlobalContactHTMLFormat
    extends CatalogFreemarkerHTMLFormat {
        public GlobalContactHTMLFormat(Request request, Response response, Resource resource) {
            super(ContactInfo.class, request, response, resource);
        }

        @Override
        protected Configuration createConfiguration(Object data, Class clazz) {
            Configuration cfg = super.createConfiguration(data, clazz);
            cfg.setClassForTemplateLoading(((Object)((Object)this)).getClass(), "templates");
            return cfg;
        }
    }
}

