/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.SimpleHash;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.geoserver.ManifestLoader;
import org.geoserver.catalog.rest.CatalogFreemarkerHTMLFormat;
import org.geoserver.rest.ReflectiveResource;
import org.geoserver.rest.format.DataFormat;
import org.geoserver.rest.format.ReflectiveHTMLFormat;
import org.restlet.Context;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.resource.Resource;

public class AboutManifest
extends ReflectiveResource {
    private final ManifestLoader.AboutModel.AboutModelType type;

    public AboutManifest(Context context, Request request, Response response, ManifestLoader.AboutModel.AboutModelType type) {
        super(context, request, response);
        this.type = type;
    }

    protected DataFormat createHTMLFormat(Request request, Response response) {
        return new AboutHTMLFormat(request, response, (Resource)this);
    }

    public boolean allowPut() {
        return false;
    }

    protected Object handleObjectGet() throws Exception {
        ManifestLoader.AboutModel model = null;
        String regex = (String)this.getQueryStringValue("manifest", String.class, null);
        if (regex != null) {
            model = AboutManifest.buildAboutModel(this.type).filterNameByRegex(regex);
        }
        String from = (String)this.getQueryStringValue("from", String.class, null);
        String to = (String)this.getQueryStringValue("to", String.class, null);
        if (from != null && to != null) {
            model = model != null ? model.filterNameByRange(from, to) : AboutManifest.buildAboutModel(this.type).filterNameByRange(from, to);
        }
        String key = (String)this.getQueryStringValue("key", String.class, null);
        String value = (String)this.getQueryStringValue("value", String.class, null);
        if (model == null) {
            model = AboutManifest.buildAboutModel(this.type);
        }
        if (key != null && value != null) {
            model = model.filterPropertyByKeyValue(value, key);
        } else if (key != null) {
            model = model.filterPropertyByKey(key);
        } else if (value != null) {
            model = model.filterPropertyByValue(value);
        }
        if (model != null) {
            return model;
        }
        return AboutManifest.buildAboutModel(this.type);
    }

    private static ManifestLoader.AboutModel buildAboutModel(ManifestLoader.AboutModel.AboutModelType type) {
        if (type.equals((Object)ManifestLoader.AboutModel.AboutModelType.RESOURCES)) {
            return ManifestLoader.getResources();
        }
        return ManifestLoader.getVersions();
    }

    protected void configureXStream(XStream xs) {
        xs.processAnnotations(ManifestLoader.AboutModel.class);
        xs.allowTypes(new Class[]{ManifestLoader.AboutModel.class});
        xs.addImplicitCollection(ManifestLoader.AboutModel.class, "manifests");
        xs.alias("about", ManifestLoader.AboutModel.class);
        xs.registerConverter(new Converter(){

            public boolean canConvert(Class type) {
                return type.equals(ManifestLoader.AboutModel.ManifestModel.class);
            }

            public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
                ManifestLoader.AboutModel.ManifestModel model = (ManifestLoader.AboutModel.ManifestModel)source;
                writer.addAttribute("name", model.getName());
                for (Map.Entry entry : model.getEntries().entrySet()) {
                    context.convertAnother(entry, new Converter(){

                        public boolean canConvert(Class type) {
                            return Map.Entry.class.isAssignableFrom(type);
                        }

                        public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
                            Map.Entry e = (Map.Entry)source;
                            writer.startNode((String)e.getKey());
                            writer.setValue((String)e.getValue());
                            writer.endNode();
                        }

                        public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
                            throw new UnsupportedOperationException("Not implemented");
                        }
                    });
                }
            }

            public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
                throw new UnsupportedOperationException("Not implemented");
            }
        });
        xs.alias("resource", ManifestLoader.AboutModel.ManifestModel.class);
        xs.addImplicitCollection(ManifestLoader.AboutModel.ManifestModel.class, "entries");
        xs.useAttributeFor(ManifestLoader.AboutModel.ManifestModel.class, "name");
        xs.alias("property", Map.Entry.class);
        xs.autodetectAnnotations(true);
    }

    protected void handleObjectPut(Object obj) throws Exception {
        throw new UnsupportedOperationException("Not allowed");
    }

    private static class AboutHTMLFormat
    extends CatalogFreemarkerHTMLFormat {
        public AboutHTMLFormat(Request request, Response response, Resource resource) {
            super(ManifestLoader.AboutModel.class, request, response, resource);
        }

        @Override
        protected Configuration createConfiguration(Object data, Class clazz) {
            Configuration cfg = super.createConfiguration(data, clazz);
            cfg.setClassForTemplateLoading(((Object)((Object)this)).getClass(), "templates");
            cfg.setObjectWrapper((ObjectWrapper)new ReflectiveHTMLFormat.ObjectToMapWrapper<ManifestLoader.AboutModel>(ManifestLoader.AboutModel.class){

                protected void wrapInternal(Map properties, SimpleHash model, ManifestLoader.AboutModel object) {
                    ArrayList manifests = new ArrayList();
                    for (ManifestLoader.AboutModel.ManifestModel manifest : object.getManifests()) {
                        HashMap<String, Object> map = new HashMap<String, Object>();
                        map.put("name", manifest.getName());
                        ArrayList<String> props = new ArrayList<String>();
                        map.put("properties", props);
                        ArrayList values = new ArrayList();
                        map.put("valuez", values);
                        for (String key : manifest.getEntries().keySet()) {
                            props.add(key);
                            values.add(manifest.getEntries().get(key));
                        }
                        manifests.add(map);
                    }
                    properties.put("manifests", manifests);
                }
            });
            return cfg;
        }
    }
}

